/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.stringSearch;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class StringCutter
implements Enumeration,
Iterator {
    protected String tokenizedText;
    protected int strLength;
    protected String nontokenDelims;
    protected String tokenDelims;
    protected int pos;
    protected boolean emptyReturned;
    protected char maxDelimChar;
    protected boolean returnEmptyTokens;
    protected int delimsChangedPosition;
    protected int tokenCount;

    public StringCutter(String value, String nontokenDelims, String tokenDelims) {
        this(value, nontokenDelims, tokenDelims, false);
    }

    public StringCutter(String value, String nontokenDelims, String tokenDelims, boolean returnEmptyTokens) {
        this.setDelims(nontokenDelims, tokenDelims);
        this.setString(value);
        this.returnEmptyTokens(returnEmptyTokens);
    }

    public StringCutter(String value, String delims, boolean delimsAreTokens) {
        this(value, delimsAreTokens ? null : delims, delimsAreTokens ? delims : null);
    }

    public StringCutter(String value, String nontokenDelims) {
        this(value, nontokenDelims, null);
    }

    public StringCutter(String value) {
        this(value, " \t\n\r\f", null);
    }

    public void setString(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.tokenizedText = value;
        this.strLength = value.length();
        this.emptyReturned = false;
        this.pos = this.strLength > 0 ? 0 : -1;
        this.delimsChangedPosition = 0;
        this.tokenCount = -1;
    }

    private void setDelims(String nontokenDelims, String tokenDelims) {
        int i;
        this.nontokenDelims = nontokenDelims;
        this.tokenDelims = tokenDelims;
        this.delimsChangedPosition = this.pos != -1 ? this.pos : this.strLength;
        this.maxDelimChar = '\u0000';
        for (i = 0; nontokenDelims != null && i < nontokenDelims.length(); ++i) {
            if (this.maxDelimChar >= nontokenDelims.charAt(i)) continue;
            this.maxDelimChar = nontokenDelims.charAt(i);
        }
        for (i = 0; tokenDelims != null && i < tokenDelims.length(); ++i) {
            if (this.maxDelimChar >= tokenDelims.charAt(i)) continue;
            this.maxDelimChar = tokenDelims.charAt(i);
        }
        this.tokenCount = -1;
    }

    public boolean hasMoreTokens() {
        if (this.tokenCount == 0) {
            return false;
        }
        if (this.tokenCount > 0) {
            return true;
        }
        int savedPosition = this.pos;
        boolean savedEmptyReturned = this.emptyReturned;
        int workingPosition = this.pos;
        boolean workingEmptyReturned = this.emptyReturned;
        boolean onToken = this.advancePosition();
        while (this.pos != workingPosition || this.emptyReturned != workingEmptyReturned) {
            if (onToken) {
                this.pos = savedPosition;
                this.emptyReturned = savedEmptyReturned;
                return true;
            }
            workingPosition = this.pos;
            workingEmptyReturned = this.emptyReturned;
            onToken = this.advancePosition();
        }
        this.pos = savedPosition;
        this.emptyReturned = savedEmptyReturned;
        return false;
    }

    public String nextToken() {
        int workingPosition = this.pos;
        boolean workingEmptyReturned = this.emptyReturned;
        boolean onToken = this.advancePosition();
        while (this.pos != workingPosition || this.emptyReturned != workingEmptyReturned) {
            if (onToken) {
                --this.tokenCount;
                return this.emptyReturned ? "" : this.tokenizedText.substring(workingPosition, this.pos != -1 ? this.pos : this.strLength);
            }
            workingPosition = this.pos;
            workingEmptyReturned = this.emptyReturned;
            onToken = this.advancePosition();
        }
        throw new NoSuchElementException();
    }

    public boolean skipDelimiters() {
        int workingPosition = this.pos;
        boolean workingEmptyReturned = this.emptyReturned;
        boolean onToken = this.advancePosition();
        this.tokenCount = -1;
        while (this.pos != workingPosition || this.emptyReturned != workingEmptyReturned) {
            if (onToken) {
                this.pos = workingPosition;
                this.emptyReturned = workingEmptyReturned;
                return true;
            }
            workingPosition = this.pos;
            workingEmptyReturned = this.emptyReturned;
            onToken = this.advancePosition();
        }
        return false;
    }

    public int countTokens() {
        if (this.tokenCount >= 0) {
            return this.tokenCount;
        }
        int tokenCount = 0;
        int savedPosition = this.pos;
        boolean savedEmptyReturned = this.emptyReturned;
        int workingPosition = this.pos;
        boolean workingEmptyReturned = this.emptyReturned;
        boolean onToken = this.advancePosition();
        while (this.pos != workingPosition || this.emptyReturned != workingEmptyReturned) {
            if (onToken) {
                ++tokenCount;
            }
            workingPosition = this.pos;
            workingEmptyReturned = this.emptyReturned;
            onToken = this.advancePosition();
        }
        this.pos = savedPosition;
        this.emptyReturned = savedEmptyReturned;
        this.tokenCount = tokenCount;
        return tokenCount;
    }

    public void setDelimiters(String delimiters) {
        this.setDelims(delimiters, null);
    }

    public void setDelimiters(String delimiters, boolean delimsAreTokens) {
        this.setDelims(delimsAreTokens ? null : delimiters, delimsAreTokens ? delimiters : null);
    }

    public void setDelimiters(String nontokenDelims, String tokenDelims) {
        this.setDelims(nontokenDelims, tokenDelims);
    }

    public void setDelimiters(String nontokenDelims, String tokenDelims, boolean returnEmptyTokens) {
        this.setDelims(nontokenDelims, tokenDelims);
        this.returnEmptyTokens(returnEmptyTokens);
    }

    public int countTokens(String delims) {
        this.setDelims(delims, null);
        return this.countTokens();
    }

    public int countTokens(String delimiters, boolean delimsAreTokens) {
        this.setDelims(delimsAreTokens ? null : delimiters, delimsAreTokens ? delimiters : null);
        return this.countTokens();
    }

    public int countTokens(String nontokenDelims, String tokenDelims) {
        this.setDelims(nontokenDelims, tokenDelims);
        return this.countTokens();
    }

    public int countTokens(String nontokenDelims, String tokenDelims, boolean returnEmptyTokens) {
        this.setDelims(nontokenDelims, tokenDelims);
        this.returnEmptyTokens(returnEmptyTokens);
        return this.countTokens();
    }

    private boolean advancePosition() {
        char c;
        if (this.returnEmptyTokens && !this.emptyReturned && (this.delimsChangedPosition == this.pos || this.pos == -1 && this.strLength == this.delimsChangedPosition)) {
            if (this.strLength == this.delimsChangedPosition) {
                this.emptyReturned = true;
                return true;
            }
            c = this.tokenizedText.charAt(this.pos);
            if (c <= this.maxDelimChar && this.nontokenDelims != null && this.nontokenDelims.indexOf(c) != -1 || this.tokenDelims != null && this.tokenDelims.indexOf(c) != -1) {
                this.emptyReturned = true;
                return true;
            }
        }
        if (this.pos != -1) {
            int nextDelimiter;
            c = this.tokenizedText.charAt(this.pos);
            if (this.returnEmptyTokens && !this.emptyReturned && this.pos > this.delimsChangedPosition) {
                char c1 = this.tokenizedText.charAt(this.pos - 1);
                if (c <= this.maxDelimChar && c1 <= this.maxDelimChar && (this.nontokenDelims != null && this.nontokenDelims.indexOf(c) != -1 || this.tokenDelims != null && this.tokenDelims.indexOf(c) != -1) && (this.nontokenDelims != null && this.nontokenDelims.indexOf(c1) != -1 || this.tokenDelims != null && this.tokenDelims.indexOf(c1) != -1)) {
                    this.emptyReturned = true;
                    return true;
                }
            }
            int n = nextDelimiter = this.pos < this.strLength - 1 ? this.indexOfNextDelimiter(this.pos + 1) : -1;
            if (c > this.maxDelimChar || (this.nontokenDelims == null || this.nontokenDelims.indexOf(c) == -1) && (this.tokenDelims == null || this.tokenDelims.indexOf(c) == -1)) {
                this.pos = nextDelimiter;
                this.emptyReturned = false;
                return true;
            }
            if (this.tokenDelims != null && this.tokenDelims.indexOf(c) != -1) {
                this.emptyReturned = false;
                this.pos = this.pos < this.strLength - 1 ? this.pos + 1 : -1;
                return true;
            }
            this.emptyReturned = false;
            this.pos = this.pos < this.strLength - 1 ? this.pos + 1 : -1;
            return false;
        }
        if (this.returnEmptyTokens && !this.emptyReturned && this.strLength > 0 && ((c = this.tokenizedText.charAt(this.strLength - 1)) <= this.maxDelimChar && this.nontokenDelims != null && this.nontokenDelims.indexOf(c) != -1 || this.tokenDelims != null && this.tokenDelims.indexOf(c) != -1)) {
            this.emptyReturned = true;
            return true;
        }
        return false;
    }

    public String nextToken(String nontokenDelims, String tokenDelims) {
        this.setDelims(nontokenDelims, tokenDelims);
        return this.nextToken();
    }

    public String nextToken(String nontokenDelims, String tokenDelims, boolean returnEmptyTokens) {
        this.setDelims(nontokenDelims, tokenDelims);
        this.returnEmptyTokens(returnEmptyTokens);
        return this.nextToken();
    }

    public String nextToken(String delims, boolean delimsAreTokens) {
        return delimsAreTokens ? this.nextToken(null, delims) : this.nextToken(delims, null);
    }

    public String nextToken(String nontokenDelims) {
        return this.nextToken(nontokenDelims, null);
    }

    private int indexOfNextDelimiter(int start) {
        char c;
        int next = start;
        while ((c = this.tokenizedText.charAt(next)) > this.maxDelimChar || (this.nontokenDelims == null || this.nontokenDelims.indexOf(c) == -1) && (this.tokenDelims == null || this.tokenDelims.indexOf(c) == -1)) {
            if (next == this.strLength - 1) {
                return -1;
            }
            ++next;
        }
        return next;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public boolean hasNext() {
        return this.hasMoreTokens();
    }

    public Object next() {
        return this.nextToken();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void returnEmptyTokens(boolean returnEmptyTokens) {
        this.tokenCount = -1;
        this.returnEmptyTokens = returnEmptyTokens;
    }

    public int currentPosition() {
        return this.pos;
    }

    public String[] toArray() {
        String[] tokenArray = new String[this.countTokens()];
        int i = 0;
        while (this.hasMoreTokens()) {
            tokenArray[i] = this.nextToken();
            ++i;
        }
        return tokenArray;
    }

    public String remainingText() {
        return this.nextToken(null, null);
    }

    public String peek() {
        int savedPosition = this.pos;
        boolean savedEmptyReturned = this.emptyReturned;
        int savedtokenCount = this.tokenCount;
        String retval = this.nextToken();
        this.pos = savedPosition;
        this.emptyReturned = savedEmptyReturned;
        this.tokenCount = savedtokenCount;
        return retval;
    }
}

