/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.undo;

import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.ComplexVisualizer;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.util.undo.JAXFrontUndoManager;
import com.jaxfront.core.util.undo.JAXFrontUndoableEditWrapper;
import java.io.PrintWriter;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ChangeSerializationUndoableEditWrapper
extends JAXFrontUndoableEditWrapper {
    private boolean _oldV = false;
    private boolean _newV = false;

    public ChangeSerializationUndoableEditWrapper(JAXFrontUndoManager manager, Object eventSource, Type target, boolean newValue, boolean oldValue) {
        super(manager, target);
        this._sourceType = eventSource;
        this._oldV = oldValue;
        this._newV = newValue;
    }

    public ChangeSerializationUndoableEditWrapper(JAXFrontUndoManager manager, Object eventSource, String target, boolean newValue, boolean oldValue) {
        super(manager, target);
        this._sourceType = eventSource;
        this._oldV = oldValue;
        this._newV = newValue;
    }

    public String getPresentationName() {
        return "Shit";
    }

    public void redo() throws CannotRedoException {
        super.redo();
        Type tt = this.evalTargetType();
        if (tt != null) {
            this.startBlocking();
            if (this._newV) {
                this.doSerialize(tt);
            } else {
                this.dontSerialize(tt);
            }
            this.stopBlocking();
            this.visualizeRedo(tt);
            this._manager.fireUndoableEditUpdate(new UndoableEditEvent(tt, this));
        }
    }

    public void undo() throws CannotUndoException {
        super.undo();
        Type tt = this.evalTargetType();
        if (tt != null) {
            this.startBlocking();
            if (this._oldV) {
                this.doSerialize(tt);
            } else {
                this.dontSerialize(tt);
            }
            this.stopBlocking();
            this.visualizeUndo(tt);
            this._manager.fireUndoableEditUpdate(new UndoableEditEvent(tt, this));
        }
    }

    public void serialize(PrintWriter writer) {
        super.serialize(writer);
        writer.print(this._oldV);
        writer.print(";");
        writer.print(this._newV);
    }

    public void dontSerialize(Type target) {
        if (target != null) {
            ((ComplexVisualizer)((Object)TypeVisualizerFactory.getInstance().getVisualizer(target))).doUserSerialization(false);
        }
    }

    public void doSerialize(Type target) {
        if (target != null) {
            ((ComplexVisualizer)((Object)TypeVisualizerFactory.getInstance().getVisualizer(target))).doUserSerialization(true);
        }
    }
}

