/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.undo;

import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.util.undo.JAXFrontUndoManager;
import com.jaxfront.core.util.undo.JAXFrontUndoableEditWrapper;
import java.io.PrintWriter;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ListMoveUndoableEditWrapper
extends JAXFrontUndoableEditWrapper {
    private int _listFromIndex = -1;
    private int _listToIndex = -1;
    private String _fromTypeXPath = null;
    private String _toTypeXPath = null;

    public ListMoveUndoableEditWrapper(JAXFrontUndoManager manager, Object eventSource, ListType target, int fromIndex, int toIndex) {
        super(manager, target);
        this._sourceType = eventSource;
        this._listFromIndex = fromIndex;
        this._listToIndex = toIndex;
        Type fromType = (Type)target.get(this._listFromIndex);
        Type toType = (Type)target.get(this._listToIndex);
        this._fromTypeXPath = fromType == null ? null : fromType.getXPathLocation();
        this._toTypeXPath = toType == null ? null : toType.getXPathLocation();
    }

    public ListMoveUndoableEditWrapper(JAXFrontUndoManager manager, Object eventSource, String target, int fromIndex, int toIndex) {
        super(manager, target);
        this._sourceType = eventSource;
        this._listFromIndex = fromIndex;
        this._listToIndex = toIndex;
    }

    public void die() {
        super.die();
    }

    public String getPresentationName() {
        return "Shit";
    }

    public String getRedoPresentationName() {
        return super.getUndoPresentationName() + ":" + this._action;
    }

    public String getUndoPresentationName() {
        return super.getUndoPresentationName() + ":" + this._action;
    }

    public boolean canRedo() {
        boolean can = super.canRedo() && this._listFromIndex >= 0 && this._listToIndex >= 0;
        return can;
    }

    public boolean canUndo() {
        boolean can = super.canRedo() && this._listFromIndex >= 0 && this._listToIndex >= 0;
        return can;
    }

    public void redo() throws CannotRedoException {
        super.redo();
        Type tt = this.evalTargetType();
        if (tt != null) {
            this.startBlocking();
            int fromIndex = this._listFromIndex;
            int toIndex = this._listToIndex;
            ((ListType)tt).swap(fromIndex, toIndex);
            TypeVisualizerFactory.getInstance().populateAllVisualizerForType(tt);
            this.stopBlocking();
            this.visualizeRedo(tt);
            this._manager.fireUndoableEditUpdate(new UndoableEditEvent(tt, this));
        }
    }

    public void undo() throws CannotUndoException {
        super.undo();
        Type tt = this.evalTargetType();
        if (tt != null) {
            this.startBlocking();
            boolean wasBlocked = this._manager.isBlocked();
            this._manager.blockInput(true);
            ((ListType)tt).swap(this._listToIndex, this._listFromIndex);
            if (!wasBlocked) {
                this._manager.blockInput(false);
            }
            TypeVisualizerFactory.getInstance().populateAllVisualizerForType(tt);
            this.stopBlocking();
            this.visualizeUndo(tt);
            this._manager.fireUndoableEditUpdate(new UndoableEditEvent(tt, this));
        }
    }

    public void serialize(PrintWriter writer) {
        super.serialize(writer);
        if (this._fromTypeXPath != null) {
            writer.print(this._fromTypeXPath);
        }
        writer.print(";");
        if (this._toTypeXPath != null) {
            writer.print(this._toTypeXPath);
        }
        writer.print("<listFromIndex>");
        writer.print(this._listFromIndex);
        writer.print("</listFromIndex>");
        writer.print("<listToIndex>");
        writer.print(this._listToIndex);
        writer.print("</listToIndex>");
    }
}

