/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.undo;

import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.undo.JAXFrontUndoManager;
import com.jaxfront.core.util.undo.JAXFrontUndoableEditWrapper;
import java.io.PrintWriter;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class PropertyChangeUndoableEditWrapper
extends JAXFrontUndoableEditWrapper
implements UndoableEdit {
    String _oldV = null;
    String _newV = null;

    public PropertyChangeUndoableEditWrapper(JAXFrontUndoManager manager, Object eventSource, SimpleType target, String newValue, String oldValue) {
        super(manager, target);
        this._sourceType = eventSource;
        this._oldV = oldValue;
        this._newV = newValue;
    }

    public PropertyChangeUndoableEditWrapper(JAXFrontUndoManager manager, Object eventSource, String target, String newValue, String oldValue) {
        super(manager, target);
        this._sourceType = eventSource;
        this._oldV = oldValue;
        this._newV = newValue;
    }

    public void die() {
        super.die();
        this._oldV = null;
        this._newV = null;
    }

    public String getPresentationName() {
        return "Shit";
    }

    public String getRedoPresentationName() {
        return super.getUndoPresentationName() + ":" + (this._newV != null ? this._newV : "");
    }

    public String getUndoPresentationName() {
        return super.getUndoPresentationName() + ":" + (this._oldV != null ? this._oldV : "");
    }

    public void redo() throws CannotRedoException {
        super.redo();
        Type tt = this.evalTargetType();
        if (tt != null) {
            this.startBlocking();
            ((SimpleType)tt).setValue(JAXFrontUndoManager.class, this._newV, false, false);
            this.stopBlocking();
            this.visualizeRedo(tt);
            this._manager.fireUndoableEditUpdate(new UndoableEditEvent(tt, this));
        }
    }

    public void undo() throws CannotUndoException {
        super.undo();
        Type tt = this.evalTargetType();
        if (tt != null) {
            this.startBlocking();
            ((SimpleType)tt).setValue(JAXFrontUndoManager.class, this._oldV, false, false);
            this.stopBlocking();
            this.visualizeUndo(tt);
            this._manager.fireUndoableEditUpdate(new UndoableEditEvent(tt, this));
        }
    }

    public void serialize(PrintWriter writer) {
        super.serialize(writer);
        writer.print("<oldValue>");
        writer.print(this._oldV != null ? this._oldV : "");
        writer.print("</oldValue>");
        writer.print("<newValue>");
        writer.print(this._newV != null ? this._newV : "");
        writer.print("</newValue>");
    }
}

