/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xpath;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.type.AbstractType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.xpath.DummyParentTypeIterator;
import com.jaxfront.core.xpath.DummyTypeIterator;
import com.jaxfront.core.xpath.ParentTypeIterator2;
import com.jaxfront.core.xpath.ResetIterator;
import com.jaxfront.core.xpath.SelfAxisIterator;
import com.jaxfront.core.xpath.TypeAttributeIterator;
import com.jaxfront.core.xpath.TypeIterator;
import com.jaxfront.core.xpath.TypeXPath;
import java.util.Iterator;
import org.jaxen.DefaultNavigator;
import org.jaxen.Navigator;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.XPath;
import org.jaxen.saxpath.SAXPathException;

public class DocumentNavigator
extends DefaultNavigator {
    boolean _listTypeIncluded = true;
    boolean _idOnly = false;
    boolean _editingTypeIncluded = true;
    boolean _editingTypeTraversalOnly = false;
    boolean _onlySerializable = false;
    boolean _choosenOnly = false;
    boolean _hideUnnamed = false;
    Integer _secCacheKey = new Integer(0);
    private boolean _buildLazyChoices = false;
    private static final DocumentNavigator SINGLETON = new DocumentNavigator();

    public static Navigator getInstance() {
        return SINGLETON;
    }

    public Object getDocumentNode(Object contextNode) {
        return contextNode instanceof Type ? ((Type)contextNode).getDOM() : null;
    }

    public void reset() {
        this._listTypeIncluded = false;
        this._editingTypeIncluded = false;
        this._editingTypeTraversalOnly = false;
        this.setBuildLazyChoices(false);
    }

    public Iterator getParentAxisIterator(Object contextNode) throws UnsupportedAxisException {
        if (contextNode instanceof Document) {
            return new DummyParentTypeIterator(((Document)contextNode).getRootType());
        }
        if (contextNode != null && ((Type)contextNode).getDOM() != null) {
            Type aType = (Type)contextNode;
            Document dom = aType.getDOM();
            if (dom.parentCache != null) {
                ResetIterator it = (ResetIterator)aType.getDOM().parentCache.get(contextNode, this._secCacheKey);
                if (it == null) {
                    it = new ParentTypeIterator2((Type)contextNode, this._listTypeIncluded, this._editingTypeIncluded, this._onlySerializable);
                    aType.getDOM().parentCache.put(contextNode, this._secCacheKey, it);
                } else {
                    it.reset();
                }
                return it;
            }
            return new ParentTypeIterator2((Type)contextNode, this._listTypeIncluded, this._editingTypeIncluded, this._onlySerializable);
        }
        return new ParentTypeIterator2((Type)contextNode, this._listTypeIncluded, this._editingTypeIncluded, this._onlySerializable);
    }

    public Iterator getAttributeAxisIterator(Object contextNode) throws UnsupportedAxisException {
        if (contextNode instanceof Document) {
            return new DummyTypeIterator(((Document)contextNode).getRootType());
        }
        return new TypeAttributeIterator((Type)contextNode, this._onlySerializable);
    }

    public Iterator getChildAxisIterator(Object contextNode) throws UnsupportedAxisException {
        if (contextNode instanceof Document) {
            return new DummyTypeIterator(((Document)contextNode).getRootType());
        }
        if (contextNode != null && ((Type)contextNode).getDOM() != null) {
            Type aType = (Type)contextNode;
            Document dom = aType.getDOM();
            if (dom.itCache != null) {
                TypeIterator it = (TypeIterator)aType.getDOM().itCache.get(contextNode, this._secCacheKey);
                if (it == null) {
                    it = new TypeIterator(aType, this._listTypeIncluded, this._editingTypeIncluded, this._editingTypeTraversalOnly, this._onlySerializable, this._buildLazyChoices, this._idOnly, this._choosenOnly, this._hideUnnamed);
                    aType.getDOM().itCache.put(contextNode, this._secCacheKey, it);
                } else {
                    it.reset();
                }
                return it;
            }
            return new TypeIterator(aType, this._listTypeIncluded, this._editingTypeIncluded, this._editingTypeTraversalOnly, this._onlySerializable, this._buildLazyChoices, this._idOnly, this._choosenOnly, this._hideUnnamed);
        }
        return new TypeIterator((Type)contextNode, this._listTypeIncluded, this._editingTypeIncluded, this._editingTypeTraversalOnly, this._onlySerializable, this._buildLazyChoices, this._idOnly, this._choosenOnly, this._hideUnnamed);
    }

    public String getElementNamespaceUri(Object element, boolean defaultStepIsPrefixed) {
        Type aNodeType = (Type)element;
        if (aNodeType.isGlobal()) {
            return null;
        }
        if (!defaultStepIsPrefixed && (aNodeType.getSchemaElement().isGlobalReference() || aNodeType.getSchemaElement().isGlobal() || aNodeType.getNamespace() == aNodeType.getDOM().getSchema().getTargetNamespace())) {
            return null;
        }
        return ((Type)element).getNamespace();
    }

    private void create2CacheKey() {
        int key = 0;
        if (this._listTypeIncluded) {
            ++key;
        }
        if (this._idOnly) {
            key += 2;
        }
        if (this._editingTypeIncluded) {
            key += 4;
        }
        if (this._editingTypeTraversalOnly) {
            key += 8;
        }
        if (this._onlySerializable) {
            key += 16;
        }
        if (this._buildLazyChoices) {
            key += 32;
        }
        if (this._choosenOnly) {
            key += 64;
        }
        this._secCacheKey = new Integer(key);
    }

    public String getElementName(Object element) {
        if (((Type)element).isDerived()) {
            return ((Type)element).getParent().getName();
        }
        return ((Type)element).getName();
    }

    public String getElementQName(Object element) {
        if (((AbstractType)element).isDerived()) {
            return ((Type)element).getParent().getName();
        }
        return ((Type)element).getName();
    }

    public String getAttributeNamespaceUri(Object attr) {
        return ((Type)attr).getNamespace();
    }

    public String getAttributeName(Object attr) {
        return ((Type)attr).getName();
    }

    public String getAttributeQName(Object attr) {
        return ((Type)attr).getName();
    }

    public boolean isDocument(Object object) {
        return object instanceof Document;
    }

    public boolean isElement(Object object) {
        return object instanceof Type && !((Type)object).isAttribute();
    }

    public boolean isAttribute(Object object) {
        return object instanceof Type && ((Type)object).isAttribute();
    }

    public boolean isNamespace(Object object) {
        return false;
    }

    public boolean isComment(Object object) {
        return false;
    }

    public boolean isText(Object object) {
        if (object instanceof Type && ((Type)object).isSimple()) {
            return ((SimpleType)object).isSimpleContent();
        }
        return false;
    }

    public boolean isProcessingInstruction(Object object) {
        return false;
    }

    public String getCommentStringValue(Object comment) {
        if (comment != null && comment instanceof Type) {
            return DOMHelper.getAnnotation((Type)comment);
        }
        return null;
    }

    public String getElementStringValue(Object element) {
        Type type = (Type)element;
        if (type.isSimple()) {
            String value = ((SimpleType)type).getValue();
            if (value == null) {
                return "NULL";
            }
            return value;
        }
        return "";
    }

    public String getAttributeStringValue(Object attr) {
        Type type = (Type)attr;
        if (type.isAttribute()) {
            String value = ((SimpleType)type).getValue();
            if (value == null) {
                return "NULL";
            }
            return value;
        }
        return null;
    }

    public String getNamespaceStringValue(Object ns) {
        return null;
    }

    public String getTextStringValue(Object txt) {
        if (txt != null) {
            if (txt instanceof SimpleType) {
                String value = ((SimpleType)txt).getValue();
                return value != null ? value.toString() : "";
            }
            return txt.toString();
        }
        return null;
    }

    public String getNamespacePrefix(Object ns) {
        return ((Type)ns).getSchemaElement().getNamespacePrefix();
    }

    public void setListTypeIncluded(boolean included) {
        this._listTypeIncluded = included;
        this.create2CacheKey();
    }

    public void setIDOnly(boolean idOnly) {
        this._idOnly = idOnly;
        this.create2CacheKey();
    }

    public void setEditingTypeIncluded(boolean included) {
        this._editingTypeIncluded = included;
        this.create2CacheKey();
    }

    public void setOnlySerializable(boolean onlySerializable) {
        this._onlySerializable = onlySerializable;
        this.create2CacheKey();
    }

    public void setEditingTypeTraversalOnly(boolean only) {
        this._editingTypeTraversalOnly = only;
        this.create2CacheKey();
    }

    public XPath parseXPath(String xpath) throws SAXPathException {
        return new TypeXPath(xpath);
    }

    public Iterator getSelfAxisIterator(Object contextNode) throws UnsupportedAxisException {
        return new SelfAxisIterator(contextNode, this._onlySerializable);
    }

    void setBuildLazyChoices(boolean _buildLazyChoices) {
        this._buildLazyChoices = _buildLazyChoices;
        this.create2CacheKey();
    }

    public void setChoosenOnly(boolean choosenOnly) {
        this._choosenOnly = choosenOnly;
        this.create2CacheKey();
    }

    public void setHideUnnamed(boolean hide) {
        this._hideUnnamed = hide;
    }

    public boolean isHideUnnamed() {
        return this._hideUnnamed;
    }

    public String getElementNamespaceUri(Object element) {
        return this.getElementNamespaceUri(element, false);
    }
}

