/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xpath;

import com.jaxfront.core.schema.SchemaComplexType;
import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.schema.SchemaSimpleType;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.xpath.ResetIterator;
import com.jaxfront.core.xpath.XPathDummyChoiceTypeWrapper;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;

public class TypeIterator
implements ResetIterator {
    private Object[] types;
    int currentPos = 0;
    public int elementCount = 0;
    private Type node;
    private boolean _listTypeIncluded = true;
    private boolean _idOnly = false;
    private boolean _editingTypeIncluded = true;
    private boolean _editingTypeTraversalOnly = false;
    private boolean _onlySerializable = false;
    private boolean _buildLazyChoices = false;
    private boolean _hideUnnamed = false;
    boolean _choosenOnly = false;

    public TypeIterator(Type contextType, boolean listTypeIncluded, boolean editingTypeIncluded, boolean editingTypeTraversalOnly, boolean choosenTypeOnly, boolean buildLazyChoices) {
        this(contextType, listTypeIncluded, editingTypeIncluded, editingTypeTraversalOnly, choosenTypeOnly, buildLazyChoices, false, false, false);
    }

    public TypeIterator(Type contextType, boolean listTypeIncluded, boolean editingTypeIncluded, boolean editingTypeTraversalOnly, boolean onlySerializable, boolean buildLazyChoices, boolean idOnly, boolean choosenOnly, boolean hideUnnamed) {
        this._editingTypeTraversalOnly = editingTypeTraversalOnly;
        this._listTypeIncluded = listTypeIncluded;
        this._idOnly = idOnly;
        this._editingTypeIncluded = editingTypeIncluded;
        this._onlySerializable = onlySerializable;
        this._buildLazyChoices = buildLazyChoices;
        this._choosenOnly = choosenOnly;
        this._hideUnnamed = hideUnnamed;
        if (contextType != null) {
            this.initChilds(contextType);
            this.node = this.getFirstNode(contextType);
            ++this.currentPos;
            while (!this.isXPathNode(this.node)) {
                this.node = this.getNextNode(this.node);
            }
        }
    }

    public boolean hasNext() {
        return this.node != null;
    }

    public Object next() {
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        Type ret = this.node;
        this.node = this.getNextNode(this.node);
        while (!this.isXPathNode(this.node)) {
            this.node = this.getNextNode(this.node);
        }
        return ret;
    }

    private void initChilds(Type aType) {
        Vector<Type> directChilds = null;
        if (this._buildLazyChoices && aType.isChoice() && !aType.isSimple()) {
            SchemaNode[] schemaElements = ((SchemaComplexType)aType.getSchemaElement().getSchemaType()).getElementSet();
            directChilds = new Vector(schemaElements.length);
            for (int i = 0; i < schemaElements.length; ++i) {
                this.addChild(new XPathDummyChoiceTypeWrapper((CompositeType)aType, schemaElements[i]));
            }
            return;
        }
        if (this._choosenOnly && aType.isChoice()) {
            Type choosenType = aType.getChoosenType();
            directChilds = new Vector<Type>(1);
            if (choosenType != null) {
                directChilds.add(choosenType);
            }
        } else {
            directChilds = this.getDirectChildren(aType);
        }
        for (int i = 0; i < directChilds.size(); ++i) {
            Type aChildType = (Type)directChilds.get(i);
            if (this._idOnly && aChildType.getSchemaElement().getSchemaType().isSimple()) {
                if (!((SchemaSimpleType)aChildType.getSchemaElement().getSchemaType()).isID()) continue;
                this.addChild(aChildType);
                continue;
            }
            if (!this._editingTypeIncluded && aChildType.isAttribute()) continue;
            if (aChildType.isList()) {
                if (!this._editingTypeTraversalOnly) {
                    if (((ListType)aChildType).getDirectChildrenSize() > 0) {
                        Iterator listEntries = ((ListType)aChildType).getDirectChildren().iterator();
                        Type listEntry = null;
                        while (listEntries.hasNext()) {
                            listEntry = (Type)listEntries.next();
                            if (this._onlySerializable) {
                                if (!listEntry.isSerializable()) continue;
                                this.addChild(listEntry);
                                continue;
                            }
                            this.addChild(listEntry);
                        }
                    }
                    if (this._listTypeIncluded) {
                        this.addChild(aChildType);
                    }
                }
                if (!this._editingTypeIncluded) continue;
                Type editingType = ((ListType)aChildType).getEditingType();
                this.addChild(editingType);
                continue;
            }
            if (this._onlySerializable) {
                if (!aChildType.isSerializable()) continue;
                this.addChild(aChildType);
                continue;
            }
            this.addChild(aChildType);
        }
    }

    public void remove() {
        this.node = null;
    }

    public void reset() {
        this.currentPos = 0;
        this.node = this.getFirstNode(null);
        ++this.currentPos;
        while (!this.isXPathNode(this.node)) {
            this.node = this.getNextNode(this.node);
        }
    }

    protected Type getFirstNode(Type contextNode) {
        if (this.types != null && this.types.length > 0) {
            return (Type)this.types[0];
        }
        return null;
    }

    protected Type getNextNode(Type contextNode) {
        if (this.types != null && this.currentPos < this.types.length) {
            return (Type)this.types[this.currentPos++];
        }
        return null;
    }

    private boolean isXPathNode(Type node) {
        if (node == null) {
            return true;
        }
        if (node.isComposite()) {
            return true;
        }
        if (node.isSimple()) {
            return true;
        }
        if (node.isAttribute()) {
            return true;
        }
        return node.isList();
    }

    private List getDirectChildren(Type aType) {
        Vector children = aType.getDirectChildren();
        if (aType.isAbstract()) {
            children = new Vector();
            if (aType.getChoosenType() != null) {
                children.addAll(aType.getChoosenType().getDirectChildren());
            }
        }
        return children;
    }

    public void addChild(Type aType) {
        if (this.types == null) {
            this.types = new Object[10];
        }
        if (this._hideUnnamed && !aType.isSimple() && aType.isAnonymous()) {
            this.initChilds(aType);
            return;
        }
        this.ensureCapacity(this.elementCount + 1);
        this.types[this.elementCount++] = aType;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.types.length;
        if (minCapacity > oldCapacity) {
            Object[] oldData = this.types;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.types = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.types, 0, this.elementCount);
        }
    }
}

