/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xpath;

import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.xpath.XPathError;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class XPNode {
    public static final String TEXT = "text()";
    private static final String PARENT = "..";
    private static final String ATTR = "@";
    private static final String SELF = ".";
    private static final char NS_SEP = ':';
    private static final char CLOSE_BRACKET = ']';
    private static final char OPEN_BRACKET = '[';
    private String _xNodeName;
    private String _xNodeNSPfix;
    private String _xNodeNSpace;
    private Object _userObject;
    public static final short LIST_NODE = 1;
    public static final short ATTR_NODE = 2;
    private boolean _isAsterix = false;
    public static final short SELF_NODE = 4;
    public static final short TEXT_NODE = 5;
    public static final short PARENT_NODE = 6;
    public static final short IDX_NODE = 7;
    public static final short ALL_NODE = 8;
    public static final short ASTERIX_NODE = 9;
    public static final short ASTERIX_ATTR_NODE = 10;
    public static final short DEFAULT_NODE = 0;
    private short _nodeType = 0;
    private String _xNodeExpression;
    private int _xNodeIDX = -1;
    protected int _endPos = 0;
    private List _childs = null;
    private List _sameAxis = null;

    public XPNode(String xNodeValue, int endPos, boolean check, Map nsMapping) throws XPathError {
        this(xNodeValue, check, nsMapping);
        this._endPos = endPos;
    }

    public XPNode(String xNodeValue, int endPos, boolean check) throws XPathError {
        this(xNodeValue, check);
        this._endPos = endPos;
    }

    public XPNode(String xNodeValue, boolean check) throws XPathError {
        this();
        this.parse(xNodeValue, check);
    }

    public XPNode(String xNodeValue, boolean check, Map nsMappings) throws XPathError {
        this();
        this.parse(xNodeValue, check, nsMappings);
    }

    public boolean isList() {
        return this._nodeType == 1;
    }

    public boolean isAttr() {
        return this._nodeType == 2;
    }

    protected void parse(String xNodeValue, boolean check) throws XPathError {
        this.parse(xNodeValue, check, null);
    }

    protected void parse(String xNodeValue, boolean check, Map nsMappings) throws XPathError {
        this._isAsterix = false;
        this._nodeType = 0;
        this._xNodeNSPfix = XPNode.extractNodeNS(xNodeValue);
        this._xNodeNSpace = this.translateNSPrefix(nsMappings);
        if (this._xNodeNSPfix != null) {
            String nn = xNodeValue.substring(this._xNodeNSPfix.length() + 1);
            this._xNodeName = XPNode.extractNodeName(0, nn);
        } else {
            this._xNodeName = XPNode.extractNodeName(0, xNodeValue);
        }
        if (this._xNodeName != null) {
            if (this._xNodeName.equals(SELF)) {
                this._nodeType = (short)4;
            } else if (PARENT.equals(this._xNodeName)) {
                this._nodeType = (short)6;
            } else if (TEXT.equalsIgnoreCase(this._xNodeName)) {
                this._nodeType = (short)5;
            } else if (this._xNodeName.length() == 0) {
                this._nodeType = (short)8;
            } else if (this._xNodeName.startsWith(ATTR)) {
                if (this._xNodeName.equals("@*")) {
                    this._isAsterix = true;
                    this._nodeType = (short)10;
                } else {
                    this._nodeType = (short)2;
                    this._xNodeName = this._xNodeName.substring(1);
                }
            }
            if (this._xNodeName.equals("*")) {
                this._isAsterix = true;
                this._nodeType = (short)9;
            }
        }
        this.setNodeExpression(XPNode.extractNodeExpression(this._xNodeName.length(), xNodeValue), check);
    }

    public XPNode() {
    }

    public String getNodeExpression() {
        return this._xNodeExpression;
    }

    public int getNodeIDX() {
        return this._xNodeIDX;
    }

    public String getNodeName() {
        return this._xNodeName;
    }

    public String getNodeNSpace() {
        return this._xNodeNSpace;
    }

    protected void setNodeName(String name) {
        this._xNodeName = name;
    }

    protected void setEndPos(int pos) {
        this._endPos = pos;
    }

    private static String extractNodeName(int start, String value) {
        int bIndex = value.indexOf(91, start);
        if (bIndex >= 0) {
            value = value.substring(start, bIndex);
        }
        return value;
    }

    private static String extractNodeNS(String value) {
        int nsIndex = value.lastIndexOf(58);
        if (nsIndex >= 0) {
            return value.substring(0, nsIndex);
        }
        return null;
    }

    private static String extractNodeExpression(int start, String value) {
        int lastBIndex = value.lastIndexOf(93);
        if (lastBIndex >= 0) {
            int firstBIndex = value.indexOf(91, start);
            return value.substring(firstBIndex + 1, lastBIndex);
        }
        return null;
    }

    protected XPNode getChild(String name) {
        if (this._childs != null) {
            for (int i = 0; i < this._childs.size(); ++i) {
                XPNode node = (XPNode)this._childs.get(i);
                if (!node.getNodeName().equals(name)) continue;
                return node;
            }
        }
        return null;
    }

    protected void addChild(XPNode node) {
        if (this._childs == null) {
            this._childs = new Vector();
        }
        this._childs.add(node);
    }

    protected void addSameAxis(XPNode node) {
        if (this._sameAxis == null) {
            this._sameAxis = new Vector();
        }
        this._sameAxis.add(node);
    }

    public boolean equals(Object arg0) {
        if (arg0 == this) {
            return true;
        }
        if (arg0 instanceof XPNode) {
            XPNode argNode = (XPNode)arg0;
            if (this._xNodeName == argNode._xNodeName && this._xNodeExpression == argNode._xNodeExpression) {
                return true;
            }
        }
        return false;
    }

    public void print(StringBuffer output) {
        output.append(this.getNodeName());
        output.append("->");
        if (this._childs != null) {
            for (int i = 0; i < this._childs.size(); ++i) {
                ((XPNode)this._childs.get(i)).print(output);
            }
        }
    }

    public Vector extractUserNodesAsSequence(Vector sequence) {
        int i;
        if (this.getUserObject() != null) {
            sequence.add(this.getUserObject());
        }
        for (i = 0; this._sameAxis != null && i < this._sameAxis.size(); ++i) {
            XPNode sa = (XPNode)this._sameAxis.get(i);
            if (sa.getUserObject() == null) continue;
            sequence.add(sa.getUserObject());
        }
        if (this._childs != null) {
            for (i = 0; i < this._childs.size(); ++i) {
                ((XPNode)this._childs.get(i)).extractUserNodesAsSequence(sequence);
            }
        }
        return sequence;
    }

    public String toString() {
        return this.getNodeName() + " exp:" + this.getNodeExpression() + " ns:" + this.getNodeNSPrefix();
    }

    public String getNodeNSPrefix() {
        return this._xNodeNSPfix;
    }

    public String translateNSPrefix(Map nsMappings) {
        String ns = null;
        if (nsMappings != null && this._xNodeNSPfix != null) {
            ns = (String)nsMappings.get(this._xNodeNSPfix);
        }
        return ns;
    }

    public Object getUserObject() {
        return this._userObject;
    }

    public void setUserObject(Object object) {
        this._userObject = object;
    }

    private void setNodeExpression(String exp, boolean check) throws XPathError {
        this._xNodeExpression = exp;
        if (exp != null) {
            if ("list".equals(exp)) {
                this._nodeType = 1;
            } else if (StringUtil.isInteger(exp)) {
                this._nodeType = (short)7;
                this._xNodeIDX = Integer.parseInt(exp);
            } else if (check) {
                throw new XPathError("expression is complex" + exp);
            }
        }
    }

    public boolean isIndexdNode() {
        return this._nodeType == 7;
    }

    public boolean isAsterix() {
        return this._isAsterix;
    }

    public boolean isAll() {
        return this._nodeType == 8;
    }

    public boolean isSelf() {
        return this._nodeType == 4;
    }

    public boolean isParent() {
        return this._nodeType == 6;
    }

    public boolean isText() {
        return this._nodeType == 5;
    }

    public short getNodeType() {
        return this._nodeType;
    }
}

