/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xsdgen;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.core.xsdgen.DTD2XS;
import java.io.File;
import java.io.FileWriter;
import java.net.URL;

public class DTD2XSD {
    private static DTD2XS translator = new DTD2XS(System.err);

    private static void usage() {
        System.err.println("usage: java dtd2xsd <options> <dtd file>\n<options>\n   -entity (Map DTD entity onto XML Schema <group>, <attributeGroup>, <simpleType>)\n   -comment <parameters> (Map DTD comment onto XML Schema <documentation> according to subsequent parameters)\n<parameters>\n   - (100), 1000 ... (Comments with more characters are ignored)\n   - (undefined), en (English), de (German), fr (French) ... (Language of comments)\n   - (\"element attribute\") ... (XML Schema concepts to annotate)\n   - (no), 1 (by space/punctuation), (2) (by quotes/parentheses) (Required highlighting of model concept in DTD comment)\n   - (1) (Required minimum occurrence of model concept in DTD comment)");
        System.exit(1);
    }

    public static URL generate(String[] argument) {
        try {
            boolean resolveEntity;
            int i = 0;
            if (argument.length < 1) {
                DTD2XSD.usage();
            }
            boolean bl = resolveEntity = !argument[i].startsWith("-entity");
            if (!resolveEntity) {
                if (argument.length < 2) {
                    DTD2XSD.usage();
                } else {
                    ++i;
                }
            }
            boolean ignoreComment = !argument[i].startsWith("-comment");
            int commentLength = 100;
            String commentLanguage = null;
            String conceptRelation = "element attribute";
            int conceptHighlight = 2;
            int conceptOccurrence = 1;
            if (!ignoreComment) {
                if (i + 6 < argument.length) {
                    if (!argument[i + 1].equals("-")) {
                        commentLength = Integer.valueOf(argument[i + 1]);
                    }
                    if (!argument[i + 2].equals("-")) {
                        commentLanguage = argument[i + 2];
                    }
                    if (!argument[i + 3].equals("-")) {
                        conceptRelation = argument[i + 3];
                    }
                    if (!argument[i + 4].equals("-")) {
                        conceptHighlight = Integer.valueOf(argument[i + 4]);
                    }
                    if (!argument[i + 5].equals("-")) {
                        conceptOccurrence = Integer.valueOf(argument[i + 5]);
                    }
                    i += 6;
                } else {
                    DTD2XSD.usage();
                }
            }
            URL dtd = URLHelper.getUserURL(argument[i]);
            String xsd = translator.translate(dtd.toExternalForm(), DTD2XSD.class.getClassLoader().getResourceAsStream("complextype.xsl"), resolveEntity, ignoreComment, commentLength, commentLanguage, conceptRelation, conceptHighlight, conceptOccurrence);
            String xsdFileName = dtd.getFile();
            xsdFileName = xsdFileName.substring(xsdFileName.lastIndexOf("/") + 1, xsdFileName.length());
            xsdFileName = xsdFileName.indexOf(".") != -1 ? xsdFileName.substring(0, xsdFileName.lastIndexOf(".") + 1) + "xsd" : xsdFileName + ".xsd";
            URL xsdURL = URLHelper.getUserURL(dtd, xsdFileName);
            File xsdFile = new File(xsdURL.toURI());
            FileWriter fw = new FileWriter(xsdFile);
            fw.write(xsd);
            fw.flush();
            fw.close();
            return xsdURL;
        }
        catch (Exception x) {
            LogRegistry.getInstance().warn(DTD2XSD.class, "unable to create xsd");
            return null;
        }
    }
}

