/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xui;

import com.jaxfront.core.dom.DOMBuilder;
import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.AbstractAction;
import com.jaxfront.core.rule.ActionImpl;
import com.jaxfront.core.rule.JavaAction;
import com.jaxfront.core.rule.ModelAction;
import com.jaxfront.core.rule.UIAction;
import com.jaxfront.core.schema.SchemaSimpleType;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.MethodParameter;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.DoubleKeyHashtable;
import com.jaxfront.core.util.DoubleKeyHashtableUnsynced;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.xui.ListInfo;
import com.jaxfront.core.xui.NLS;
import com.jaxfront.core.xui.TableInfo;
import com.jaxfront.core.xui.XUIDefinition;
import com.jaxfront.core.xui.XUITypes;
import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.UIManager;

public abstract class AbstractXUIElement
implements XUITypes,
Serializable,
Cloneable {
    protected Type _xuiType;
    protected XUIDefinition _xuiDefinition;
    private Hashtable _properties;
    protected static DoubleKeyHashtable _defaultProperties;
    private PropertyChangeSupport _propertyChangeSupport;
    private static final Boolean BOOLEAN_TRUE;
    private static final Boolean BOOLEAN_FALSE;
    private boolean _released = false;
    public static final int UNDEFINED_BRANCH = -1;
    public static final int COMPONENT_STYLE_BRANCH = 0;
    public static final int COMPONENT_BEHAVIOR_BRANCH = 1;
    public static final int GLOBAL_STYLE_BRANCH = 2;
    public static final int GLOBAL_BEHAVIOR_BRANCH = 3;
    public static final int GLOBAL_GENERAL_BRANCH = 4;
    public static final int GLOBAL_BRANCH = 5;

    protected AbstractXUIElement() {
    }

    protected AbstractXUIElement(XUIDefinition xuiDefinition, Type xuiType) {
        this._xuiDefinition = xuiDefinition;
        this._xuiType = xuiType;
        if (this._xuiType != null) {
            this.initialize();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public Boolean getBooleanProperty(String definitionPath, String relativePath) {
        return this.getBooleanProperty(definitionPath, relativePath, true);
    }

    public boolean getBoolean(String definitionPath, String relativePath) {
        Boolean res = this.getBooleanProperty(definitionPath, relativePath, true);
        if (res != null) {
            return res;
        }
        return false;
    }

    public Boolean getBooleanProperty(String definitionPath, String relativePath, boolean resolveDefault) {
        Boolean booleanValue = (Boolean)this.getObjectProperty(definitionPath, relativePath, resolveDefault);
        return booleanValue;
    }

    protected Color getColorProperty(String definitionPath, String relativePath) {
        Object colorValue = this.getObjectProperty(definitionPath, relativePath, true);
        if (colorValue == null) {
            return null;
        }
        if (colorValue instanceof Color) {
            return (Color)colorValue;
        }
        return AbstractXUIElement.initializeColor(colorValue.toString());
    }

    protected Hashtable cloneProperties() {
        if (this._properties != null) {
            return (Hashtable)this._properties.clone();
        }
        return null;
    }

    protected Enumeration getPropertyKeys() {
        if (this._properties != null) {
            return this._properties.keys();
        }
        return null;
    }

    protected static Color initializeColor(String value) {
        int r = 0;
        int g = 0;
        int b = 0;
        Color colorValue = null;
        if (value.equals("")) {
            return Color.BLACK;
        }
        if (value.indexOf(",") == -1) {
            if (LogRegistry.getInstance().logWarnings()) {
                LogRegistry.getInstance().warn(AbstractXUIElement.class, "wrong Color Definition for: " + value);
            }
        } else {
            StringTokenizer st = new StringTokenizer(value, ",");
            r = new Integer(st.nextToken());
            g = new Integer(st.nextToken());
            b = new Integer(st.nextToken());
        }
        colorValue = r == -1 && g == -1 && b == -1 ? UIManager.getLookAndFeelDefaults().getColor("Label.background") : new Color(r, g, b);
        return colorValue;
    }

    public static DoubleKeyHashtable getDefaultProperties(String context) {
        if (_defaultProperties == null) {
            AbstractXUIElement.initializeDefaultProperties(DOMBuilder.getInstance().getXUISchemaDOM(context));
        }
        return _defaultProperties;
    }

    public static void initializeDefaultProperties(Document dom) {
        _defaultProperties = new DoubleKeyHashtableUnsynced();
        AbstractXUIElement.initializeDefaultProperties(dom.getRootType(), -1);
    }

    private static void initializeDefaultProperties(Type type, int branchType) {
        String xpathLoc = type.getXPathLocation();
        if (xpathLoc != null && branchType == -1) {
            if (xpathLoc.equals("/XUI/global")) {
                branchType = 5;
            } else if (xpathLoc.equals("/XUI/component/style")) {
                branchType = 0;
            } else if (xpathLoc.equals("/XUI/component/behaviour")) {
                branchType = 1;
            }
        }
        if (type.isSimple()) {
            int relPathSplitPrim = 0;
            int relPathSplitSec = 0;
            SimpleType st = (SimpleType)type;
            String xpath = TextTools.replace(st.getXPathLocation(), "@", "");
            String defaultValue = st.getDefaultValue();
            switch (branchType) {
                case 5: {
                    relPathSplitPrim = 0;
                    relPathSplitSec = 0;
                    break;
                }
                case 4: {
                    relPathSplitPrim = "/XUI/global/general".length();
                    break;
                }
                case 0: {
                    relPathSplitPrim = "/XUI/component/style".length();
                    relPathSplitSec = relPathSplitPrim + 1;
                    break;
                }
                case 1: {
                    relPathSplitPrim = "/XUI/component/behaviour".length();
                    relPathSplitSec = relPathSplitPrim + 1;
                    break;
                }
                default: {
                    relPathSplitPrim = xpathLoc.lastIndexOf("/");
                    relPathSplitSec = relPathSplitPrim + 1;
                }
            }
            if (defaultValue != null) {
                _defaultProperties.put(xpath.substring(0, relPathSplitPrim), xpath.substring(relPathSplitSec), AbstractXUIElement.getValue(st, defaultValue));
            }
        } else if (type.isComposite()) {
            Iterator childIterator = ((CompositeType)type).getComposites().iterator();
            while (childIterator.hasNext()) {
                AbstractXUIElement.initializeDefaultProperties((Type)childIterator.next(), branchType);
            }
        } else if (type.isList()) {
            AbstractXUIElement.initializeDefaultProperties(((ListType)type).getEditingType(), branchType);
        }
    }

    protected Dimension getDimensionProperty(String definitionPath, String relativePath) {
        if (this.getProperties() != null && this.getProperties().get(relativePath) != null) {
            Object value = this.getProperties().get(relativePath);
            if (value instanceof Dimension) {
                return (Dimension)this.getProperties().get(relativePath);
            }
            value = this.initializeDimension((String)value);
            this.setProperty(relativePath, value);
            return (Dimension)value;
        }
        Dimension dimensionValue = null;
        String value = this.getProperty(definitionPath, relativePath);
        dimensionValue = this.initializeDimension(value);
        return dimensionValue;
    }

    protected Dimension initializeDimension(String value) {
        Dimension dimensionValue = null;
        if (value.indexOf("*") == -1) {
            if (LogRegistry.getInstance().logWarnings()) {
                LogRegistry.getInstance().warn(this.getClass(), "wrong dimension set for: " + value);
            }
        } else {
            StringTokenizer st = new StringTokenizer(value, "*");
            int width = new Integer(st.nextToken());
            int height = new Integer(st.nextToken());
            dimensionValue = new Dimension(width, height);
        }
        return dimensionValue;
    }

    protected Document getDOM() {
        if (this.getType() != null) {
            return this.getType().getDOM();
        }
        return null;
    }

    protected Float getFloatProperty(String definitionPath, String relativePath) {
        Float floatValue = (Float)this.getObjectProperty(definitionPath, relativePath, true);
        return floatValue;
    }

    public TableInfo getTableInfo() {
        return (TableInfo)this.getProperty("table");
    }

    public TableInfo getTableInfoPDF() {
        return (TableInfo)this.getProperty("table_pdf");
    }

    protected Integer getIntProperty(String definitionPath, String relativePath) {
        Integer integerValue = (Integer)this.getObjectProperty(definitionPath, relativePath, true);
        return integerValue;
    }

    protected Double getDoubleProperty(String definitionPath, String relativePath) {
        Double dValue = (Double)this.getObjectProperty(definitionPath, relativePath, true);
        return dValue;
    }

    public Hashtable getProperties() {
        return this._properties;
    }

    protected String getProperty(String definitionPath, String relativePath) {
        return this.getProperty(definitionPath, relativePath, true);
    }

    public boolean hasProperties() {
        return this._properties != null;
    }

    public void removeProperty(String property) {
        if (this._properties != null) {
            this.getProperties().remove(property);
        }
    }

    protected Object getObjectProperty(String definitionPath, String relativePath, boolean resolveDefault) {
        Object value = null;
        if (this.getProperties() != null) {
            Object v = this.getProperties().get(relativePath);
            value = v;
            if (v != null) {
                return value;
            }
        }
        if (resolveDefault) {
            value = AbstractXUIElement.getDefaultProperties(this.getDOM() != null ? this.getDOM().getAppContext() : null).get(definitionPath, relativePath);
            return value;
        }
        return null;
    }

    protected String getProperty(String definitionPath, String relativePath, boolean resolveDefault) {
        String value = null;
        if (this.getProperties() != null && (value = (String)this.getProperties().get(relativePath)) != null) {
            if (value.length() == 0) {
                return null;
            }
            return value;
        }
        if (resolveDefault) {
            value = (String)AbstractXUIElement.getDefaultProperties(this.getDOM() != null ? this.getDOM().getAppContext() : null).get(definitionPath, relativePath);
            return value;
        }
        return null;
    }

    protected Object getProperty(String uiKey) {
        if (this.getProperties() == null) {
            return null;
        }
        return this.getProperties().get(uiKey);
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this._propertyChangeSupport;
    }

    public ListInfo getSerialListInfo() {
        return (ListInfo)this.getProperty("serial");
    }

    public ListInfo getTabListInfo() {
        return (ListInfo)this.getProperty("tab");
    }

    public ListInfo getPagingListInfo() {
        return (ListInfo)this.getProperty("paging");
    }

    protected String getStringProperty(String definitionPath, String relativePath) {
        String value = this.getProperty(definitionPath, relativePath);
        return value;
    }

    protected Type getType() {
        return this._xuiDefinition.getType();
    }

    protected XUIDefinition getXUIDefinition() {
        return this._xuiDefinition;
    }

    public static AbstractAction initAction(int actionCounter, Document dom, Type targetType, Type actionType) {
        String ruleEnabled = actionType.getDirectChildValue("enabled");
        AbstractAction mainAction = null;
        if (!"false".equals(ruleEnabled)) {
            AbstractAction inverseAction = null;
            Type mainActType = null;
            Type inverseActionType = null;
            mainActType = actionType.getDirectChild("mainAction");
            if (mainActType != null) {
                mainAction = AbstractXUIElement.initSubAction(actionCounter, dom, targetType, mainActType);
            }
            if ((inverseActionType = actionType.getDirectChild("inverseAction")) != null) {
                inverseAction = AbstractXUIElement.initSubAction(actionCounter, dom, targetType, inverseActionType);
                if (mainAction != null) {
                    mainAction.setInverseAction(inverseAction);
                    String targetXPath = inverseActionType.getDirectChildValue("target");
                    if (inverseAction != null && targetXPath == null && mainAction.getTargetXPath() != null) {
                        inverseAction.setTargetXPath(mainAction.getTargetXPath());
                    }
                }
            }
        }
        return mainAction;
    }

    protected abstract void initialize();

    protected void initializeList(Type list) {
        Type unNamList = list.getChild("UNNAMED1");
        Type choosenType = unNamList.getChoosenType();
        if (choosenType != null) {
            if (((SimpleType)list.getChild("visible")).getValue().equals("false")) {
                this.setProperty("visible", "visible");
            }
            if (choosenType.getName().equals("serial")) {
                String layout = choosenType.getDirectChildValue("layout");
                this.initializeSerialList(list, choosenType, layout);
            } else if (choosenType.getName().equals("tab")) {
                this.initializeTabList(list);
            } else if (choosenType.getName().equals("paging")) {
                this.initializePagingList(list);
            } else {
                this.initializeTable(list);
            }
        } else if (this.getType().isList()) {
            this.initializeTable(list);
        }
    }

    protected void initializeTabList(Type list) {
        ListInfo listInfo = new ListInfo(list, this.getType());
        this.setProperty("tab", listInfo);
    }

    protected void initializePagingList(Type list) {
        ListInfo listInfo = new ListInfo(list, this.getType());
        this.setProperty("paging", listInfo);
        String pagingTitleFormula = list.getDirectChild("UNNAMED1").getChoosenType().getDirectChildValue("pageTitleFormula");
        String restrictivePaging = list.getDirectChild("UNNAMED1").getChoosenType().getDirectChildValue("useRestrictivePaging");
        if (pagingTitleFormula != null) {
            this.setProperty("pageTitleFormula", pagingTitleFormula);
        }
        if (restrictivePaging != null) {
            this.setBooleanProperty("useRestrictivePaging", Boolean.parseBoolean(restrictivePaging));
        }
    }

    protected void initializeSerialList(Type list, Type serialType, String layoutName) {
        ListInfo serialInfo = new ListInfo(list, this.getType());
        serialInfo.setHistoryMode(ListInfo.getBooleanProperty(serialType, this.getType(), "isHistoryMode", null));
        serialInfo.setLayoutName(layoutName);
        serialInfo.setSerialAddCssStyle(ListInfo.getStringProperty(serialType, this.getType(), "addCssStyle", null));
        this.setProperty("serial", serialInfo);
    }

    protected void initializeTable(Type table) {
        TableInfo tableInfo = new TableInfo(table, this.getType());
        this.setProperty("table", tableInfo);
    }

    private static AbstractAction initSubAction(int actionCounter, Document dom, Type targetType, Type actionType) {
        Type choosableType;
        AbstractAction action = null;
        String xpath = actionType.getDirectChildValue("target");
        String className = actionType.getDirectChildValue("className");
        if (xpath == null) {
            xpath = "";
        }
        if ((choosableType = actionType).getChoosenType() != null) {
            String choosenActionTypeName = choosableType.getChoosenType().getName();
            if (choosenActionTypeName.equals("propertyChange")) {
                action = new ModelAction(dom, targetType, xpath, choosableType.getChoosenType(), className);
            } else if (choosenActionTypeName.equals("generalAction")) {
                action = new ActionImpl(dom, targetType, xpath, choosableType.getChoosenType(), className);
            } else if (choosenActionTypeName.equals("uiAction")) {
                String methodName = null;
                methodName = choosableType.getChoosenType().getDirectChildValue("methodName");
                ListType params = (ListType)choosableType.getChoosenType().getDirectChild("param");
                MethodParameter[] methodParameters = new MethodParameter[params.size()];
                for (int i = 0; i < params.size(); ++i) {
                    Type param = (Type)params.get(i);
                    String type = param.getDirectChildValue("type");
                    String value = AbstractXUIElement.getActionParamValue(actionCounter, dom, targetType, param);
                    methodParameters[i] = new MethodParameter(targetType, type, value);
                }
                action = new UIAction(dom, targetType, actionType, xpath, methodName, methodParameters, className);
            } else if (choosenActionTypeName.equals("javaActionImpl")) {
                action = new JavaAction(dom, targetType, xpath, choosableType.getChoosenType(), className);
            }
        } else if (className != null && className.length() > 0) {
            action = new ModelAction(dom, targetType, xpath, null, className);
        }
        if (action != null) {
            action.setUseActionTargetAsBase(Boolean.valueOf(actionType.getDirectChildValue("useActionTargetAsBase")));
        }
        return action;
    }

    private static String getActionParamValue(int actionIndex, Document dom, Type targetType, Type paramType) {
        String type = paramType.getDirectChildValue("type");
        if (targetType.getDOM() != null && targetType.getDOM().getNLS() != null && type.equals("String")) {
            String nlsValue = targetType.getDOM().getNLS().get(AbstractXUIElement.createActionParamNLSKey(actionIndex, targetType, paramType));
            if (nlsValue != null && nlsValue.length() > 0) {
                return nlsValue;
            }
            return paramType.getDirectChildValue("value");
        }
        return paramType.getDirectChildValue("value");
    }

    private static String createActionParamNLSKey(int actionIndex, Type targetType, Type paramType) {
        boolean isMainAction = paramType.getParent("mainAction") != null;
        String ruleSuffix = "rule-main-";
        if (!isMainAction) {
            ruleSuffix = "rule-inverse-";
        }
        int paramIndex = paramType.getParentList().getList().indexOf(paramType.getParent("param")) + 1;
        String nlsKey = DOMHelper.getRelativeXPathLocation(targetType);
        nlsKey = nlsKey + NLS.TAG_DELIMITER + ruleSuffix + actionIndex + NLS.TAG_DELIMITER + paramIndex;
        return nlsKey;
    }

    public boolean isUsingSerialList() {
        return this.getSerialListInfo() != null;
    }

    public boolean isUsingTableList() {
        return !this.isUsingSerialList() && !this.isUsingTabList() && !this.isListTableVisible();
    }

    public boolean isUsingTabList() {
        return this.getProperty("tab") != null;
    }

    public boolean isUsingPagingList() {
        return this.getProperty("paging") != null;
    }

    public boolean isListTableVisible() {
        return this.getProperty("visible") != null;
    }

    public void release() {
        this._released = true;
        this._xuiType = null;
        this._xuiDefinition = null;
        this._properties = null;
    }

    protected void setBooleanProperty(String key, boolean value) {
        this.setProperty(key, value ? BOOLEAN_TRUE : BOOLEAN_FALSE);
    }

    protected void setFloatProperty(String key, float value) {
        this.setProperty(key, new Float(value));
    }

    protected void setIntProperty(String key, int value) {
        this.setProperty(key, new Integer(value));
    }

    public void setProperty(Object key, Object value) {
        if (this._properties == null) {
            this.setProperties(new Hashtable());
        }
        this.getProperties().put(key, value);
    }

    public void setProperties(Hashtable newProps) {
        this._properties = newProps;
    }

    protected static Object getValue(SimpleType st, String value) {
        if (st.isBoolean()) {
            return new Boolean(value);
        }
        if (st.isNumber()) {
            if (((SchemaSimpleType)st.getSchemaElement().getSchemaType()).isFloat()) {
                return new Float(value);
            }
            if (((SchemaSimpleType)st.getSchemaElement().getSchemaType()).isDouble()) {
                return new Double(value);
            }
            return new Integer(value);
        }
        if (st.isColor()) {
            return AbstractXUIElement.initializeColor(value);
        }
        return value;
    }

    protected void removeAllProperties() {
        if (this._properties != null) {
            this.getProperties().clear();
        }
    }

    protected void initializeFor(String relativeXPath, CompositeType type, boolean useTagName) {
        Iterator iterator = type.getComposites().iterator();
        Type childType = null;
        SimpleType st = null;
        StringBuffer xpath = null;
        String qName = type.getName();
        while (iterator.hasNext()) {
            childType = (Type)iterator.next();
            if (childType.isSimple()) {
                st = (SimpleType)childType;
                if (st.getValue() == null || st.getDefaultValue() != null && st.getValue().equals(st.getDefaultValue())) continue;
                xpath = new StringBuffer();
                if (relativeXPath != null) {
                    xpath.append(relativeXPath);
                    xpath.append("/");
                }
                if (useTagName) {
                    xpath.append(qName);
                    xpath.append("/");
                }
                xpath.append(st.getName());
                Object value = AbstractXUIElement.getValue(st, st.getValue());
                this.setProperty(xpath.toString(), value);
                continue;
            }
            if (!childType.isComposite()) continue;
            this.initializeFor(relativeXPath + "/" + qName, (CompositeType)childType, useTagName);
        }
    }

    protected void initializeFor(CompositeType type) {
        this.initializeFor(type, true);
    }

    protected void initializeFor(CompositeType type, boolean useTagName) {
        this.initializeFor(null, type, useTagName);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static {
        BOOLEAN_TRUE = Boolean.TRUE;
        BOOLEAN_FALSE = Boolean.FALSE;
    }
}

