/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xui;

import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TabbableView;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.xui.LayoutInfo;
import com.jaxfront.core.xui.TableCell;
import com.jaxfront.core.xui.XUIDefinition;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class FormLayoutInfo
implements LayoutInfo,
Cloneable {
    private List _rows = new Vector();
    private List _columns = new Vector();
    private String[] _rowCSS = null;
    private String[] _colCSS = null;
    private List<TableCell> _cells = new Vector<TableCell>();
    private List _additionalTypes = null;
    private boolean _isOptional = true;
    private String _id;

    public void addCell(TableCell cell) {
        this._cells.add(cell);
    }

    public boolean holds(Type type) {
        if (this._cells != null) {
            Iterator<TableCell> iterator = this._cells.iterator();
            while (iterator.hasNext()) {
                Type xpathRef;
                TableCell cell = iterator.next();
                if (!cell.getLabelType().equals("xpath") || (xpathRef = cell.getXPathReferencedType()) == null || type == null || xpathRef != type || !xpathRef.isList() || !((ListType)xpathRef).getList().contains(type)) continue;
                return true;
            }
        }
        return false;
    }

    public void addAdditionalCellType(Type type) {
        if (this._additionalTypes == null) {
            this._additionalTypes = new Vector();
        }
        this._additionalTypes.add(type);
    }

    public List getCellTypes() {
        Vector<Type> result = new Vector<Type>();
        if (this._cells != null) {
            Iterator<TableCell> iterator = this._cells.iterator();
            while (iterator.hasNext()) {
                Type xpathRef;
                TableCell cell = iterator.next();
                if (!cell.getLabelType().equals("xpath") || (xpathRef = cell.getXPathReferencedType()) == null) continue;
                result.add(xpathRef);
            }
        }
        if (this._additionalTypes != null) {
            result.addAll(this._additionalTypes);
        }
        return result;
    }

    public boolean contains(Type type) {
        if (this._cells != null) {
            Iterator<TableCell> iterator = this._cells.iterator();
            while (iterator.hasNext()) {
                Type xpathRef;
                TableCell cell = iterator.next();
                if (!cell.getLabelType().equals("xpath") || (xpathRef = cell.getXPathReferencedType()) == null || type == null) continue;
                if (!xpathRef.isSimple()) {
                    XUIDefinition xuiDef = xpathRef.getXUIDefinition(false);
                    if (xuiDef != null) {
                        boolean found;
                        if (xuiDef.getStyle().isTableLayout() && xuiDef.getStyle().getLayoutManager() instanceof FormLayoutInfo) {
                            FormLayoutInfo nestedLayout = (FormLayoutInfo)xuiDef.getStyle().getLayoutManager();
                            boolean found2 = nestedLayout.contains(type);
                            if (!found2) continue;
                            return found2;
                        }
                        if (xuiDef.getStyle().isTabHolder()) {
                            FormLayoutInfo nestedLayout;
                            boolean found3;
                            XUIDefinition tabXUIDef;
                            Type selectedTabType;
                            TabbableView tabView = (TabbableView)((Object)TypeVisualizerFactory.getInstance().getVisualizer(xuiDef.getType(), false));
                            if (tabView != null && (selectedTabType = tabView.getSelectedTabType()) != null && (tabXUIDef = selectedTabType.getXUIDefinition(false)) != null && tabXUIDef.getStyle().getLayoutManager() instanceof FormLayoutInfo && (found3 = (nestedLayout = (FormLayoutInfo)tabXUIDef.getStyle().getLayoutManager()).contains(type))) {
                                return found3;
                            }
                        } else if ((xpathRef.isChoice() || xpathRef.isList()) && (found = type.isDerivedFrom(xpathRef))) {
                            return found;
                        }
                        if (!(found = xpathRef.getDirectChildrenSize() > 0 && xpathRef.getDirectChildren().contains(type))) continue;
                        return found;
                    }
                    boolean found = xpathRef.getDirectChildrenSize() > 0 && xpathRef.getDirectChildren().contains(type);
                    if (!found) continue;
                    return found;
                }
                if (xpathRef != type) continue;
                return true;
            }
        }
        return false;
    }

    public void addColumn(Double columnDef) {
        this._columns.add(columnDef);
    }

    public void addRow(Double rowDef) {
        this._rows.add(rowDef);
    }

    public List getCells() {
        return this._cells;
    }

    public List getColumns() {
        return this._columns;
    }

    public String getId() {
        return this._id;
    }

    public List getRows() {
        return this._rows;
    }

    public boolean isOptional() {
        return this._isOptional;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setIsOptional(boolean isOptional) {
        this._isOptional = isOptional;
    }

    public FormLayoutInfo clone(Type ownerType) {
        FormLayoutInfo info = null;
        try {
            info = (FormLayoutInfo)this.clone();
            Vector<TableCell> clonedCells = new Vector<TableCell>();
            info._cells = clonedCells;
            if (this.getCells() != null) {
                Iterator iterator = this.getCells().iterator();
                while (iterator.hasNext()) {
                    TableCell cell = (TableCell)iterator.next();
                    clonedCells.add(cell.clone(ownerType));
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return info;
    }

    public void release() {
        if (this._cells != null) {
            for (int c = 0; c < this._cells.size(); ++c) {
                TableCell tCell = this._cells.get(c);
                if (tCell == null) continue;
                tCell.release();
            }
            this._cells = null;
        }
        this._columns = null;
        this._rows = null;
        this._additionalTypes = null;
        this._id = null;
        this._isOptional = true;
    }

    public void setColCSS(String[] colCSS) {
        this._colCSS = colCSS;
    }

    public void setRowCSS(String[] rowCSS) {
        this._rowCSS = rowCSS;
    }

    public String[] getColCSS() {
        return this._colCSS;
    }

    public String[] getRowCSS() {
        return this._rowCSS;
    }
}

