/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xui;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.util.JAXFrontDateTools;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.LicenseChecker;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.xui.AbstractXUIElement;
import com.jaxfront.core.xui.XUIElementPaths;
import java.awt.Color;
import java.awt.Dimension;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class GlobalDefinition
extends AbstractXUIElement
implements XUIElementPaths {
    public static final String INITIAL_PROPERTY_LOCALE = "Locale";
    public static final String INITIAL_PROPERTY_TIME_FORMAT = "TimeFormat";
    public static final String INITIAL_PROPERTY_IS_RUNNIG_IN_XUIEDITOR = "IsRunnigInXUIEditor";
    public static final String INITIAL_PROPERTY_DATE_TIME_FORMAT = "DateTimeFormat";
    public static final String INITIAL_PROPERTY_DATE_FORMAT = "DateFormat";
    private Type _sourceType;
    private DecimalFormat _decimalFormat = null;
    private String _country = null;
    private Locale _currentLocale = null;
    private DateFormat _dateFormat;
    private DateFormat _dateTimeFormat;
    private DateFormat _timeFormat;
    private String _language = null;
    private String _alternativeRequiredMarker = "";
    private boolean _hideEmptyElements = false;
    private String _defaultPrefix = null;
    private String _defaultPostfix = null;
    private Hashtable _properties;
    private String _usedTimePattern;
    private String _usedDatePattern;
    private String _usedDateTimePattern;
    private String _dateInputMask;
    private String _timeInputMask;
    private String _dateTimeInputMask;
    private String _numberSymb = null;
    private String _posNumSymb = null;
    private char _groupingSepSymb = '\u0000';
    private char _decimalSepSymb = '\u0000';
    private String _negNumSymb = null;
    private short _useGlobalTypes = (short)-1;
    private byte _hideMandatory = (byte)-1;
    private byte _rightSideError = (byte)-1;
    private byte _serializingEmptyContent = (byte)-1;
    private byte _serializingExtendedPI = (byte)-1;
    private byte _useComboSelection = (byte)-1;
    private byte _markAllOnFocus = (byte)-1;
    private boolean _softBinding;
    private boolean _addListEntryAfter = false;
    private DecimalFormat exponentialToStringFormat;

    public GlobalDefinition(Type sourceType, Type xuiType) {
        this._sourceType = sourceType;
        this._xuiType = xuiType;
        if (xuiType != null) {
            this.initializeFor((CompositeType)xuiType.getDirectChild("global"), true);
            Type propertyType = xuiType.getChild("property");
            this._properties = DOMHelper.toHashtable((ListType)propertyType, "key", "value");
        }
        this.initDomSpecificProperties();
    }

    private void initDomSpecificProperties() {
        if (this._sourceType != null) {
            Object prop = this._sourceType.getClientProperty("language");
            if (prop != null) {
                this._language = (String)prop;
            }
            if ((prop = this._sourceType.getDOM().getClientProperty(INITIAL_PROPERTY_DATE_FORMAT)) != null) {
                if (prop instanceof SimpleDateFormat) {
                    this.setDateFormat((SimpleDateFormat)prop);
                } else {
                    this.setDateFormat(new SimpleDateFormat((String)prop));
                }
            }
            if ((prop = this._sourceType.getDOM().getClientProperty(INITIAL_PROPERTY_DATE_TIME_FORMAT)) != null) {
                if (prop instanceof SimpleDateFormat) {
                    this.setDateTimeFormat((SimpleDateFormat)prop);
                } else {
                    this.setDateTimeFormat(new SimpleDateFormat((String)prop));
                }
            }
            if ((prop = this._sourceType.getDOM().getClientProperty(INITIAL_PROPERTY_TIME_FORMAT)) != null) {
                if (prop instanceof SimpleDateFormat) {
                    this.setTimeFormat((SimpleDateFormat)prop);
                } else {
                    this.setTimeFormat(new SimpleDateFormat((String)prop));
                }
            }
            if ((prop = this._sourceType.getDOM().getClientProperty(INITIAL_PROPERTY_IS_RUNNIG_IN_XUIEDITOR)) != null) {
                this._sourceType.getDOM().setRunningAsXUIEditor(Boolean.valueOf((String)prop));
            }
            if ((prop = this._sourceType.getDOM().getClientProperty(INITIAL_PROPERTY_LOCALE)) != null) {
                this._currentLocale = prop instanceof Locale ? (Locale)prop : new Locale((String)prop);
            }
        }
    }

    protected void setColorProperty(String propertyName, Color newColor) {
        this.setProperty(propertyName, newColor);
    }

    protected void setDimensionProperty(String propertyName, Dimension value) {
        this.setProperty(propertyName, value);
    }

    public float getDividerLocation() {
        return this.getFloatProperty("", "/XUI/global/style/dividerLocation").floatValue();
    }

    public void setDividerLocation(float value) {
        this.setFloatProperty("/XUI/global/style/dividerLocation", value);
    }

    public Color getErrorMarkingColor() {
        return this.getColorProperty("", "/XUI/global/errorDisplay/errorColor");
    }

    public void setErrorMarkingColor(Color color) {
        this.setColorProperty("/XUI/global/errorDisplay/errorColor", color);
    }

    public float getLabelColumnWidth() {
        return this.getFloatProperty("", "/XUI/global/style/label/width").floatValue();
    }

    public void setLabelColumnWidth(float value) {
        this.setFloatProperty("/XUI/global/style/label/width", value);
    }

    public float getComponentColumnWidth() {
        return this.getFloatProperty("", "/XUI/global/style/component/width").floatValue();
    }

    public int getComponentMaxLengthString() {
        return this.getIntProperty("", "/XUI/global/style/component/maxLengthString");
    }

    public int getComponentMaxLengthStringMultiLine() {
        return this.getIntProperty("", "/XUI/global/style/component/maxLengthStringMultiLine");
    }

    public void setComponentColumnWidth(float width) {
        this.setProperty("/XUI/global/style/component/width", new Float(width));
    }

    public float getGlobalCaptionIndent() {
        return this.getFloatProperty("", "/XUI/global/style/caption/indent").floatValue();
    }

    public boolean isGlobalCaptionHideUnnamed() {
        return this.getBooleanProperty("", "/XUI/global/style/caption/hideUnnamed");
    }

    public boolean isGlobalCaptionHideIfOnlyOneVisibleChild() {
        return this.getBooleanProperty("", "/XUI/global/style/caption/hideIfOnlyOneVisibleChild");
    }

    public void setGlobalCaptionIndent(float value) {
        this.setFloatProperty("/XUI/global/style/caption/indent", value);
    }

    public String getGlobalCaptionType() {
        return this.getStringProperty("", "/XUI/global/style/caption/type");
    }

    private void setGlobalCaptionType(String captionType) {
        this.setStringProperty("/XUI/global/style/caption/type", captionType);
    }

    public void setGlobalCaptionTypeToBorder() {
        this.setGlobalCaptionType("border");
    }

    public void setGlobalCaptionTypeToHeader() {
        this.setGlobalCaptionType("header");
    }

    public void setGlobalCaptionTypeToModernSeparator() {
        this.setGlobalCaptionType("separator_modern");
    }

    public void setGlobalCaptionTypeToClassicSeparator() {
        this.setGlobalCaptionType("separator_classic");
    }

    public boolean isGlobalCaptionTypeBorder() {
        return this.getGlobalCaptionType() != null && this.getGlobalCaptionType().equals("border");
    }

    public boolean isMarkAllOnFocus() {
        if (this._markAllOnFocus == -1) {
            this._markAllOnFocus = this.getBooleanProperty("", "/XUI/global/general/markAllOnFocus") != false ? (byte)1 : 0;
        }
        return this._markAllOnFocus == 1;
    }

    public void setMarkAllOnFocus(boolean markAll) {
        this.setBooleanProperty("/XUI/global/general/markAllOnFocus", markAll);
        this._markAllOnFocus = (byte)-1;
    }

    public boolean isGlobalCaptionTypeHeader() {
        return this.getGlobalCaptionType() != null && this.getGlobalCaptionType().equals("header");
    }

    public boolean isGlobalCaptionTypeModernSeparator() {
        return this.getGlobalCaptionType() != null && this.getGlobalCaptionType().equals("separator_modern");
    }

    public boolean isGlobalCaptionTypeClassicSeparator() {
        return this.getGlobalCaptionType() != null && this.getGlobalCaptionType().equals("separator_classic");
    }

    public float getGlobalNestedIndent() {
        return this.getFloatProperty("", "/XUI/global/style/nestedIndent").floatValue();
    }

    public String getGlobalCodeSetURL() {
        return this.getStringProperty("", "/XUI/global/style/choiceAndEnumeration/globalCodeSetUrl");
    }

    public void setGlobalNestedIndent(float value) {
        this.setFloatProperty("/XUI/global/style/nestedIndent", value);
    }

    public float getGlobalLabelIndent() {
        return this.getFloatProperty("", "/XUI/global/style/label/indent").floatValue();
    }

    public void setGlobalLabelIndent(float value) {
        this.setFloatProperty("/XUI/global/style/label/indent", value);
    }

    public float getGlobalComponentIndent() {
        return this.getFloatProperty("", "/XUI/global/style/component/indent").floatValue();
    }

    public void setGlobalComponentIndent(float value) {
        this.setFloatProperty("/XUI/global/style/component/indent", value);
    }

    public String getGlobalApplyCaptionIndentOn() {
        return this.getStringProperty("", "/XUI/global/style/caption/applyIndentOn");
    }

    private void setGlobalApplyCaptionIndentOn(String elementName) {
        this.setStringProperty("/XUI/global/style/caption/applyIndentOn", elementName);
    }

    public void setGlobalApplyCaptionIndentOnLabel() {
        this.setGlobalApplyCaptionIndentOn("label");
    }

    public void setGlobalApplyCaptionIndentOnComponent() {
        this.setGlobalApplyCaptionIndentOn("component");
    }

    public void setGlobalApplyCaptionIndentOnBoth() {
        this.setGlobalApplyCaptionIndentOn("both");
    }

    public boolean isGlobalApplyCaptionIndentOnLabel() {
        if (this.getGlobalApplyCaptionIndentOn() != null) {
            if (this.getGlobalApplyCaptionIndentOn().equals("label")) {
                return true;
            }
            return this.isGlobalApplyCaptionIndentOnBoth();
        }
        return false;
    }

    public boolean isGlobalApplyCaptionIndentOnComponent() {
        if (this.getGlobalApplyCaptionIndentOn() != null) {
            if (this.getGlobalApplyCaptionIndentOn().equals("component")) {
                return true;
            }
            return this.isGlobalApplyCaptionIndentOnBoth();
        }
        return false;
    }

    public boolean isGlobalApplyCaptionIndentOnBoth() {
        return this.getGlobalApplyCaptionIndentOn() != null && this.getGlobalApplyCaptionIndentOn().equals("both");
    }

    public int getHorizontalScrollBarPolicy() {
        String value = this.getStringProperty("", "/XUI/global/style/horizontalScrollBarPolicy");
        int intValue = -99;
        if (value != null && value.length() > 0) {
            if (value.equals("HORIZONTAL_SCROLLBAR_AS_NEEDED")) {
                return 30;
            }
            if (value.equals("HORIZONTAL_SCROLLBAR_NEVER")) {
                return 31;
            }
            if (value.equals("HORIZONTAL_SCROLLBAR_ALWAYS")) {
                return 32;
            }
        }
        return intValue;
    }

    private void setHorizontalScrollBarPolicy(String policy) {
        this.setStringProperty("/XUI/global/style/horizontalScrollBarPolicy", policy);
    }

    public void setHorizontalScrollBarPolicyToAsNeeded() {
        this.setHorizontalScrollBarPolicy("HORIZONTAL_SCROLLBAR_AS_NEEDED");
    }

    public void setHorizontalScrollBarPolicyToNever() {
        this.setHorizontalScrollBarPolicy("HORIZONTAL_SCROLLBAR_NEVER");
    }

    public void setHorizontalScrollBarPolicyToAlways() {
        this.setHorizontalScrollBarPolicy("HORIZONTAL_SCROLLBAR_ALWAYS");
    }

    public String getCountry() {
        if (this._country == null) {
            this._country = JAXFrontProperties.parseCountry(this.getLanguage());
        }
        return this._country;
    }

    public Locale getCurrentLocale() {
        if (!this.getDOM().isBinding() && this._currentLocale == null) {
            String lang = this.getLanguage();
            String country = JAXFrontProperties.getInstance(this.getDOM().getAppContext()).getLanguageCountry();
            this._currentLocale = new Locale(lang, country != null ? country : Locale.getDefault().getCountry());
            if (this._currentLocale == null) {
                this._currentLocale = Locale.getDefault();
            }
        }
        if (this._currentLocale == null && this.getLanguage() != null) {
            String country = JAXFrontProperties.getInstance(this.getDOM().getAppContext()).getLanguageCountry();
            this._currentLocale = new Locale(this.getLanguage(), country != null ? country : Locale.getDefault().getCountry());
        }
        return this._currentLocale;
    }

    public DecimalFormat getDecimalFormat() {
        if (!this.getDOM().isBinding() && this._decimalFormat == null) {
            String pattern = (String)JAXFrontProperties.getInstance(this.getDOM().getAppContext()).getLocalizedProperties().get("jaxfront.number.pattern", this.getCurrentLocale().getLanguage());
            if (pattern != null) {
                try {
                    this._decimalFormat = new DecimalFormat(pattern, new DecimalFormatSymbols(this.getCurrentLocale()));
                }
                catch (Exception e) {
                    this._decimalFormat = null;
                }
            }
            if (this._decimalFormat == null) {
                this._decimalFormat = (DecimalFormat)NumberFormat.getInstance(this.getCurrentLocale());
            }
        }
        return this._decimalFormat;
    }

    public String getRequiredMandatoryMarker() {
        if (this._alternativeRequiredMarker != null && this._alternativeRequiredMarker.length() == 0) {
            this._alternativeRequiredMarker = this.getStringProperty("", "/XUI/global/errorDisplay/alternativeErrorMarker");
            if (this._alternativeRequiredMarker != null && this._alternativeRequiredMarker.length() == 0) {
                this._alternativeRequiredMarker = null;
            }
        }
        return this._alternativeRequiredMarker;
    }

    public void setRequiredMandatoryMarker(String alterMarker) {
        this._alternativeRequiredMarker = alterMarker;
    }

    public String getDateFormatStringPattern(Locale loc) {
        if (this._usedDatePattern == null) {
            this._usedDatePattern = (String)JAXFrontProperties.getInstance(this.getDOM().getAppContext()).getLocalizedProperties().get("jaxfront.date.pattern", loc == null ? this.getCurrentLocale().getLanguage() : loc.getLanguage());
            if (this._usedDatePattern != null) {
                try {
                    new SimpleDateFormat(this._usedDatePattern);
                }
                catch (Exception e) {
                    this._usedDatePattern = null;
                }
            }
            if (this._usedDatePattern == null) {
                this._usedDatePattern = GlobalDefinition.getDefaultDateFormatStringPattern(loc == null ? this.getCurrentLocale().getLanguage() : loc.getLanguage());
            }
        }
        return this._usedDatePattern;
    }

    public String getDateTimeFormatStringPattern(Locale loc) {
        if (this._usedDateTimePattern == null) {
            this._usedDateTimePattern = (String)JAXFrontProperties.getInstance(this.getDOM().getAppContext()).getLocalizedProperties().get("jaxfront.dateTime.pattern", loc == null ? this.getCurrentLocale().getLanguage() : loc.getLanguage());
            if (this._usedDateTimePattern != null) {
                try {
                    new SimpleDateFormat(this._usedDateTimePattern);
                }
                catch (Exception e) {
                    this._usedDateTimePattern = null;
                }
            }
            if (this._usedDateTimePattern == null) {
                this._usedDateTimePattern = GlobalDefinition.getDefaultDateTimeFormatStringPattern(loc == null ? this.getCurrentLocale().getLanguage() : loc.getLanguage());
            }
        }
        return this._usedDateTimePattern;
    }

    public static String getDefaultDateFormatStringPattern(String lang) {
        String pattern = null;
        pattern = lang.equals("de") ? "dd.MM.yyyy" : (lang.equals("en") ? "yyyy/MM/dd" : (lang.equals("fr") ? "dd.MM.yyyy" : (lang.equals("it") ? "dd.MM.yyyy" : "dd.MM.yyyy")));
        return pattern;
    }

    public static String getDefaultTimeFormatStringPattern(String lang) {
        return "HH:mm:ss.SSS";
    }

    public static String getDefaultDateTimeFormatStringPattern(String lang) {
        String pattern = null;
        if (lang.equals("de")) {
            pattern = "dd.MM.yyyy HH:mm:ss";
        } else if (lang.equals("en")) {
            pattern = "yyyy/MM/dd HH:mm:ss";
        } else if (lang.equals("fr")) {
            pattern = "dd.MM.yyyy HH:mm:ss";
        } else if (lang.equals("it")) {
            pattern = "dd.MM.yyyy HH:mm:ss";
        }
        return pattern;
    }

    public static String getDefaultDateTimeFormatShortStringPattern(String lang) {
        String pattern = null;
        if (lang == null) {
            lang = "en";
        }
        if (lang.equals("de")) {
            pattern = "dd.MM.yyyy HH:mm";
        } else if (lang.equals("en")) {
            pattern = "yyyy/MM/dd HH:mm";
        } else if (lang.equals("fr")) {
            pattern = "dd.MM.yyyy HH:mm";
        } else if (lang.equals("it")) {
            pattern = "dd.MM.yyyy HH:mm";
        }
        return pattern;
    }

    public static String getDefaultTimeFormatShortStringPattern(String lang) {
        return "HH:mm";
    }

    public String getTimeFormatStringPattern(Locale loc) {
        if (this._usedTimePattern == null) {
            this._usedTimePattern = (String)JAXFrontProperties.getInstance(this.getDOM().getAppContext()).getLocalizedProperties().get("jaxfront.time.pattern", loc == null ? this.getCurrentLocale().getLanguage() : loc.getLanguage());
            try {
                if (this._usedTimePattern != null) {
                    new SimpleDateFormat(this._usedTimePattern);
                } else {
                    this._usedTimePattern = (String)GlobalDefinition.getDefaultProperties(this.getDOM().getAppContext()).get("/XUI/component/style", "leaf/component/timeFormat");
                    if (this._usedTimePattern == null) {
                        this._usedTimePattern = "HH:mm:ss.SSS";
                    }
                }
            }
            catch (Exception e) {
                this._usedTimePattern = "HH:mm:ss.SSS";
            }
        }
        return this._usedTimePattern;
    }

    public DateFormat getDateFormat() {
        if (this._dateFormat == null) {
            Locale loc = this.getCurrentLocale();
            if (loc != null) {
                String pattern = this.getDateFormatStringPattern(loc);
                this._dateFormat = pattern != null ? new SimpleDateFormat(pattern) : DateFormat.getDateInstance(3, loc);
            } else {
                return JAXFrontDateTools.getISODateFormatNotLenient();
            }
            this._dateFormat.setLenient(false);
        }
        return this._dateFormat;
    }

    public DateFormat getDateTimeFormat() {
        if (this._dateTimeFormat == null) {
            Locale curLoc = this.getCurrentLocale();
            if (curLoc != null) {
                String pattern = this.getDateTimeFormatStringPattern(curLoc);
                this._dateTimeFormat = pattern != null ? new SimpleDateFormat(pattern) : DateFormat.getDateTimeInstance(3, 3, curLoc);
                this._dateTimeFormat.setLenient(false);
            } else {
                return JAXFrontDateTools.getISODateTimeFormatNotLenient();
            }
        }
        return this._dateTimeFormat;
    }

    public DateFormat getTimeFormat() {
        if (this._timeFormat == null) {
            if (this.getCurrentLocale() == null) {
                Locale loc = new Locale(this.getLanguage());
                this._timeFormat = DateFormat.getTimeInstance(3, loc);
            } else {
                String pattern = this.getTimeFormatStringPattern(this.getCurrentLocale());
                this._timeFormat = pattern != null ? new SimpleDateFormat(pattern) : JAXFrontDateTools.getISOTimeFormatNotLenient();
            }
            this._timeFormat.setLenient(false);
        }
        return this._timeFormat;
    }

    public void setDateFormat(String pattern) {
        this._usedDatePattern = pattern;
        this.setDateFormat(new SimpleDateFormat(pattern));
    }

    public void setDateFormat(DateFormat df) {
        if (df instanceof SimpleDateFormat) {
            this._usedDatePattern = ((SimpleDateFormat)df).toPattern();
        }
        this._dateFormat = df;
    }

    public void setDateTimeFormat(String pattern) {
        this._usedDateTimePattern = pattern;
        this.setDateTimeFormat(new SimpleDateFormat(pattern));
    }

    public void setDateTimeFormat(DateFormat dtf) {
        if (dtf instanceof SimpleDateFormat) {
            this._usedDateTimePattern = ((SimpleDateFormat)dtf).toPattern();
        }
        this._dateTimeFormat = dtf;
    }

    public void setTimeFormat(String pattern) {
        this._usedTimePattern = pattern;
        this.setTimeFormat(new SimpleDateFormat(pattern));
    }

    public void setTimeFormat(DateFormat tf) {
        if (tf instanceof SimpleDateFormat) {
            this._usedTimePattern = ((SimpleDateFormat)tf).toPattern();
        }
        this._timeFormat = tf;
    }

    public String getLanguage() {
        if (this._language == null) {
            this._language = this.getDOM() != null && JAXFrontProperties.getInstance(this.getDOM().getAppContext()).getForcedLanguage() != null ? JAXFrontProperties.getInstance(this.getDOM().getAppContext()).getForcedLanguage() : JAXFrontProperties.parseLanguage(this.getStringProperty("", "/XUI/global/general/language"));
        }
        return this._language;
    }

    public void resetInternationalization() {
        this._language = null;
        this._dateFormat = null;
        this._country = null;
        this._currentLocale = null;
        this._decimalFormat = null;
        this._usedDateTimePattern = null;
        this._usedDatePattern = null;
        this._usedTimePattern = null;
        this._groupingSepSymb = '\u0000';
        this._decimalSepSymb = '\u0000';
    }

    public void setLanguage(String language) {
        if (!this.getLanguage().equals(language)) {
            this.resetInternationalization();
            this._language = language;
            this.getDOM().getController().getMathEvaluator().setVariable("XUI_LANGUAGE", language);
            this.setProperty("/XUI/global/general/language", language);
            this.getDOM().reinitializeNLS();
        }
    }

    public void setLanguageWithoutReinitialize(String language) {
        this._language = language;
    }

    public Type getTreeSelection() {
        Object treeSelection = this.getProperty("/XUI/global/style/navigationTree/selectionXPath");
        if (treeSelection == null) {
            return this.initializeTreeSelection((String)treeSelection);
        }
        if (treeSelection instanceof Type) {
            return (Type)treeSelection;
        }
        return this.initializeTreeSelection((String)treeSelection);
    }

    private Type initializeTreeSelection(String xpath) {
        Type type = null;
        if (xpath != null) {
            List types = TypePathExecuter.getInstance().processXPath(this.getDOM().getRootType(), xpath);
            if (types != null && types.size() > 0) {
                type = (Type)types.get(0);
                this.setProperty("/XUI/global/style/navigationTree/selectionXPath", type);
            } else {
                this.removeProperty("/XUI/global/style/navigationTree/selectionXPath");
            }
        }
        return type;
    }

    public void setTreeSelection(String xpath) {
        this.initializeTreeSelection(xpath);
    }

    public Color getSchemaRequiredFieldColor() {
        return this.getColorProperty("", "/XUI/global/style/component/schemaRequiredColor");
    }

    public void setSchemaRequiredFieldColor(Color color) {
        this.setColorProperty("/XUI/global/style/component/schemaRequiredColor", color);
    }

    public Color getApplicationFieldColor() {
        return this.getColorProperty("", "/XUI/global/style/component/applicationRequiredColor");
    }

    public void setApplicationFieldColor(Color newColor) {
        this.setColorProperty("/XUI/global/style/component/applicationRequiredColor", newColor);
    }

    public Color getOptionalFieldColor() {
        return this.getColorProperty("", "/XUI/global/style/component/optionalColor");
    }

    public void setOptionalFieldColor(Color color) {
        this.setColorProperty("/XUI/global/style/component/optionalColor", color);
    }

    public Color getHeaderTextColor() {
        return this.getColorProperty("", "/XUI/global/style/caption/header/textColor");
    }

    public void setHeaderTextColor(Color color) {
        this.setColorProperty("/XUI/global/style/caption/header/textColor", color);
    }

    public Color getHeaderStartColor() {
        return this.getColorProperty("", "/XUI/global/style/caption/header/startColor");
    }

    public void setHeaderStartColor(Color color) {
        this.setColorProperty("/XUI/global/style/caption/header/startColor", color);
    }

    public Color getHeaderEndColor() {
        return this.getColorProperty("/XUI/global/style/caption/header", "endColor");
    }

    public void setHeaderEndColor(Color color) {
        this.setColorProperty("/XUI/global/style/caption/header/endColor", color);
    }

    public Dimension getScreenSize() {
        return this.getDimensionProperty("", "/XUI/global/style/screenSize");
    }

    public void setScreenSize(Dimension size) {
        this.setDimensionProperty("/XUI/global/style/screenSize", size);
    }

    protected void setStringProperty(String propertyName, String value) {
        this.setProperty(propertyName, value);
    }

    public List getTreeRoot() {
        Object treeRoot = this.getProperty("/XUI/global/style/navigationTree/rootXPath");
        if (treeRoot == null) {
            return this.initializeTreeEntries(null);
        }
        if (treeRoot instanceof List) {
            return (List)treeRoot;
        }
        return this.initializeTreeEntries((String)treeRoot);
    }

    public int getInitialTreeExpandDepth() {
        return this.getIntProperty("", "/XUI/global/style/navigationTree/initialExpandDepth");
    }

    private Vector initializeTreeEntries(String xpath) {
        Vector<Type> treeRoot = null;
        if (xpath != null && xpath.length() > 0) {
            treeRoot = new Vector();
            treeRoot.addAll(TypePathExecuter.getInstance().processXPath(this.getType().getDOM().getRootType(), xpath, false));
        } else {
            treeRoot = new Vector<Type>();
            treeRoot.add(this.getType().getDOM().getRootType());
        }
        this.setProperty("/XUI/global/style/navigationTree/rootXPath", treeRoot);
        return treeRoot;
    }

    public void setTreeRoot(String xpath) {
        this.initializeTreeEntries(xpath);
    }

    protected Type getType() {
        return this._sourceType;
    }

    public int getVerticalScrollBarPolicy() {
        String value = this.getStringProperty("", "/XUI/global/style/verticalScrollBarPolicy");
        int intValue = -99;
        if (value != null && value.length() > 0) {
            if (value.equals("VERTICAL_SCROLLBAR_AS_NEEDED")) {
                return 20;
            }
            if (value.equals("VERTICAL_SCROLLBAR_NEVER")) {
                return 21;
            }
            if (value.equals("VERTICAL_SCROLLBAR_ALWAYS")) {
                return 22;
            }
        }
        return intValue;
    }

    private void setVerticalScrollBarPolicy(String policy) {
        this.setStringProperty("/XUI/global/style/verticalScrollBarPolicy", policy);
    }

    public void setVerticalScrollBarPolicyToAsNeeded() {
        this.setVerticalScrollBarPolicy("VERTICAL_SCROLLBAR_AS_NEEDED");
    }

    public void setVerticalScrollBarPolicyToNever() {
        this.setVerticalScrollBarPolicy("VERTICAL_SCROLLBAR_NEVER");
    }

    public void setVerticalScrollBarPolicyToAlways() {
        this.setVerticalScrollBarPolicy("VERTICAL_SCROLLBAR_ALWAYS");
    }

    public boolean isAllowingSavingWithErrors() {
        return this.getBooleanProperty("", "/XUI/global/errorDisplay/allowSavingWithErrors");
    }

    public boolean hideRequiredState() {
        if (this._hideMandatory == -1) {
            boolean hide = this.getBooleanProperty("", "/XUI/global/errorDisplay/hideRequiredState");
            this._hideMandatory = hide ? (byte)1 : 0;
        }
        return this._hideMandatory == 1;
    }

    public boolean isRightSideErrorDisplay() {
        if (this._rightSideError == -1) {
            boolean hide = this.getBooleanProperty("", "/XUI/global/errorDisplay/rightSideErrorDisplay");
            this._rightSideError = hide ? (byte)1 : 0;
        }
        return this._rightSideError == 1;
    }

    public void setRightSideErrorDisplay(boolean isRight) {
        this.setBooleanProperty("/XUI/global/errorDisplay/rightSideErrorDisplay", isRight);
        this._rightSideError = (byte)-1;
    }

    public boolean isAllowingCopyPaste() {
        return this.getBooleanProperty("", "/XUI/global/style/caption/allowCopyPaste");
    }

    public void setAllowingSavingWithErrors(boolean allowSaving) {
        this.setBooleanProperty("/XUI/global/errorDisplay/allowSavingWithErrors", allowSaving);
    }

    public void setIsUsingAnnotationHelp(boolean use) {
        this.setBooleanProperty("/XUI/global/general/useAnnotationAsHelp", use);
    }

    public void setAllowCopyPaste(boolean allow) {
        this.setBooleanProperty("/XUI/global/style/caption/allowCopyPaste", allow);
    }

    public boolean isEditable() {
        return this.getBooleanProperty("", "/XUI/global/style/editable");
    }

    public void setEditable(boolean editable) {
        this.setBooleanProperty("/XUI/global/style/editable", editable);
    }

    public boolean isSingleChoiceAndSerialize() {
        return this.getBooleanProperty("", "/XUI/global/style/choiceAndEnumeration/singleChoiceAndSerialize");
    }

    public boolean isUsingQuickChooserForChoiceListEntries() {
        return this.getBooleanProperty("", "/XUI/global/style/choiceAndEnumeration/useQuickChooserForListEntries");
    }

    public void setSingleChoiceAndSerialize(boolean singleChoiceAndSerialize) {
        this.setBooleanProperty("/XUI/global/style/choiceAndEnumeration/singleChoiceAndSerialize", singleChoiceAndSerialize);
    }

    public boolean isUsingChronErrorSequence() {
        return this.getBooleanProperty("", "/XUI/global/errorDisplay/useChronErrorSequence");
    }

    public void setIsUsingChronErrorSequence(boolean chronErrorSequence) {
        this.setBooleanProperty("/XUI/global/errorDisplay/useChronErrorSequence", chronErrorSequence);
    }

    public boolean isShowAttributes() {
        return this.getBooleanProperty("", "/XUI/global/style/component/showAttributes");
    }

    public void setShowAttributes(boolean show) {
        this.setBooleanProperty("/XUI/global/style/component/showAttributes", show);
    }

    public boolean isShowHelpPanel() {
        return this.getBooleanProperty("", "/XUI/global/style/navigationTree/showHelpPanel");
    }

    public void setShowHelpPanel(boolean show) {
        this.setBooleanProperty("/XUI/global/style/navigationTree/showHelpPanel", show);
    }

    public String getGlobalTreeListEnding() {
        return this.getStringProperty("", "/XUI/global/style/navigationTree/listEnding");
    }

    public void setGlobalTreeListEnding(String ending) {
        this.setStringProperty("/XUI/global/style/navigationTree/listEnding", ending);
    }

    public boolean isDefaultTreeEntryForHeaders() {
        return this.getBooleanProperty("", "/XUI/global/style/caption/header/defaultTreeEntry");
    }

    public void setDefaultTreeEntryForHeaders(boolean showTreeEntry) {
        this.setBooleanProperty("/XUI/global/style/caption/header/defaultTreeEntry", showTreeEntry);
    }

    public boolean showAndSerializeFixedValues() {
        return this.getBooleanProperty("", "/XUI/global/style/component/showFixedValue");
    }

    public void setShowAndSerializeFixedValues(boolean showAndSerialize) {
        this.setBooleanProperty("/XUI/global/style/component/showFixedValue", showAndSerialize);
    }

    public boolean isErrorSound() {
        return this.getBooleanProperty("", "/XUI/global/errorDisplay/useErrorSound");
    }

    public boolean isUserModfiedSerialization() {
        Boolean userSerialization = this.getBooleanProperty("", "/XUI/global/style/caption/userModifiedSerialization/text()");
        if (userSerialization != null) {
            return userSerialization;
        }
        return false;
    }

    public boolean isUserModfiedSerializationCollapsed() {
        Boolean userSerialization = this.getBooleanProperty("", "/XUI/global/style/caption/userModifiedSerialization/@collapsed");
        if (userSerialization != null) {
            return userSerialization;
        }
        return false;
    }

    public boolean hasUserModfiedSerialization() {
        Boolean userSerialization = this.getBooleanProperty("", "/XUI/global/style/caption/userModifiedSerialization/text()");
        return userSerialization != null;
    }

    public boolean isUserModfiedTabSerialization() {
        boolean globalUserSer = this.isUserModfiedSerialization();
        boolean localUserSer = this.getBooleanProperty("", "/XUI/global/style/caption/tab/userModifiedSerialization");
        return globalUserSer && localUserSer;
    }

    public void setErrorSound(boolean useSound) {
        this.setBooleanProperty("/XUI/global/errorDisplay/useErrorSound", useSound);
    }

    public boolean isSerializingDefaults() {
        return this.getBooleanProperty("", "/XUI/global/general/serializeDefaults");
    }

    public boolean isSerializingEmptyContent() {
        if (this._serializingEmptyContent == -1) {
            this._serializingEmptyContent = this.getBooleanProperty("", "/XUI/global/general/serializeEmptyMandatoryContent") != false ? (byte)1 : 0;
        }
        return this._serializingEmptyContent == 1;
    }

    public void setSerializingEmptyContent(boolean serialize) {
        this._serializingEmptyContent = (byte)-1;
        this.setBooleanProperty("/XUI/global/general/serializeEmptyMandatoryContent", serialize);
    }

    public boolean isValidatingEmptyMandatoryContent() {
        return this.getBooleanProperty("", "/XUI/global/general/validateEmptyMandatoryContent");
    }

    public boolean isSerializingSimpleDefaultNullValue() {
        return this.getBooleanProperty("", "/XUI/global/general/isSerializingSimpleDefaultNullValue");
    }

    public void setSerializingSimpleDefaultNullValue(boolean serialize) {
        this.setBooleanProperty("/XUI/global/general/isSerializingSimpleDefaultNullValue", serialize);
    }

    public boolean isUsingAnnotationHelp() {
        return this.getBooleanProperty("", "/XUI/global/general/useAnnotationAsHelp");
    }

    public boolean isShowingOnlyMandatoryElements() {
        return this.getBooleanProperty("", "/XUI/global/general/showOnlyMandatoryElements");
    }

    public int useAutomaticTabbedChildrenView() {
        return this.getIntProperty("", "/XUI/global/general/automaticTabbedChildrenView");
    }

    public boolean isUsingAnnotationHelpInTooltip() {
        return this.getBooleanProperty("", "/XUI/global/general/useAnnotationInTooltip");
    }

    public boolean isAutoCreateMinOccurListItems() {
        return this.getBooleanProperty("", "/XUI/global/general/autoCreateMinOccurListItems");
    }

    public boolean isAutoCreateMaxOccurListItems() {
        return this.getBooleanProperty("", "/XUI/global/general/autoCreateMaxOccurListItems");
    }

    public void setSerializingDefaults(boolean serialize) {
        this.setBooleanProperty("/XUI/global/general/serializeDefaults", serialize);
    }

    public Boolean isSerializingAttributes() {
        return this.getBooleanProperty("", "/XUI/global/general/serializeAttributes");
    }

    public void setSerializingAttributes(boolean serialize) {
        this.setBooleanProperty("/XUI/global/general/serializeAttributes", serialize);
    }

    public String getEmailCommitXPath() {
        return this.getStringProperty("", "/XUI/global/general/emailCommitXPath");
    }

    public boolean isShowingTreeListContainer() {
        return this.getBooleanProperty("", "/XUI/global/style/navigationTree/showTreeListContainer");
    }

    public void setShowingTreeListContainer(boolean show) {
        this.setBooleanProperty("/XUI/global/style/navigationTree/showTreeListContainer", show);
    }

    public boolean isShowingTree() {
        return this.getBooleanProperty("", "/XUI/global/style/navigationTree/visible");
    }

    public boolean isShowingEditorPanel() {
        return this.getBooleanProperty("", "/XUI/global/style/editorPanel/visible");
    }

    public void setShowingTree(boolean show) {
        this.setBooleanProperty("/XUI/global/style/navigationTree/visible", show);
    }

    public boolean isShowingOptionalBorderControl() {
        return this.getBooleanProperty("", "/XUI/global/style/caption/border/showOptionalControl");
    }

    public void setShowingOptionalBorderControl(boolean show) {
        this.setBooleanProperty("/XUI/global/style/caption/border/showOptionalControl", show);
    }

    public boolean isUsingBackwardButton() {
        return this.getBooleanProperty("", "/XUI/global/style/editorPanel/showBackwardButton");
    }

    public void setIsUsingBackwardButton(boolean use) {
        this.setBooleanProperty("/XUI/global/style/editorPanel/showBackwardButton", use);
    }

    public void setIsShowingOnlyMandatoryElements(boolean showOnly) {
        this.setBooleanProperty("/XUI/global/style/showOnlyMandatoryElements", showOnly);
    }

    public boolean isUsingButtonBar() {
        return this.getBooleanProperty("", "/XUI/global/style/editorPanel/showButtonBar");
    }

    public void setIsUsingButtonBar(boolean use) {
        this.setBooleanProperty("/XUI/global/style/editorPanel/showButtonBar", use);
    }

    public boolean isUsingForwardButton() {
        return this.getBooleanProperty("", "/XUI/global/style/editorPanel/showForwardButton");
    }

    public void setIsUsingForwardButton(boolean use) {
        this.setBooleanProperty("/XUI/global/style/editorPanel/showForwardButton", use);
    }

    public boolean isUsingPlugins() {
        return this.getBooleanProperty("", "/XUI/global/general/usePlugins");
    }

    public void setIsUsingPlugins(boolean use) {
        this.setBooleanProperty("/XUI/global/general/usePlugins", use);
    }

    public boolean isUsingStatusBar() {
        return this.getBooleanProperty("", "/XUI/global/style/editorPanel/showStatusBar");
    }

    public boolean isShowingErrorSummary() {
        return this.getBooleanProperty("", "/XUI/global/errorDisplay/showErrorSummary");
    }

    public boolean displayErrorText() {
        if (JAXFrontProperties.getInstance(this.getDOM().getAppContext()).displayErrorText()) {
            return true;
        }
        if (JAXFrontProperties.getInstance().displayErrorText()) {
            return true;
        }
        return this.getBooleanProperty("", "/XUI/global/errorDisplay/displayErrorText");
    }

    public void setIsUsingStatusBar(boolean useStatusBar) {
        this.setBooleanProperty("/XUI/global/style/editorPanel/showStatusBar", useStatusBar);
    }

    public boolean isUsingNavigationKeys() {
        return this.getBooleanProperty("", "/XUI/global/style/navigationTree/useNavigationKeys");
    }

    public void setIsUsingNavigationKeys(boolean use) {
        this.setBooleanProperty("/XUI/global/style/navigationTree/useNavigationKeys", use);
    }

    public boolean isOptionalBorderCollapsed() {
        return this.getBooleanProperty("", "/XUI/global/style/caption/border/collapseOptionalControl");
    }

    public void setOptionalBorderCollapsed(boolean collapsed) {
        this.setBooleanProperty("/XUI/global/style/caption/border/collapseOptionalControl", collapsed);
    }

    public void release() {
        super.release();
        this.releaseProperties();
        this._sourceType = null;
        this._country = null;
        this._currentLocale = null;
        this._decimalFormat = null;
    }

    public void releaseProperties() {
        if (this.hasProperties()) {
            this.removeAllProperties();
        }
    }

    public boolean systemExitOnClose() {
        return this.getBooleanProperty("", "/XUI/global/general/systemExitOnClose");
    }

    public void setSystemExitOnClose(boolean exit) {
        this.setBooleanProperty("/XUI/global/general/systemExitOnClose", exit);
    }

    public boolean useOptionalCheckBox() {
        return this.getBooleanProperty("", "/XUI/global/style/component/useOptionalCheckBox");
    }

    public String getNumberSymbols() {
        if (this._numberSymb == null) {
            DecimalFormat dFormat = this.getDecimalFormat();
            if (dFormat == null) {
                dFormat = (DecimalFormat)NumberFormat.getInstance(this.getCurrentLocale());
            }
            DecimalFormatSymbols symb = dFormat.getDecimalFormatSymbols();
            this._numberSymb = "+";
            this._numberSymb = this._numberSymb + symb.getGroupingSeparator();
            this._numberSymb = this._numberSymb + symb.getDecimalSeparator();
            this._numberSymb = this._numberSymb + symb.getMinusSign();
        }
        return this._numberSymb;
    }

    public String getNegativeIntNumberSymbols() {
        if (this._negNumSymb == null) {
            DecimalFormat dFormat = this.getDecimalFormat();
            if (dFormat == null) {
                dFormat = (DecimalFormat)NumberFormat.getInstance(this.getCurrentLocale());
            }
            DecimalFormatSymbols symb = dFormat.getDecimalFormatSymbols();
            this._negNumSymb = "";
            this._negNumSymb = this._negNumSymb + symb.getMinusSign();
        }
        return this._negNumSymb;
    }

    public String getPositiveIntNumberSymbols() {
        if (this._posNumSymb == null) {
            this._posNumSymb = "+";
        }
        return this._posNumSymb;
    }

    public char getGroupingSeparator() {
        if (this._groupingSepSymb == '\u0000') {
            DecimalFormat dFormat = this.getDecimalFormat();
            if (dFormat == null) {
                dFormat = (DecimalFormat)NumberFormat.getInstance(this.getCurrentLocale());
            }
            DecimalFormatSymbols symb = dFormat.getDecimalFormatSymbols();
            this._groupingSepSymb = symb.getGroupingSeparator();
        }
        return this._groupingSepSymb;
    }

    public char getDecimalSeparator() {
        if (this._decimalSepSymb == '\u0000') {
            DecimalFormat dFormat = this.getDecimalFormat();
            if (dFormat == null) {
                dFormat = (DecimalFormat)NumberFormat.getInstance(this.getCurrentLocale());
            }
            DecimalFormatSymbols symb = dFormat.getDecimalFormatSymbols();
            this._decimalSepSymb = symb.getDecimalSeparator();
            if (this._decimalSepSymb == '\uffffffff') {
                this._decimalSepSymb = (char)46;
            }
        }
        return this._decimalSepSymb;
    }

    public void setUseOptionalCheckBox(boolean use) {
        this.setBooleanProperty("/XUI/global/style/component/useOptionalCheckBox", use);
    }

    protected void initialize() {
    }

    public String getGlobalChoiceType() {
        return this.getStringProperty("", "/XUI/global/style/choiceAndEnumeration/choiceType");
    }

    private void setGlobalChoiceType(String choiceType) {
        this.setStringProperty("/XUI/global/style/choiceAndEnumeration/choiceType", choiceType);
    }

    public void setGlobalChoiceTypeToComboBox() {
        this.setGlobalChoiceType("comboBox");
    }

    public void setGlobalChoiceTypeToRadioButtons() {
        this.setGlobalChoiceType("radioButton");
    }

    public String getGlobalChoiceOrientation() {
        return this.getStringProperty("", "/XUI/global/style/choiceAndEnumeration/choiceOrientation");
    }

    private void setGlobalChoiceOrientation(String orientation) {
        this.setStringProperty("/XUI/global/style/choiceAndEnumeration/choiceOrientation", orientation);
    }

    public void setGlobalChoiceOrientationHorizontal() {
        this.setGlobalChoiceOrientation("horizontal");
    }

    public void setGlobalChoiceOrientationVertical() {
        this.setGlobalChoiceOrientation("vertical");
    }

    public void setDefaultValuePostFix(String postFix) {
        this.setStringProperty("/XUI/global/style/choiceAndEnumeration/defaultValuePostfix", postFix);
    }

    public void setDefaultValuePreFix(String preFix) {
        this.setStringProperty("/XUI/global/style/choiceAndEnumeration/defaultValuePrefix", preFix);
    }

    public String getDefaultValuePostFix() {
        if (this._defaultPostfix == null) {
            this._defaultPostfix = this.getStringProperty("", "/XUI/global/style/choiceAndEnumeration/defaultValuePostfix");
            if (this._defaultPostfix == null) {
                String defaultPrefix = this.getStringProperty("", "/XUI/global/style/choiceAndEnumeration/defaultValuePrefix");
                this._defaultPostfix = defaultPrefix == null ? JAXFrontProperties.getDefaultValuePostFix() : "";
            }
        }
        return this._defaultPostfix;
    }

    public String getDefaultValuePreFix() {
        if (this._defaultPrefix == null) {
            this._defaultPrefix = this.getStringProperty("", "/XUI/global/style/choiceAndEnumeration/defaultValuePrefix");
            if (this._defaultPrefix == null) {
                String defaultPostfix = this.getStringProperty("", "/XUI/global/style/choiceAndEnumeration/defaultValuePostfix");
                this._defaultPrefix = defaultPostfix == null ? JAXFrontProperties.getDefaultValuePreFix() : "";
            }
        }
        return this._defaultPrefix;
    }

    public String getGlobalEnumerationType() {
        return this.getStringProperty("", "/XUI/global/style/choiceAndEnumeration/enumerationType");
    }

    private void setGlobalEnumerationType(String type) {
        this.setStringProperty("/XUI/global/style/choiceAndEnumeration/enumerationType", type);
    }

    private void setGlobalEnumerationTypeToComboBox() {
        this.setGlobalEnumerationType("comboBox");
    }

    private void setGlobalEnumerationTypeToRadioButtons() {
        this.setGlobalEnumerationType("radioButton");
    }

    public String getGlobalEnumerationOrientation() {
        return this.getStringProperty("", "/XUI/global/style/choiceAndEnumeration/enumerationOrientation");
    }

    private void setGlobalEnumerationOrientation(String orientation) {
        this.setStringProperty("/XUI/global/style/choiceAndEnumeration/enumerationOrientation", orientation);
    }

    private void setGlobalEnumerationOrientationHorizontal() {
        this.setGlobalEnumerationOrientation("horizontal");
    }

    private void setGlobalEnumerationOrientationVertical() {
        this.setGlobalEnumerationOrientation("vertical");
    }

    public boolean isGlobalChoiceTypeComboBox() {
        return this.getGlobalChoiceType() != null && this.getGlobalChoiceType().equals("comboBox");
    }

    public boolean isGlobalEnumerationTypeComboBox() {
        return this.getGlobalEnumerationType() != null && this.getGlobalEnumerationType().equals("comboBox");
    }

    public boolean isGlobalChoiceOrientationHorizontal() {
        return this.getGlobalChoiceOrientation() != null && this.getGlobalChoiceOrientation().equals("horizontal");
    }

    public boolean isGlobalEnumerationOrientationHorizontal() {
        return this.getGlobalEnumerationOrientation() != null && this.getGlobalEnumerationOrientation().equals("horizontal");
    }

    public int getTopSpaceHeader() {
        return this.getIntProperty("", "/XUI/global/style/caption/header/topIndent");
    }

    public void setTopSpaceHeader(int value) {
        this.setIntProperty("/XUI/global/style/caption/header/topIndent", value);
    }

    public int getBottomSpaceHeader() {
        return this.getIntProperty("", "/XUI/global/style/caption/header/bottomIndent");
    }

    public void setBottomSpaceHeader(int bottomSpace) {
        this.setProperty("/XUI/global/style/caption/header/bottomIndent", new Integer(bottomSpace));
    }

    public int getTopSpaceBorder() {
        return this.getIntProperty("", "/XUI/global/style/caption/border/topIndent");
    }

    public void setTopSpaceBorder(int value) {
        this.setIntProperty("/XUI/global/style/caption/border/topIndent", value);
    }

    public int getInnerBottomSpaceBorder() {
        return this.getIntProperty("", "/XUI/global/style/caption/border/innerBottomIndent");
    }

    public void setInnerBottomSpaceBorder(int value) {
        this.setIntProperty("/XUI/global/style/caption/border/innerBottomIndent", value);
    }

    public int getOuterBottomSpaceBorder() {
        return this.getIntProperty("", "/XUI/global/style/caption/border/outerBottomIndent");
    }

    public void setOuterBottomSpaceBorder(int value) {
        this.setIntProperty("/XUI/global/style/caption/border/outerBottomIndent", value);
    }

    public int getTopSpaceModernSeparator() {
        return this.getIntProperty("", "/XUI/global/style/caption/separator/modern/topIndent");
    }

    public void setTopSpaceModernSeparator(int value) {
        this.setIntProperty("/XUI/global/style/caption/separator/modern/topIndent", value);
    }

    public int getBottomSpaceModernSeparator() {
        return this.getIntProperty("", "/XUI/global/style/caption/separator/modern/bottomIndent");
    }

    public void setBottomSpaceModernSeparator(int bottomSpace) {
        this.setProperty("/XUI/global/style/caption/separator/modern/bottomIndent", new Integer(bottomSpace));
    }

    public int getTopSpaceClassicSeparator() {
        return this.getIntProperty("", "/XUI/global/style/caption/separator/classic/topIndent");
    }

    public void setTopSpaceClassicSeparator(int value) {
        this.setIntProperty("/XUI/global/style/caption/separator/classic/topIndent", value);
    }

    public int getBottomSpaceClassicSeparator() {
        return this.getIntProperty("", "/XUI/global/style/caption/separator/classic/bottomIndent");
    }

    public void setBottomSpaceClassicSeparator(int bottomSpace) {
        this.setProperty("/XUI/global/style/caption/separator/classic/bottomIndent", new Integer(bottomSpace));
    }

    public int getTopSpaceTabs() {
        return this.getIntProperty("", "/XUI/global/style/caption/tab/topIndent");
    }

    public void setTopSpaceTabs(int value) {
        this.setIntProperty("/XUI/global/style/caption/tab/topIndent", value);
    }

    public int getBottomSpaceTabs() {
        return this.getIntProperty("", "/XUI/global/style/caption/tab/bottomIndent");
    }

    public void setBottomSpaceTabs(int bottomSpace) {
        this.setProperty("/XUI/global/style/caption/tab/bottomIndent", new Integer(bottomSpace));
    }

    public int getTopSpaceComponent() {
        return this.getIntProperty("", "/XUI/global/style/component/topIndent");
    }

    public void setTopSpaceComponent(int value) {
        this.setIntProperty("/XUI/global/style/component/topIndent", value);
    }

    public int getBottomSpaceComponent() {
        return this.getIntProperty("", "/XUI/global/style/bottomIndent");
    }

    public void setBottomSpaceComponent(int bottomSpace) {
        this.setProperty("/XUI/global/style/bottomIndent", new Integer(bottomSpace));
    }

    public boolean hasBorderTopSpace() {
        return this.getTopSpaceBorder() > 0;
    }

    public boolean hasInnerBorderBottomSpace() {
        return this.getInnerBottomSpaceBorder() > 0;
    }

    public boolean hasOuterBorderBottomSpace() {
        return this.getOuterBottomSpaceBorder() > 0;
    }

    public boolean hasHeaderTopSpace() {
        return this.getTopSpaceHeader() > 0;
    }

    public boolean hasHeaderBottomSpace() {
        return this.getBottomSpaceHeader() > 0;
    }

    public boolean hasModernSepTopSpace() {
        return this.getTopSpaceModernSeparator() > 0;
    }

    public boolean hasModernSepBottomSpace() {
        return this.getBottomSpaceModernSeparator() > 0;
    }

    public boolean hasClassicSepTopSpace() {
        return this.getTopSpaceClassicSeparator() > 0;
    }

    public boolean hasClassicSepBottomSpace() {
        return this.getBottomSpaceClassicSeparator() > 0;
    }

    public boolean hasTabsTopSpace() {
        return this.getTopSpaceTabs() > 0;
    }

    public boolean hasTabsBottomSpace() {
        return this.getBottomSpaceTabs() > 0;
    }

    public boolean hasComponentTopSpace() {
        return this.getTopSpaceComponent() > 0;
    }

    public boolean hasComponentBottomSpace() {
        return this.getBottomSpaceComponent() > 0;
    }

    public String getBooleanVisualizerButtonSequence() {
        return this.getStringProperty("", "/XUI/global/style/component/booleanButtonSequence");
    }

    public boolean isUsingBooleanDefaultOption() {
        return this.getBooleanProperty("", "/XUI/global/style/component/useDefaultBooleanOption");
    }

    public int getLeafSize() {
        return this.getDoubleProperty("", "/XUI/global/style/component/leafSize").intValue();
    }

    public void setBooleanVisualizerButtonSequence(String buttonSequence) {
        this.setStringProperty("/XUI/global/style/component/booleanButtonSequence", buttonSequence);
    }

    public String getBooleanVisualizerType() {
        return this.getStringProperty("", "/XUI/global/style/component/booleanType");
    }

    public void setBooleanVisualizerType(String type) {
        this.setProperty("/XUI/global/style/component/booleanType", type);
    }

    public boolean isFirstRadioButtonYes() {
        String buttonSequence = this.getBooleanVisualizerButtonSequence();
        return buttonSequence != null && buttonSequence.startsWith("yes");
    }

    public int getGlobalTopIndent() {
        return this.getIntProperty("", "/XUI/global/style/topIndent");
    }

    public void setGlobalTopIndent(int value) {
        this.setIntProperty("/XUI/global/style/topIndent", value);
    }

    public int getGlobalBottomIndent() {
        return this.getIntProperty("", "/XUI/global/style/bottomIndent");
    }

    public void setGlobalBottomIndent(int value) {
        this.setIntProperty("/XUI/global/style/caption/bottomIndent", value);
    }

    public int getGlobalLeftIndent() {
        return this.getIntProperty("", "/XUI/global/style/leftIndent");
    }

    public void setGlobalLeftIndent(int value) {
        this.setIntProperty("/XUI/global/style/leftIndent", value);
    }

    public int getGlobalRightIndent() {
        return this.getIntProperty("", "/XUI/global/style/rightIndent");
    }

    public void setGlobalRightIndent(int value) {
        this.setIntProperty("/XUI/global/style/rightIndent", value);
    }

    public int getGlobalVisibleRowCount() {
        return this.getIntProperty("", "/XUI/global/style/component/visibleListItems");
    }

    public void setGlobalVisibleRowCount(int value) {
        this.setIntProperty("/XUI/global/style/component/visibleListItems", value);
    }

    public int getMinWorkspaceWidth() {
        return this.getIntProperty("", "/XUI/global/style/minWorkspaceWidth");
    }

    public void setMinWorkspaceWidth(int value) {
        this.setIntProperty("/XUI/global/style/minWorkspaceWidth", value);
    }

    protected void initializeFor(String relativeXPath, CompositeType type, boolean useTagName) {
        Iterator iterator = type.getComposites().iterator();
        Type childType = null;
        SimpleType st = null;
        String xpath = null;
        while (iterator.hasNext()) {
            childType = (Type)iterator.next();
            if (childType.isSimple()) {
                st = (SimpleType)childType;
                if (st.getValue() == null || st.getDefaultValue() != null && st.getValue().equals(st.getDefaultValue())) continue;
                xpath = st.getXPathLocation();
                Object value = GlobalDefinition.getValue(st, st.getValue());
                this.setProperty(xpath, value);
                continue;
            }
            if (!childType.isComposite()) continue;
            this.initializeFor(type.getName(), (CompositeType)childType, useTagName);
        }
    }

    public void setDecimalFormat(DecimalFormat format) {
        this._decimalFormat = format;
    }

    protected Integer getIntProperty(String path) {
        Integer integerValue = (Integer)this.getObjectProperty("", path, true);
        return integerValue;
    }

    protected String getStringProperty(String path) {
        String value = this.getProperty("", path);
        return value;
    }

    public Boolean getBooleanProperty(String path) {
        Boolean booleanValue = (Boolean)this.getObjectProperty("", path, true);
        return booleanValue;
    }

    public Map getXUIProperties() {
        if (this._properties == null) {
            this._properties = new Hashtable();
        }
        return this._properties;
    }

    public Type getXUIType() {
        return this._xuiType;
    }

    public boolean hideEmptyElements() {
        return this._hideEmptyElements;
    }

    public boolean useGlobalUIDefintions() {
        if (LicenseChecker.getInstance().isProfessionalEdition()) {
            return false;
        }
        if (this._useGlobalTypes == -1) {
            return JAXFrontProperties.getInstance(this.getDOM() == null ? null : this.getDOM().getAppContext()).isUsingGlobalUIDefinitions();
        }
        return this._useGlobalTypes == 1;
    }

    public void setUseGlobalTypes(boolean use) {
        this._useGlobalTypes = use ? (short)1 : 0;
    }

    public String getTimeInputMask(String pattern) {
        return StringUtil.replaceLetters(pattern, " ");
    }

    public String getTimeInputMask() {
        if (this._timeInputMask == null) {
            this._timeInputMask = StringUtil.replaceLetters(this.getTimeFormatStringPattern(this.getCurrentLocale()), " ");
        }
        return this._timeInputMask;
    }

    public String getDateInputMask() {
        if (this._dateInputMask == null) {
            this._dateInputMask = StringUtil.replaceLetters(this.getDateFormatStringPattern(this.getCurrentLocale()), " ");
        }
        return this._dateInputMask;
    }

    public String getDateTimeInputMask() {
        if (this._dateTimeInputMask == null) {
            this._dateTimeInputMask = StringUtil.replaceLetters(this.getDateTimeFormatStringPattern(this.getCurrentLocale()), " ");
        }
        return this._dateTimeInputMask;
    }

    public boolean isSoftBinding() {
        return this._softBinding;
    }

    public void setSoftBinding(boolean soft) {
        this._softBinding = soft;
    }

    public boolean allowRadioButtonDeselection() {
        return this.getBooleanProperty("", "/XUI/global/general/allowRadioButtonDeselection");
    }

    public void allowRadioButtonDeselection(boolean allow) {
        this.setBooleanProperty("/XUI/global/general/allowRadioButtonDeselection", allow);
    }

    public boolean isSerializingExtendedPIInfo() {
        if (this._serializingExtendedPI == -1) {
            this._serializingExtendedPI = this.getBoolean("", "/XUI/global/general/serializeExtendedPIInfo") ? (byte)1 : 0;
        }
        return this._serializingExtendedPI == 1;
    }

    public boolean isUseComboSelectionForAbstractChoice() {
        if (this._useComboSelection == -1) {
            this._useComboSelection = this.getBooleanProperty("", "/XUI/global/style/choiceAndEnumeration/useComboSelectionForAbstractChoice") != false ? (byte)1 : 0;
        }
        return this._useComboSelection == 1;
    }

    public boolean isAddListEntryAfter() {
        return this._addListEntryAfter;
    }

    public void setAddListEntryAfter(boolean end) {
        this.setBooleanProperty("/XUI/global/general/addListItemAfter", end);
        this._addListEntryAfter = end;
    }

    public DecimalFormat getExponentialToStringFormat() {
        if (this.exponentialToStringFormat == null) {
            this.exponentialToStringFormat = new DecimalFormat();
            this.exponentialToStringFormat.setGroupingUsed(false);
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            this.exponentialToStringFormat.setDecimalFormatSymbols(symbols);
            this.exponentialToStringFormat.setMaximumFractionDigits(this.getMaximunFractionDigits());
        }
        return this.exponentialToStringFormat;
    }

    private int getMaximunFractionDigits() {
        int maxFrac = this.getIntProperty("", "/XUI/global/style/component/maxFractionDigits");
        if (maxFrac == -1) {
            maxFrac = 340;
        }
        return maxFrac;
    }

    public String convertExponentialValue(String number) throws NumberFormatException {
        if (number != null && (number.indexOf("e") > -1 || number.indexOf("E") > -1) && (number = this.getExponentialToStringFormat().format(Double.parseDouble(number))).endsWith(".0")) {
            number = number.substring(0, number.length() - 2);
        }
        return number;
    }
}

