/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import java.io.StringReader;
import java.util.Vector;
import org.nfunk.jep.EvaluatorVisitor;
import org.nfunk.jep.FunctionTable;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Parser;
import org.nfunk.jep.ParserDumpVisitor;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.function.Abs;
import org.nfunk.jep.function.Angle;
import org.nfunk.jep.function.ArcCosine;
import org.nfunk.jep.function.ArcCosineH;
import org.nfunk.jep.function.ArcSine;
import org.nfunk.jep.function.ArcSineH;
import org.nfunk.jep.function.ArcTanH;
import org.nfunk.jep.function.ArcTangent;
import org.nfunk.jep.function.Cosine;
import org.nfunk.jep.function.CosineH;
import org.nfunk.jep.function.Imaginary;
import org.nfunk.jep.function.Logarithm;
import org.nfunk.jep.function.Modulus;
import org.nfunk.jep.function.NaturalLogarithm;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.function.Random;
import org.nfunk.jep.function.Real;
import org.nfunk.jep.function.Sine;
import org.nfunk.jep.function.SineH;
import org.nfunk.jep.function.SquareRoot;
import org.nfunk.jep.function.TanH;
import org.nfunk.jep.function.Tangent;
import org.nfunk.jep.type.Complex;
import org.nfunk.jep.type.DoubleNumberFactory;
import org.nfunk.jep.type.NumberFactory;

public class JEP {
    private boolean debug = false;
    private boolean traverse;
    protected boolean allowUndeclared;
    protected boolean implicitMul;
    protected SymbolTable symTab;
    protected FunctionTable funTab;
    protected Vector errorList;
    private Parser parser;
    private Node topNode = null;
    private NumberFactory numberFactory;
    private Object _undeclatedValue;

    public JEP() {
        this.traverse = false;
        this.allowUndeclared = false;
        this.implicitMul = false;
        this.numberFactory = new DoubleNumberFactory();
        this.initSymTab();
        this.initFunTab();
        this.errorList = new Vector();
        this.parser = new Parser(new StringReader(""));
    }

    public JEP(boolean traverse_in, boolean allowUndeclared_in, boolean implicitMul_in, NumberFactory numberFactory_in) {
        this.traverse = traverse_in;
        this.allowUndeclared = allowUndeclared_in;
        this.implicitMul = implicitMul_in;
        this.numberFactory = numberFactory_in == null ? new DoubleNumberFactory() : numberFactory_in;
        this.initSymTab();
        this.initFunTab();
        this.errorList = new Vector();
        this.parser = new Parser(new StringReader(""));
        try {
            this.topNode = this.parseExpressionToNode("");
            this.getValueAsObject(this.topNode, new EvaluatorVisitor());
        }
        catch (ParseException e) {
            // empty catch block
        }
    }

    public void initSymTab() {
        this.symTab = new SymbolTable();
    }

    public void initFunTab() {
        this.funTab = new FunctionTable();
    }

    public void addStandardFunctions() {
        this.funTab.put("sin", new Sine());
        this.funTab.put("cos", new Cosine());
        this.funTab.put("tan", new Tangent());
        this.funTab.put("asin", new ArcSine());
        this.funTab.put("acos", new ArcCosine());
        this.funTab.put("atan", new ArcTangent());
        this.funTab.put("sinh", new SineH());
        this.funTab.put("cosh", new CosineH());
        this.funTab.put("tanh", new TanH());
        this.funTab.put("asinh", new ArcSineH());
        this.funTab.put("acosh", new ArcCosineH());
        this.funTab.put("atanh", new ArcTanH());
        this.funTab.put("log", new Logarithm());
        this.funTab.put("ln", new NaturalLogarithm());
        this.funTab.put("sqrt", new SquareRoot());
        this.funTab.put("angle", new Angle());
        this.funTab.put("abs", new Abs());
        this.funTab.put("mod", new Modulus());
        this.funTab.put("rand", new Random());
    }

    public void addStandardConstants() {
        this.symTab.put("pi", new Double(Math.PI));
        this.symTab.put("e", new Double(Math.E));
    }

    public Object getDefaultUndeclaredValue() {
        if (this._undeclatedValue == null) {
            return new Double(0.0);
        }
        return this._undeclatedValue;
    }

    public void setDefaultUndeclaredValue(Object undeclatedValue) {
        this._undeclatedValue = undeclatedValue;
    }

    public void addComplex() {
        this.symTab.put("i", new Complex(0.0, 1.0));
        this.funTab.put("re", new Real());
        this.funTab.put("im", new Imaginary());
    }

    public void addFunction(String functionName, PostfixMathCommandI function) {
        this.funTab.put(functionName, function);
    }

    public Double addVariable(String name, double value) {
        Double object = new Double(value);
        this.symTab.put(name, object);
        return object;
    }

    public Complex addComplexVariable(String name, double re, double im) {
        Complex object = new Complex(re, im);
        this.symTab.put(name, object);
        return object;
    }

    public void addVariableAsObject(String name, Object object) {
        if (name != null && object != null) {
            this.symTab.put(name, object);
        }
    }

    public Object removeVariable(String name) {
        return this.symTab.remove(name);
    }

    public Object removeFunction(String name) {
        return this.funTab.remove(name);
    }

    public void setTraverse(boolean value) {
        this.traverse = value;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setImplicitMul(boolean value) {
        this.implicitMul = value;
    }

    public void setAllowUndeclared(boolean value) {
        this.allowUndeclared = value;
    }

    public void parseExpression(String expression_in) {
        StringReader reader = new StringReader(expression_in);
        try {
            this.errorList.removeAllElements();
            this.topNode = this.parser.parseStream(reader, this);
        }
        catch (Throwable e) {
            this.topNode = null;
            if (e instanceof ParseException) {
                this.errorList.addElement(((ParseException)e).getErrorInfo());
            }
            if (this.debug) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            this.errorList.addElement("Syntax error");
        }
        if (this.traverse && !this.hasError()) {
            ParserDumpVisitor v = new ParserDumpVisitor();
            this.topNode.jjtAccept(v, null);
        }
    }

    public Node parseExpressionToNode(String expression_in) throws ParseException {
        StringReader reader = new StringReader(expression_in);
        Node aTopNode = null;
        try {
            this.errorList.removeAllElements();
            aTopNode = this.parser.parseStream(reader, this);
        }
        catch (Throwable e) {
            this.topNode = null;
            if (e instanceof ParseException) {
                throw (ParseException)e;
            }
            throw new ParseException(e.getMessage());
        }
        return aTopNode;
    }

    public double getValue() {
        Object value = this.getValueAsObject();
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Complex) {
            return ((Complex)value).re();
        }
        return 0.0;
    }

    public Complex getComplexValue() {
        Object value = this.getValueAsObject();
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return new Complex(((Number)value).doubleValue(), 0.0);
        }
        if (value instanceof Complex) {
            return (Complex)value;
        }
        return null;
    }

    public Object getValueAsObject() {
        if (this.topNode != null) {
            Object result;
            try {
                EvaluatorVisitor ev = new EvaluatorVisitor();
                result = ev.getValue(this.topNode, this.errorList, this.symTab);
            }
            catch (Exception e) {
                if (this.debug) {
                    System.out.println(e);
                }
                if (this.errorList == null) {
                    this.errorList = new Vector(1);
                }
                this.errorList.add(e.getMessage());
                return null;
            }
            return result;
        }
        return null;
    }

    public Object getValueAsObject(Node aTopNode, EvaluatorVisitor ev) {
        return this.getValueAsObject(aTopNode, ev, this.symTab);
    }

    public Object getValueAsObject(Node aTopNode, EvaluatorVisitor ev, SymbolTable symTable) {
        if (aTopNode != null) {
            Object result;
            try {
                if (ev == null) {
                    ev = new EvaluatorVisitor();
                }
                result = ev.getValue(aTopNode, this.errorList, symTable);
            }
            catch (Exception e) {
                if (this.errorList == null) {
                    this.errorList = new Vector(1);
                }
                this.errorList.add(e.getClass() + " " + e.getMessage());
                return null;
            }
            return result;
        }
        return null;
    }

    public FunctionTable getFunctionTable() {
        return this.funTab;
    }

    public boolean hasError() {
        return !this.errorList.isEmpty();
    }

    public String getErrorInfo() {
        if (this.hasError()) {
            String str = "";
            for (int i = 0; i < this.errorList.size(); ++i) {
                str = str + this.errorList.elementAt(i);
                if (i + 1 >= this.errorList.size()) continue;
                str = str + " | ";
            }
            return str;
        }
        return null;
    }

    public Node getTopNode() {
        return this.topNode;
    }

    public SymbolTable getSymbolTable() {
        return this.symTab;
    }

    public NumberFactory getNumberFactory() {
        return this.numberFactory;
    }

    public void removeErrors() {
        if (this.errorList != null) {
            this.errorList.clear();
        }
    }
}

