/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.TypeObject;
import org.nfunk.jep.type.Complex;
import org.nfunk.jep.type.NULL;

public class Subtract
extends PostfixMathCommand {
    public Subtract() {
        this.numberOfParameters = 2;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param2 = inStack.pop();
        Object param1 = inStack.pop();
        inStack.push(this.sub(param1, param2));
    }

    public Object sub(Object param1, Object param2) throws ParseException {
        if (param1 == NULL._null) {
            param1 = new Integer(0);
        }
        if (param2 == NULL._null) {
            param2 = new Integer(0);
        }
        if (param1 instanceof Number) {
            if (param2 instanceof Number) {
                return this.sub((Number)param1, (Number)param2);
            }
            if (param2 instanceof Complex) {
                return this.sub((Number)param1, (Complex)param2);
            }
            if (param2 instanceof TypeObject) {
                return this.sub((Object)((Number)param1), ((TypeObject)param2).getMathValueTyped());
            }
        } else if (param1 instanceof Complex) {
            if (param2 instanceof Number) {
                return this.sub((Complex)param1, (Number)param2);
            }
            if (param2 instanceof Complex) {
                return this.sub((Complex)param1, (Complex)param2);
            }
            if (param2 instanceof TypeObject) {
                return this.sub((Object)((Complex)param1), ((TypeObject)param2).getMathValueTyped());
            }
        } else {
            if (param1 instanceof List) {
                if (param2 instanceof List) {
                    ArrayList param1copy = new ArrayList((List)param1);
                    for (int p2 = 0; p2 < ((List)param2).size(); ++p2) {
                        param1copy.remove(((List)param2).get(p2));
                    }
                    return param1copy;
                }
                return param1;
            }
            if (param1 instanceof TypeObject) {
                if (param2 instanceof TypeObject) {
                    return this.sub(((TypeObject)param1).getMathValueTyped(), ((TypeObject)param2).getMathValueTyped());
                }
                if (param2 instanceof Number) {
                    return this.sub((Complex)param1, (Number)param2);
                }
                if (param2 instanceof Complex) {
                    return this.sub((Complex)param1, (Complex)param2);
                }
            }
        }
        throw new ParseException("Invalid parameter type: " + param1 + " Substract " + param2);
    }

    public Double sub(Number d1, Number d2) {
        return new Double(d1.doubleValue() - d2.doubleValue());
    }

    public Complex sub(Complex c1, Complex c2) {
        return new Complex(c1.re() - c2.re(), c1.im() - c2.im());
    }

    public Complex sub(Complex c, Number d) {
        return new Complex(c.re() - d.doubleValue(), c.im());
    }

    public Complex sub(Number d, Complex c) {
        return new Complex(d.doubleValue() - c.re(), -c.im());
    }
}

