/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.type;

public class Complex {
    private double re;
    private double im;

    public Complex() {
        this.re = 0.0;
        this.im = 0.0;
    }

    public Complex(double re_in) {
        this.re = re_in;
        this.im = 0.0;
    }

    public Complex(Number re_in) {
        this.re = re_in.doubleValue();
        this.im = 0.0;
    }

    public Complex(Complex z) {
        this.re = z.re;
        this.im = z.im;
    }

    public Complex(double re_in, double im_in) {
        this.re = re_in;
        this.im = im_in;
    }

    public double re() {
        return this.re;
    }

    public double im() {
        return this.im;
    }

    public void set(Complex z) {
        this.re = z.re;
        this.im = z.im;
    }

    public void set(double re_in, double im_in) {
        this.re = re_in;
        this.im = im_in;
    }

    public void setRe(double re_in) {
        this.re = re_in;
    }

    public void setIm(double im_in) {
        this.im = im_in;
    }

    public boolean equals(Complex b, double tolerance) {
        double temp1 = this.re - b.re;
        double temp2 = this.im - b.im;
        return temp1 * temp1 + temp2 * temp2 <= tolerance * tolerance;
    }

    public String toString() {
        return "(" + this.re + ", " + this.im + ")";
    }

    public double abs() {
        double absRe = Math.abs(this.re);
        double absIm = Math.abs(this.im);
        if (absRe == 0.0 && absIm == 0.0) {
            return 0.0;
        }
        if (absRe > absIm) {
            double temp = absIm / absRe;
            return absRe * Math.sqrt(1.0 + temp * temp);
        }
        double temp = absRe / absIm;
        return absIm * Math.sqrt(1.0 + temp * temp);
    }

    public double abs2() {
        return this.re * this.re + this.im * this.im;
    }

    public double arg() {
        return Math.atan2(this.im, this.re);
    }

    public Complex neg() {
        return new Complex(-this.re, -this.im);
    }

    public Complex mul(double b) {
        return new Complex(this.re * b, this.im * b);
    }

    public Complex mul(Complex b) {
        return new Complex(this.re * b.re - this.im * b.im, this.im * b.re + this.re * b.im);
    }

    public Complex div(Complex b) {
        double resIm;
        double resRe;
        if (Math.abs(b.re) >= Math.abs(b.im)) {
            double r = b.im / b.re;
            double den = b.re + r * b.im;
            resRe = (this.re + r * this.im) / den;
            resIm = (this.im - r * this.re) / den;
        } else {
            double r = b.re / b.im;
            double den = b.im + r * b.re;
            resRe = (this.re * r + this.im) / den;
            resIm = (this.im * r - this.re) / den;
        }
        return new Complex(resRe, resIm);
    }

    public Complex power(double exponent) {
        double scalar = Math.pow(this.abs(), exponent);
        boolean specialCase = false;
        int factor = 0;
        if (this.im == 0.0 && this.re < 0.0) {
            specialCase = true;
            factor = 2;
        }
        if (this.re == 0.0 && this.im > 0.0) {
            specialCase = true;
            factor = 1;
        }
        if (this.re == 0.0 && this.im < 0.0) {
            specialCase = true;
            factor = -1;
        }
        if (specialCase && (double)factor * exponent == (double)((int)((double)factor * exponent))) {
            short[] cSin = new short[]{0, 1, 0, -1};
            short[] cCos = new short[]{1, 0, -1, 0};
            int x = (int)((double)factor * exponent) % 4;
            if (x < 0) {
                x = 4 + x;
            }
            return new Complex(scalar * (double)cCos[x], scalar * (double)cSin[x]);
        }
        double temp = exponent * this.arg();
        return new Complex(scalar * Math.cos(temp), scalar * Math.sin(temp));
    }

    public Complex power(Complex exponent) {
        if (exponent.im == 0.0) {
            return this.power(exponent.re);
        }
        double temp1Re = Math.log(this.abs());
        double temp1Im = this.arg();
        double temp2Re = temp1Re * exponent.re - temp1Im * exponent.im;
        double temp2Im = temp1Re * exponent.im + temp1Im * exponent.re;
        double scalar = Math.exp(temp2Re);
        return new Complex(scalar * Math.cos(temp2Im), scalar * Math.sin(temp2Im));
    }

    public Complex log() {
        return new Complex(Math.log(this.abs()), this.arg());
    }

    public Complex sqrt() {
        Complex c;
        if (this.re == 0.0 && this.im == 0.0) {
            c = new Complex(0.0, 0.0);
        } else {
            double w;
            double absIm;
            double absRe = Math.abs(this.re);
            if (absRe >= (absIm = Math.abs(this.im))) {
                double r = absIm / absRe;
                w = Math.sqrt(absRe) * Math.sqrt(0.5 * (1.0 + Math.sqrt(1.0 + r * r)));
            } else {
                double r = absRe / absIm;
                w = Math.sqrt(absIm) * Math.sqrt(0.5 * (r + Math.sqrt(1.0 + r * r)));
            }
            if (this.re >= 0.0) {
                c = new Complex(w, this.im / (2.0 * w));
            } else {
                if (this.im < 0.0) {
                    w = -w;
                }
                c = new Complex(this.im / (2.0 * w), w);
            }
        }
        return c;
    }

    public Complex sin() {
        double izRe = -this.im;
        double izIm = this.re;
        double scalar = Math.exp(izRe);
        double temp1Re = scalar * Math.cos(izIm);
        double temp1Im = scalar * Math.sin(izIm);
        scalar = Math.exp(-izRe);
        double temp2Re = scalar * Math.cos(-izIm);
        double temp2Im = scalar * Math.sin(-izIm);
        return new Complex(0.5 * (temp1Im -= temp2Im), -0.5 * (temp1Re -= temp2Re));
    }

    public Complex cos() {
        double izRe = -this.im;
        double izIm = this.re;
        double scalar = Math.exp(izRe);
        double temp1Re = scalar * Math.cos(izIm);
        double temp1Im = scalar * Math.sin(izIm);
        scalar = Math.exp(-izRe);
        double temp2Re = scalar * Math.cos(-izIm);
        double temp2Im = scalar * Math.sin(-izIm);
        return new Complex(0.5 * (temp1Re += temp2Re), 0.5 * (temp1Im += temp2Im));
    }

    public Complex tan() {
        double izRe = -this.im;
        double izIm = this.re;
        double scalar = Math.exp(izRe);
        double temp1Re = scalar * Math.cos(izIm);
        double temp1Im = scalar * Math.sin(izIm);
        scalar = Math.exp(-izRe);
        double temp2Re = scalar * Math.cos(-izIm);
        double temp2Im = scalar * Math.sin(-izIm);
        Complex sinResult = new Complex(0.5 * (temp1Re -= temp2Re), 0.5 * (temp1Im -= temp2Im));
        izRe = -this.im;
        izIm = this.re;
        scalar = Math.exp(izRe);
        temp1Re = scalar * Math.cos(izIm);
        temp1Im = scalar * Math.sin(izIm);
        scalar = Math.exp(-izRe);
        temp2Re = scalar * Math.cos(-izIm);
        temp2Im = scalar * Math.sin(-izIm);
        Complex cosResult = new Complex(0.5 * (temp1Re += temp2Re), 0.5 * (temp1Im += temp2Im));
        return sinResult.div(cosResult);
    }

    public Complex asin() {
        double tempRe = 1.0 - (this.re * this.re - this.im * this.im);
        double tempIm = 0.0 - (this.re * this.im + this.im * this.re);
        Complex result = new Complex(tempRe, tempIm);
        result = result.sqrt();
        result.re += -this.im;
        result.im += this.re;
        tempRe = Math.log(result.abs());
        result.re = tempIm = result.arg();
        result.im = -tempRe;
        return result;
    }

    public Complex acos() {
        double tempRe = 1.0 - (this.re * this.re - this.im * this.im);
        double tempIm = 0.0 - (this.re * this.im + this.im * this.re);
        Complex result = new Complex(tempRe, tempIm);
        result = result.sqrt();
        tempRe = -result.im;
        tempIm = result.re;
        result.re = this.re + tempRe;
        result.im = this.im + tempIm;
        tempRe = Math.log(result.abs());
        result.re = tempIm = result.arg();
        result.im = -tempRe;
        return result;
    }

    public Complex atan() {
        Complex result = new Complex(-this.re, 1.0 - this.im);
        double tempRe = this.re;
        double tempIm = 1.0 + this.im;
        result = result.div(new Complex(tempRe, tempIm));
        tempRe = Math.log(result.abs());
        tempIm = result.arg();
        result.re = 0.5 * tempIm;
        result.im = -0.5 * tempRe;
        return result;
    }

    public Complex sinh() {
        double scalar = Math.exp(this.re);
        double temp1Re = scalar * Math.cos(this.im);
        double temp1Im = scalar * Math.sin(this.im);
        scalar = Math.exp(-this.re);
        double temp2Re = scalar * Math.cos(-this.im);
        double temp2Im = scalar * Math.sin(-this.im);
        return new Complex(0.5 * (temp1Re -= temp2Re), 0.5 * (temp1Im -= temp2Im));
    }

    public Complex cosh() {
        double scalar = Math.exp(this.re);
        double temp1Re = scalar * Math.cos(this.im);
        double temp1Im = scalar * Math.sin(this.im);
        scalar = Math.exp(-this.re);
        double temp2Re = scalar * Math.cos(-this.im);
        double temp2Im = scalar * Math.sin(-this.im);
        return new Complex(0.5 * (temp1Re += temp2Re), 0.5 * (temp1Im += temp2Im));
    }

    public Complex tanh() {
        double scalar = Math.exp(this.re);
        double temp1Re = scalar * Math.cos(this.im);
        double temp1Im = scalar * Math.sin(this.im);
        scalar = Math.exp(-this.re);
        double temp2Re = scalar * Math.cos(-this.im);
        double temp2Im = scalar * Math.sin(-this.im);
        Complex sinRes = new Complex(0.5 * (temp1Re -= temp2Re), 0.5 * (temp1Im -= temp2Im));
        scalar = Math.exp(this.re);
        temp1Re = scalar * Math.cos(this.im);
        temp1Im = scalar * Math.sin(this.im);
        scalar = Math.exp(-this.re);
        temp2Re = scalar * Math.cos(-this.im);
        temp2Im = scalar * Math.sin(-this.im);
        Complex cosRes = new Complex(0.5 * (temp1Re += temp2Re), 0.5 * (temp1Im += temp2Im));
        return sinRes.div(cosRes);
    }

    public Complex asinh() {
        Complex result = new Complex(this.re * this.re - this.im * this.im + 1.0, this.re * this.im + this.im * this.re);
        result = result.sqrt();
        result.re += this.re;
        result.im += this.im;
        double temp = result.arg();
        result.re = Math.log(result.abs());
        result.im = temp;
        return result;
    }

    public Complex acosh() {
        Complex result = new Complex(this.re * this.re - this.im * this.im - 1.0, this.re * this.im + this.im * this.re);
        result = result.sqrt();
        result.re += this.re;
        result.im += this.im;
        double temp = result.arg();
        result.re = Math.log(result.abs());
        result.im = temp;
        return result;
    }

    public Complex atanh() {
        Complex result = new Complex(1.0 + this.re, this.im);
        double tempRe = 1.0 - this.re;
        double tempIm = -this.im;
        result = result.div(new Complex(tempRe, tempIm));
        tempRe = Math.log(result.abs());
        tempIm = result.arg();
        result.re = 0.5 * tempRe;
        result.im = 0.5 * tempIm;
        return result;
    }
}

