/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.equiv;

import groove.abstraction.Multiplicity;
import groove.abstraction.MyHashMap;
import groove.abstraction.neigh.EdgeMultDir;
import groove.abstraction.neigh.NeighAbsParam;
import groove.abstraction.neigh.Util;
import groove.abstraction.neigh.equiv.EdgeEquivClass;
import groove.abstraction.neigh.equiv.EquivClass;
import groove.abstraction.neigh.equiv.EquivRelation;
import groove.abstraction.neigh.equiv.NodeEquivClass;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.EdgeRole;
import groove.util.collect.TreeHashSet;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class GraphNeighEquiv
extends EquivRelation<HostNode> {
    private int radius;
    final HostGraph graph;
    final Set<TypeLabel> binaryLabels;
    private Map<HostNode, EquivClass<HostNode>> nodeToCellMap;
    private Map<HostNode, NodeInfo> nodeToInfoMap;
    private EquivRelation<HostNode> previous;
    private TreeHashSet<EdgeEquivData> store;

    public GraphNeighEquiv(HostGraph graph, int radius) {
        assert (graph != null);
        assert (radius >= 0);
        this.graph = graph;
        this.binaryLabels = Util.getBinaryLabels(this.graph);
        this.radius = radius;
        this.previous = null;
        this.computeInitialEquivClasses();
        int i = 1;
        while (i <= this.radius) {
            this.refineEquivRelation();
            ++i;
        }
    }

    @Override
    public String toString() {
        return "Radius: " + this.radius + ", Equiv. Classes: " + super.toString();
    }

    public EquivRelation<HostNode> getPrevEquivRelation() {
        assert (this.previous != null);
        return this.previous;
    }

    private void computeInitialEquivClasses() {
        MyHashMap<BitSet, NodeEquivClass<HostNode>> labelsToClass = new MyHashMap<BitSet, NodeEquivClass<HostNode>>();
        HashMap<TypeLabel, Integer> labelNrs = new HashMap<TypeLabel, Integer>();
        Set<TypeLabel> absLabels = NeighAbsParam.getInstance().getAbsLabels();
        boolean abstractAll = absLabels.isEmpty();
        BitSet[] nodeLabelStore = new BitSet[this.graph.getFactory().getMaxNodeNr() + 1];
        for (HostNode node : this.graph.nodeSet()) {
            BitSet bitSet = new BitSet();
            nodeLabelStore[node.getNumber()] = bitSet;
            BitSet store = bitSet;
            TypeNode nodeType = node.getType();
            if (nodeType.isTopType() || !abstractAll && !absLabels.contains(nodeType.label())) continue;
            store.set(this.getLabelNr(labelNrs, nodeType.label()));
        }
        for (HostEdge edge : this.graph.edgeSet()) {
            TypeLabel label = edge.label();
            if (label.getRole() == EdgeRole.BINARY || !abstractAll && !absLabels.contains(label)) continue;
            int nodeNr = edge.source().getNumber();
            BitSet nodeLabels = nodeLabelStore[nodeNr];
            nodeLabels.set(this.getLabelNr(labelNrs, label));
        }
        for (HostNode node : this.graph.nodeSet()) {
            BitSet nodeLabels = nodeLabelStore[node.getNumber()];
            NodeEquivClass<HostNode> ec = null;
            if (!abstractAll && nodeLabels.isEmpty()) {
                ec = this.createNodeEquivClass();
                ec.add(node);
                this.add(ec);
                continue;
            }
            ec = (NodeEquivClass<HostNode>)labelsToClass.get(nodeLabels);
            if (ec == null) {
                ec = this.createNodeEquivClass();
                labelsToClass.put(nodeLabels, ec);
            }
            ec.add(node);
        }
        this.addAll(labelsToClass.values());
    }

    private int getLabelNr(Map<TypeLabel, Integer> labelNrMap, TypeLabel label) {
        Integer result = labelNrMap.get(label);
        if (result == null) {
            result = labelNrMap.size();
            labelNrMap.put(label, result);
        }
        return result;
    }

    private void refineEquivRelation() {
        this.previous = this.clone();
        EquivRelation<HostNode> newEquivClasses = new EquivRelation<HostNode>();
        EquivRelation<HostNode> delEquivClasses = new EquivRelation<HostNode>();
        this.prepareRefinement();
        for (EquivClass ec : this) {
            this.refineEquivClass(ec, newEquivClasses, delEquivClasses);
        }
        this.removeAll(delEquivClasses);
        this.addAll(newEquivClasses);
    }

    private void refineEquivClass(EquivClass<HostNode> ec, EquivRelation<HostNode> newEquivClasses, EquivRelation<HostNode> delEquivClasses) {
        if (ec.size() == 1) {
            return;
        }
        HashMap<NodeInfo, NodeEquivClass<HostNode>> partition = new HashMap<NodeInfo, NodeEquivClass<HostNode>>();
        Map<HostNode, NodeInfo> nodeToInfoMap = this.getNodeToInfoMap();
        for (HostNode n : ec) {
            NodeInfo info = nodeToInfoMap.get(n);
            NodeEquivClass<HostNode> cell = (NodeEquivClass<HostNode>)partition.get(info);
            if (cell == null) {
                cell = this.createNodeEquivClass();
                partition.put(info, cell);
            }
            cell.add(n);
        }
        if (partition.size() > 1) {
            newEquivClasses.addAll(partition.values());
            delEquivClasses.add(ec);
        }
    }

    private void prepareRefinement() {
        this.nodeToCellMap = null;
        this.nodeToInfoMap = null;
    }

    Map<HostNode, EquivClass<HostNode>> getNodeToCellMap() {
        if (this.nodeToCellMap == null) {
            this.nodeToCellMap = new HashMap<HostNode, EquivClass<HostNode>>();
            for (EquivClass ec : this) {
                for (HostNode node : ec) {
                    this.nodeToCellMap.put(node, ec);
                }
            }
        }
        return this.nodeToCellMap;
    }

    Map<HostNode, NodeInfo> getNodeToInfoMap() {
        if (this.nodeToInfoMap == null) {
            this.nodeToInfoMap = this.computeNodeToInfoMap();
        }
        return this.nodeToInfoMap;
    }

    Map<HostNode, NodeInfo> computeNodeToInfoMap() {
        Map<HostNode, NodeInfo> result = this.createNodeToInfoMap();
        Map<HostNode, EquivClass<HostNode>> nodeToCellMap = this.getNodeToCellMap();
        for (HostEdge edge : this.graph.edgeSet()) {
            EdgeMultDir[] edgeMultDirArray = EdgeMultDir.values();
            int n = edgeMultDirArray.length;
            int n2 = 0;
            while (n2 < n) {
                EdgeMultDir dir = edgeMultDirArray[n2];
                NodeInfo sourceInfo = result.get(dir.incident(edge));
                EquivClass<HostNode> targetEc = nodeToCellMap.get(dir.opposite(edge));
                sourceInfo.add(dir, edge.label(), targetEc, Multiplicity.ONE_EDGE_MULT);
                ++n2;
            }
        }
        return result;
    }

    Map<HostNode, NodeInfo> createNodeToInfoMap() {
        HashMap<HostNode, NodeInfo> result = new HashMap<HostNode, NodeInfo>();
        for (HostNode node : this.graph.nodeSet()) {
            result.put(node, new NodeInfo());
        }
        return result;
    }

    private NodeEquivClass<HostNode> createNodeEquivClass() {
        return new NodeEquivClass<HostNode>(this.graph.getFactory());
    }

    public EquivRelation<HostEdge> getEdgesEquivRel() {
        this.store = new TreeHashSet();
        MyHashMap edgeMap = new MyHashMap();
        for (HostEdge edge : this.graph.edgeSet()) {
            EdgeEquivData eed = this.getNormalEdgeEquivData(edge);
            EdgeEquivClass edges = (EdgeEquivClass)edgeMap.get(eed);
            if (edges == null) {
                edges = new EdgeEquivClass();
                edgeMap.put(eed, edges);
            }
            edges.add(edge);
        }
        EquivRelation<HostEdge> er = new EquivRelation<HostEdge>();
        er.addAll(edgeMap.values());
        return er;
    }

    private EdgeEquivData getNormalEdgeEquivData(HostEdge edge) {
        EdgeEquivData eed = new EdgeEquivData(edge);
        EdgeEquivData result = this.store.put(eed);
        if (result == null) {
            result = eed;
        }
        return result;
    }

    private class EdgeEquivData {
        final EquivClass<HostNode> srcEc;
        final TypeLabel label;
        final EquivClass<HostNode> tgtEc;
        final int hashCode;

        EdgeEquivData(HostEdge edge) {
            this.srcEc = GraphNeighEquiv.this.getEquivClassOf(edge.source());
            this.label = edge.label();
            this.tgtEc = GraphNeighEquiv.this.getEquivClassOf(edge.target());
            this.hashCode = this.computeHashCode();
        }

        public boolean equals(Object o) {
            boolean result;
            if (this == o) {
                result = true;
            } else if (!(o instanceof EdgeEquivData)) {
                result = false;
            } else {
                EdgeEquivData eed = (EdgeEquivData)o;
                boolean bl = result = this.label.equals(eed.label) && this.srcEc.equals(eed.srcEc) && this.tgtEc.equals(eed.tgtEc);
            }
            assert (!result || this.hashCode() == o.hashCode());
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }

        private int computeHashCode() {
            int result = 1;
            result = 31 * result + this.label.hashCode();
            result = 31 * result + this.srcEc.hashCode();
            result = 31 * result + this.tgtEc.hashCode();
            return result;
        }
    }

    class NodeInfo
    extends EnumMap<EdgeMultDir, Map<TypeLabel, Map<EquivClass<HostNode>, Multiplicity>>> {
        private int hashcode;

        NodeInfo() {
            super(EdgeMultDir.class);
            EdgeMultDir[] edgeMultDirArray = EdgeMultDir.values();
            int n = edgeMultDirArray.length;
            int n2 = 0;
            while (n2 < n) {
                EdgeMultDir dir = edgeMultDirArray[n2];
                this.put(dir, new HashMap());
                ++n2;
            }
        }

        void add(EdgeMultDir dir, TypeLabel label, EquivClass<HostNode> ec, Multiplicity mult) {
            Multiplicity oldMult;
            Map labelMap = (Map)this.get((Object)dir);
            HashMap<EquivClass<HostNode>, Multiplicity> ecMap = (HashMap<EquivClass<HostNode>, Multiplicity>)labelMap.get(label);
            if (ecMap == null) {
                ecMap = new HashMap<EquivClass<HostNode>, Multiplicity>();
                labelMap.put(label, ecMap);
            }
            Multiplicity newMult = (oldMult = (Multiplicity)ecMap.get(ec)) == null ? mult : oldMult.add(mult);
            ecMap.put(ec, newMult);
        }

        @Override
        public int hashCode() {
            if (this.hashcode == 0) {
                this.hashcode = super.hashCode();
                if (this.hashcode == 0) {
                    this.hashcode = 1;
                }
            }
            return this.hashcode;
        }
    }
}

