/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.gui.jgraph;

import groove.abstraction.MyHashMap;
import groove.abstraction.neigh.EdgeMultDir;
import groove.abstraction.neigh.Util;
import groove.abstraction.neigh.equiv.EquivClass;
import groove.abstraction.neigh.equiv.EquivRelation;
import groove.abstraction.neigh.gui.jgraph.EcJVertex;
import groove.abstraction.neigh.gui.jgraph.ShapeJEdge;
import groove.abstraction.neigh.gui.jgraph.ShapeJGraph;
import groove.abstraction.neigh.gui.jgraph.ShapeJPort;
import groove.abstraction.neigh.gui.jgraph.ShapeJVertex;
import groove.abstraction.neigh.shape.EdgeSignature;
import groove.abstraction.neigh.shape.Shape;
import groove.abstraction.neigh.shape.ShapeEdge;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.graph.Edge;
import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JModel;
import groove.util.Duo;
import java.util.Map;
import org.jgraph.graph.ParentMap;

public class ShapeJModel
extends JModel<Shape> {
    private ParentMap parentMap;
    private final Map<EdgeSignature, ShapeJPort> esMap = new MyHashMap<EdgeSignature, ShapeJPort>();

    ShapeJModel(ShapeJGraph jGraph) {
        super(jGraph);
    }

    @Override
    public Shape getGraph() {
        return (Shape)super.getGraph();
    }

    @Override
    public void loadGraph(Shape graph) {
        this.setVetoFireGraphChanged(true);
        this.parentMap = new ParentMap();
        this.esMap.clear();
        this.prepareLoad(graph);
        this.prepareInsert();
        this.createNodes();
        this.createEdgeSigPorts();
        this.createEdges();
        this.createEdgeMults();
        this.createEquivClasses();
        this.setVetoFireGraphChanged(false);
        this.doInsert(true);
    }

    @Override
    protected ParentMap getParentMap() {
        return this.parentMap;
    }

    @Override
    protected JCell<Shape> addEdge(Edge edge) {
        JCell<Shape> jCell = super.addEdge(edge);
        if (jCell instanceof ShapeJEdge) {
            ShapeEdge shapeEdge = (ShapeEdge)edge;
            ShapeJEdge jEdge = (ShapeJEdge)jCell;
            Shape shape = this.getGraph();
            EdgeSignature outEs = shape.getEdgeSignature(shapeEdge, EdgeMultDir.OUTGOING);
            EdgeSignature inEs = shape.getEdgeSignature(shapeEdge, EdgeMultDir.INCOMING);
            ShapeJPort srcPort = this.getPort(outEs);
            ShapeJPort tgtPort = this.getPort(inEs);
            assert (srcPort != null && tgtPort != null);
            this.connections.connect((Object)jEdge, (Object)srcPort, (Object)tgtPort);
        }
        return jCell;
    }

    public ShapeJPort getPort(EdgeSignature es) {
        ShapeJPort result = this.esMap.get(es);
        assert (result != null);
        return result;
    }

    private void createNodes() {
        for (ShapeNode node : this.getGraph().nodeSet()) {
            this.addNode(node);
        }
    }

    private void createEdgeSigPorts() {
        Shape shape = this.getGraph();
        for (EdgeSignature es : shape.getEdgeSigSet()) {
            ShapeJVertex vertex = (ShapeJVertex)this.getJCellForNode(es.getNode());
            boolean alwaysMovable = shape.isEdgeSigUnique(es);
            ShapeJPort port = new ShapeJPort(vertex, es, alwaysMovable);
            this.esMap.put(es, port);
        }
    }

    private void createEdges() {
        for (ShapeEdge edge : this.getGraph().edgeSet()) {
            this.addEdge(edge);
        }
    }

    private void createEdgeMults() {
        Shape shape = this.getGraph();
        for (ShapeEdge edgeS : Util.getBinaryEdges(shape)) {
            ShapeJEdge jEdge = (ShapeJEdge)this.getJCellForEdge(edgeS);
            Duo<String> duo = shape.getEdgeMultLabels(edgeS);
            String[] labels = new String[2];
            labels[0] = (String)duo.one();
            if (!"".equals(labels[0])) {
                jEdge.setMainTgt(true);
            }
            labels[1] = (String)duo.two();
            if ("".equals(labels[1])) continue;
            jEdge.setMainSrc(true);
        }
    }

    private void createEquivClasses() {
        Shape shape = this.getGraph();
        EquivRelation<ShapeNode> er = shape.getEquivRelation();
        for (EquivClass equivClass : er) {
            EcJVertex ecJCell = EcJVertex.newInstance();
            ecJCell.setJModel(this);
            for (ShapeNode node : equivClass) {
                this.parentMap.addEntry(this.getJCellForNode(node), (Object)ecJCell);
            }
            this.addedJCells.add(ecJCell);
        }
    }
}

