/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.shape;

import groove.abstraction.neigh.EdgeMultDir;
import groove.abstraction.neigh.equiv.EquivClass;
import groove.abstraction.neigh.shape.ShapeEdge;
import groove.abstraction.neigh.shape.ShapeGraph;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.grammar.host.HostNode;
import groove.grammar.type.TypeLabel;
import groove.graph.Label;
import java.util.HashSet;
import java.util.Set;

public final class EdgeSignature {
    private final EdgeMultDir direction;
    private final TypeLabel label;
    private final ShapeNode node;
    private final EquivClass<ShapeNode> equivClass;
    private final int hashCode;

    public EdgeSignature(EdgeMultDir direction, ShapeNode node, TypeLabel label, EquivClass<? extends HostNode> equivClass) {
        this.direction = direction;
        this.label = label;
        this.node = node;
        equivClass.setFixed();
        this.equivClass = equivClass;
        this.hashCode = this.computeHashCode();
    }

    public String toString() {
        return (Object)((Object)this.direction) + ":(" + this.node + ", " + this.label + ", " + this.equivClass + ")";
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof EdgeSignature)) {
            result = false;
        } else {
            EdgeSignature es = (EdgeSignature)o;
            boolean bl = result = this.direction.equals((Object)es.direction) && this.node.equals(es.node) && this.label.equals(es.label) && this.hasSameEquivClass(es.equivClass);
        }
        assert (!result || this.hashCode() == o.hashCode());
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int result = 1;
        result = 31 * result + this.direction.hashCode();
        result = 31 * result + this.node.hashCode();
        result = 31 * result + this.label.hashCode();
        result = 31 * result + this.equivClass.hashCode();
        return result;
    }

    public boolean mayContain(ShapeEdge edge) {
        ShapeNode incident = this.direction.incident(edge);
        ShapeNode opposite = this.direction.opposite(edge);
        return this.node.equals(incident) && this.label.equals(edge.label()) && this.equivClass.contains(opposite);
    }

    public boolean hasEdges(ShapeGraph shape) {
        boolean result = false;
        boolean outgoing = this.direction == EdgeMultDir.OUTGOING;
        for (ShapeNode opposite : this.getEquivClass()) {
            ShapeNode target;
            ShapeNode source = outgoing ? this.node : opposite;
            ShapeEdge edge = shape.createEdge(source, (Label)this.label, target = outgoing ? opposite : this.node);
            if (!shape.containsEdge(edge)) continue;
            result = true;
            break;
        }
        return result;
    }

    public Set<ShapeEdge> findEdges(ShapeGraph shape) {
        HashSet<ShapeEdge> result = new HashSet<ShapeEdge>();
        boolean outgoing = this.direction == EdgeMultDir.OUTGOING;
        for (ShapeNode opposite : this.getEquivClass()) {
            ShapeNode target;
            ShapeNode source = outgoing ? this.node : opposite;
            ShapeEdge edge = shape.createEdge(source, (Label)this.label, target = outgoing ? opposite : this.node);
            if (!shape.containsEdge(edge)) continue;
            result.add(edge);
        }
        return result;
    }

    public EdgeMultDir getDirection() {
        return this.direction;
    }

    public ShapeNode getNode() {
        return this.node;
    }

    public TypeLabel getLabel() {
        return this.label;
    }

    public EquivClass<ShapeNode> getEquivClass() {
        return this.equivClass;
    }

    public boolean hasSameEquivClass(EquivClass<ShapeNode> ec) {
        return this.equivClass.equals(ec);
    }

    public boolean isSelfReferencing() {
        return this.equivClass.contains(this.node);
    }
}

