/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.shape;

import groove.abstraction.Multiplicity;
import groove.abstraction.MyHashMap;
import groove.abstraction.neigh.equiv.EquivRelation;
import groove.abstraction.neigh.shape.EdgeSignatureStore;
import groove.abstraction.neigh.shape.ShapeEdge;
import groove.abstraction.neigh.shape.ShapeFactory;
import groove.abstraction.neigh.shape.ShapeGraph;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.abstraction.neigh.shape.ShapeStore;
import groove.abstraction.neigh.shape.ShapeStore1;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostElement;
import groove.grammar.host.HostNode;
import groove.graph.GraphCache;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class ShapeCache
extends GraphCache<HostNode, HostEdge> {
    private Set<ShapeNode> nodeSet;
    private Set<ShapeEdge> edgeSet;
    private EquivRelation<ShapeNode> equivRel;
    private MyHashMap<ShapeNode, Multiplicity> nodeMultMap;
    private EdgeSignatureStore edgeSigStore;
    private static final ShapeStore STORE_PROTOTYPE = ShapeStore1.PROTOTYPE;

    ShapeCache(ShapeGraph graph) {
        super(graph, true);
    }

    void copyFrom(ShapeGraph original) {
        ShapeCache other = original.getCache();
        this.nodeSet = this.createElementSet();
        this.nodeSet.addAll(other.getNodeSet());
        this.edgeSet = this.createElementSet();
        this.edgeSet.addAll(other.getEdgeSet());
        if (other.equivRel != null) {
            this.equivRel = other.equivRel.clone();
        }
        if (other.nodeMultMap != null) {
            this.nodeMultMap = other.nodeMultMap.clone();
        }
        if (other.edgeSigStore != null) {
            this.edgeSigStore = this.getGraph().createEdgeSigStore();
            this.edgeSigStore.copyFrom(other.getEdgeSigStore());
        }
    }

    public ShapeGraph getGraph() {
        return (ShapeGraph)super.getGraph();
    }

    ShapeFactory getFactory() {
        return this.getGraph().getFactory();
    }

    int getNodeStoreSize() {
        return this.getNodeCounter().getCount();
    }

    Set<ShapeNode> getNodeSet() {
        if (this.nodeSet == null) {
            ShapeStore store = this.getGraph().store;
            if (store == null) {
                this.setNodeSet(this.createElementSet());
            } else {
                store.fill(this);
            }
        }
        return this.nodeSet;
    }

    void setNodeSet(Set<ShapeNode> nodeSet) {
        this.nodeSet = nodeSet;
    }

    Set<ShapeEdge> getEdgeSet() {
        if (this.edgeSet == null) {
            ShapeStore store = this.getGraph().store;
            if (store == null) {
                this.setEdgeSet(this.createElementSet());
            } else {
                store.fill(this);
            }
        }
        return this.edgeSet;
    }

    void setEdgeSet(Set<ShapeEdge> edgeSet) {
        this.edgeSet = edgeSet;
    }

    EquivRelation<ShapeNode> getEquivRel() {
        if (this.equivRel == null) {
            ShapeStore store = this.getGraph().store;
            if (store == null) {
                this.setEquivRel(this.createNodeEquiv());
            } else {
                store.fill(this);
            }
        }
        return this.equivRel;
    }

    void setEquivRel(EquivRelation<ShapeNode> equivRel) {
        this.equivRel = equivRel;
    }

    MyHashMap<ShapeNode, Multiplicity> getNodeMultMap() {
        if (this.nodeMultMap == null) {
            ShapeStore store = this.getGraph().store;
            if (store == null) {
                this.setNodeMultMap(this.createNodeMultMap());
            } else {
                store.fill(this);
            }
        }
        return this.nodeMultMap;
    }

    void setNodeMultMap(MyHashMap<ShapeNode, Multiplicity> nodeMultMap) {
        this.nodeMultMap = nodeMultMap;
    }

    EdgeSignatureStore getEdgeSigStore() {
        if (this.edgeSigStore == null) {
            ShapeStore store = this.getGraph().store;
            if (store == null) {
                this.setEdgeSigStore(this.getGraph().createEdgeSigStore());
            } else {
                store.fill(this);
            }
        }
        return this.edgeSigStore;
    }

    void setEdgeSigStore(EdgeSignatureStore edgeSigStore) {
        this.edgeSigStore = edgeSigStore;
    }

    void flatten() {
        this.getGraph().store = STORE_PROTOTYPE.flatten(this);
    }

    EquivRelation<ShapeNode> createNodeEquiv() {
        return new EquivRelation<ShapeNode>();
    }

    MyHashMap<ShapeNode, Multiplicity> createNodeMultMap() {
        return new MyHashMap<ShapeNode, Multiplicity>();
    }

    <E extends HostElement> Set<E> createElementSet() {
        return new NotifySet();
    }

    private class NotifySet<EL extends HostElement>
    extends LinkedHashSet<EL> {
        @Override
        public Iterator<EL> iterator() {
            return new MyIterator();
        }

        Iterator<EL> superIterator() {
            return super.iterator();
        }

        @Override
        public final boolean add(EL elem) {
            if (super.add(elem)) {
                if (elem instanceof ShapeNode) {
                    ShapeCache.this.addUpdate((ShapeNode)elem);
                } else {
                    ShapeCache.this.addUpdate((ShapeEdge)elem);
                }
                return true;
            }
            return false;
        }

        @Override
        public final boolean remove(Object elem) {
            if (super.remove(elem)) {
                if (elem instanceof ShapeNode) {
                    ShapeCache.this.removeUpdate((ShapeNode)elem);
                } else {
                    ShapeCache.this.removeUpdate((ShapeEdge)elem);
                }
                return true;
            }
            return false;
        }

        class MyIterator
        implements Iterator<EL> {
            private final Iterator<EL> setIterator;
            EL latest;

            MyIterator() {
                this.setIterator = NotifySet.this.superIterator();
            }

            @Override
            public boolean hasNext() {
                return this.setIterator.hasNext();
            }

            @Override
            public EL next() {
                this.latest = (HostElement)this.setIterator.next();
                return this.latest;
            }

            @Override
            public void remove() {
                this.setIterator.remove();
                if (this.latest instanceof ShapeNode) {
                    ShapeCache.this.removeUpdate((ShapeNode)this.latest);
                } else {
                    ShapeCache.this.removeUpdate((ShapeEdge)this.latest);
                }
            }
        }
    }
}

