/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.trans;

import groove.abstraction.Multiplicity;
import groove.abstraction.MyHashMap;
import groove.abstraction.MyHashSet;
import groove.abstraction.neigh.EdgeMultDir;
import groove.abstraction.neigh.shape.EdgeSignature;
import groove.abstraction.neigh.shape.Shape;
import groove.abstraction.neigh.shape.ShapeEdge;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.abstraction.neigh.trans.Materialisation;
import groove.grammar.type.TypeLabel;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class EdgeBundle {
    final EdgeMultDir direction;
    final ShapeNode node;
    final TypeLabel label;
    final EdgeSignature origEs;
    final Multiplicity origEsMult;
    final Map<EdgeSignature, Set<ShapeEdge>> splitEsMap;
    final Set<ShapeEdge> allEdges;
    final Set<ShapeEdge> possibleEdges;
    private final int hashCode;

    EdgeBundle(EdgeSignature origEs, Multiplicity origEsMult, ShapeNode node) {
        this.direction = origEs.getDirection();
        this.node = node;
        this.label = origEs.getLabel();
        this.origEs = origEs;
        this.origEsMult = origEsMult;
        this.splitEsMap = new MyHashMap<EdgeSignature, Set<ShapeEdge>>();
        this.allEdges = new MyHashSet<ShapeEdge>();
        this.possibleEdges = new MyHashSet<ShapeEdge>();
        this.hashCode = this.computeHashCode();
    }

    EdgeBundle(EdgeBundle bundle) {
        this.direction = bundle.direction;
        this.node = bundle.node;
        this.label = bundle.label;
        this.origEs = bundle.origEs;
        this.origEsMult = bundle.origEsMult;
        this.splitEsMap = new MyHashMap<EdgeSignature, Set<ShapeEdge>>();
        for (EdgeSignature es : bundle.splitEsMap.keySet()) {
            MyHashSet edgeSet = new MyHashSet();
            edgeSet.addAll(bundle.splitEsMap.get(es));
            this.splitEsMap.put(es, edgeSet);
        }
        this.allEdges = new MyHashSet<ShapeEdge>();
        this.allEdges.addAll(bundle.allEdges);
        this.possibleEdges = new MyHashSet<ShapeEdge>();
        this.possibleEdges.addAll(bundle.possibleEdges);
        this.hashCode = bundle.hashCode;
    }

    public String toString() {
        return (Object)((Object)this.direction) + ":" + this.node + "-" + this.label + "-" + this.splitEsMap;
    }

    public EdgeBundle clone() {
        return new EdgeBundle(this);
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof EdgeBundle)) {
            result = false;
        } else {
            EdgeBundle bundle = (EdgeBundle)o;
            boolean bl = result = this.direction.equals((Object)bundle.direction) && this.node.equals(bundle.node) && this.label.equals(bundle.label) && this.origEs.equals(bundle);
        }
        assert (!result || this.hashCode() == o.hashCode());
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int result = 1;
        result = 31 * result + this.direction.hashCode();
        result = 31 * result + this.node.hashCode();
        result = 31 * result + this.label.hashCode();
        result = 31 * result + this.origEs.hashCode();
        return result;
    }

    boolean isEqual(ShapeNode node, EdgeSignature origEs) {
        return this.node.equals(node) && this.origEs.equals(origEs);
    }

    Set<EdgeSignature> getSplitEsSet() {
        return this.splitEsMap.keySet();
    }

    Set<ShapeEdge> getSplitEsEdges(EdgeSignature splitEs) {
        Set<ShapeEdge> result = this.splitEsMap.get(splitEs);
        assert (result != null);
        return result;
    }

    Set<ShapeEdge> getEdges() {
        return this.allEdges;
    }

    int getEdgesCount() {
        return this.allEdges.size();
    }

    EdgeSignature maybeGetEdgeSignature(ShapeEdge edge) {
        EdgeSignature result = null;
        for (EdgeSignature splitEs : this.getSplitEsSet()) {
            if (!splitEs.mayContain(edge)) continue;
            result = splitEs;
            break;
        }
        return result;
    }

    EdgeSignature getEdgeSignature(Shape shape, ShapeEdge edge, EdgeMultDir direction) {
        EdgeSignature result = this.maybeGetEdgeSignature(edge);
        if (result == null) {
            result = shape.getEdgeSignature(edge, direction);
            this.splitEsMap.put(result, new MyHashSet());
        }
        return result;
    }

    void addEdge(Shape shape, ShapeEdge edge) {
        assert (this.node.equals(this.direction.incident(edge)));
        assert (this.label.equals(edge.label()));
        if (this.allEdges.contains(edge)) {
            return;
        }
        EdgeSignature splitEs = this.getEdgeSignature(shape, edge, this.direction);
        this.getSplitEsEdges(splitEs).add(edge);
        this.allEdges.add(edge);
    }

    void setEdgeAsFixed(ShapeEdge edge) {
        this.possibleEdges.add(edge);
    }

    void removeEdge(ShapeEdge edge) {
        assert (this.allEdges.contains(edge));
        EdgeSignature splitEs = this.maybeGetEdgeSignature(edge);
        assert (splitEs != null);
        Set<ShapeEdge> splitEsEdges = this.getSplitEsEdges(splitEs);
        splitEsEdges.remove(edge);
        if (splitEsEdges.isEmpty()) {
            this.splitEsMap.remove(splitEs);
        }
        this.allEdges.remove(edge);
        this.possibleEdges.remove(edge);
    }

    boolean isNonSingular() {
        return this.splitEsMap.size() > 1;
    }

    boolean isFixed(ShapeEdge edge, EdgeMultDir direction, Shape shape) {
        boolean result = false;
        ShapeNode opposite = direction.opposite(edge);
        if (shape.getNodeMult(opposite).isOne() && this.possibleEdges.contains(edge)) {
            result = true;
        }
        return result;
    }

    void computeAdditionalEdges(Materialisation mat) {
        Shape shape = mat.getShape();
        for (ShapeEdge edge : shape.binaryEdgeSet(this.node, this.direction)) {
            if (this.allEdges.contains(edge) || !((TypeLabel)edge.label()).equals(this.label)) continue;
            EdgeSignature es = shape.getEdgeSignature(edge, this.direction);
            EdgeSignature otherOrigEs = mat.getShapeMorphism().getEdgeSignature(mat.getOriginalShape(), es);
            if (!otherOrigEs.equals(this.origEs)) continue;
            this.addEdge(shape, edge);
        }
    }

    void updateFromSolution(Shape shape, Set<ShapeEdge> zeroEdges, Set<ShapeEdge> positiveEdges) {
        for (ShapeEdge zeroEdge : zeroEdges) {
            if (!this.allEdges.contains(zeroEdge)) continue;
            this.removeEdge(zeroEdge);
        }
        for (ShapeEdge positiveEdge : positiveEdges) {
            if (!this.allEdges.contains(positiveEdge) || shape.containsEdge(positiveEdge)) continue;
            this.possibleEdges.add(positiveEdge);
        }
    }

    void update(Materialisation mat) {
        Shape shape = mat.getShape();
        Iterator<EdgeSignature> iter = this.splitEsMap.keySet().iterator();
        while (iter.hasNext()) {
            EdgeSignature splitEs = iter.next();
            if (shape.hasEdgeSignature(splitEs)) continue;
            this.allEdges.removeAll(this.getSplitEsEdges(splitEs));
            iter.remove();
        }
        this.computeAdditionalEdges(mat);
    }
}

