/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.trans;

import groove.abstraction.Multiplicity;
import groove.abstraction.MyHashSet;
import groove.abstraction.neigh.trans.BoundType;
import groove.abstraction.neigh.trans.Equation;
import groove.abstraction.neigh.trans.Solution;
import groove.abstraction.neigh.trans.Value;
import groove.abstraction.neigh.trans.Var;
import groove.util.Duo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class EquationSystem {
    public static boolean ENABLE_ZERO_ONE_BRANCHES = true;
    private final int stage;
    private final MyHashSet<Equation> trivialEqs;
    private final MyHashSet<Equation> lbEqs;
    private final MyHashSet<Equation> ubEqs;
    private final int bound;
    private int varsCount;
    private final List<Duo<Var>> allVars;

    public static final EquationSystem newInstance() {
        return new EquationSystem(1);
    }

    public EquationSystem(int stage) {
        this.stage = stage;
        this.bound = this.computeBound(stage);
        this.trivialEqs = new MyHashSet();
        this.lbEqs = new MyHashSet();
        this.ubEqs = new MyHashSet();
        this.allVars = new ArrayList<Duo<Var>>();
        this.varsCount = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Equation System - Stage " + this.stage + " - " + this.varsCount + " variables\n");
        sb.append("Trivial Equations:\n");
        for (Equation eq : this.trivialEqs) {
            sb.append(eq + "\n");
        }
        sb.append("Non-trivial Equations:\n");
        for (Equation eq : this.lbEqs) {
            sb.append(eq + "\n");
        }
        for (Equation eq : this.ubEqs) {
            sb.append(eq + "\n");
        }
        return sb.toString();
    }

    private int computeBound(int stage) {
        Multiplicity.MultKind kind = null;
        switch (stage) {
            case 1: {
                kind = Multiplicity.MultKind.EQSYS_MULT;
                break;
            }
            case 2: {
                kind = Multiplicity.MultKind.EDGE_MULT;
                break;
            }
            case 3: {
                kind = Multiplicity.MultKind.NODE_MULT;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return Multiplicity.getBound(kind) + 1;
    }

    public int getBound() {
        return this.bound;
    }

    public Duo<Var> createVars() {
        Var lbVar = new Var(this.varsCount, BoundType.LB);
        Var ubVar = new Var(this.varsCount, BoundType.UB);
        ++this.varsCount;
        Duo<Var> result = Duo.newDuo(lbVar, ubVar);
        this.allVars.add(result);
        return result;
    }

    public int getVarsCount() {
        return this.varsCount;
    }

    public void addEquations(Duo<Equation> eqs) {
        Equation lbEq = (Equation)eqs.one();
        Equation ubEq = (Equation)eqs.two();
        assert (lbEq.getVars().size() == ubEq.getVars().size());
        if (lbEq.isEmpty()) {
            return;
        }
        lbEq.setFixed();
        ubEq.setFixed();
        if (lbEq.isUseful()) {
            if (lbEq.isTrivial()) {
                this.trivialEqs.add(lbEq);
            } else {
                this.lbEqs.add(lbEq);
            }
        }
        if (ubEq.isUseful()) {
            if (ubEq.isTrivial()) {
                this.trivialEqs.add(ubEq);
            } else {
                this.ubEqs.add(ubEq);
            }
        }
    }

    public SolutionSet computeSolutions() {
        Solution initialSol = new Solution(this.allVars, this.bound, this.lbEqs, this.ubEqs);
        for (Equation eq : this.trivialEqs) {
            eq.computeNewValues(initialSol);
        }
        SolutionSet finishedSols = new SolutionSet();
        SolutionSet partialSols = new SolutionSet();
        partialSols.add(initialSol);
        while (!partialSols.isEmpty()) {
            Iterator iter = partialSols.iterator();
            Solution sol = (Solution)iter.next();
            iter.remove();
            this.iterateSolution(sol, partialSols, finishedSols);
        }
        return finishedSols;
    }

    private boolean canMaxSolution(Solution sol) {
        return this.stage == 1 && (sol.ubEqs.isEmpty() || sol.allEqsHaveNodes(sol.ubEqs)) && !sol.hasZeroOneVars();
    }

    private boolean canBranchOnZeroOneValues(Solution sol) {
        return ENABLE_ZERO_ONE_BRANCHES && this.stage == 1 && (sol.ubEqs.isEmpty() || sol.allEqsHaveNodes(sol.ubEqs)) && sol.hasZeroOneVars();
    }

    private void branchOnZeroOneValues(Solution sol, SolutionSet finishedSols) {
        assert (this.stage == 1);
        for (Solution newSol : new ZeroOneBranchList(sol)) {
            newSol.setAllVarsToMax();
            if (!this.isValid(newSol)) continue;
            finishedSols.add(newSol);
        }
    }

    private void iterateSolution(Solution sol, SolutionSet partialSols, SolutionSet finishedSols) {
        this.iterateEquations(sol);
        if (sol.isFinished()) {
            if (this.isValid(sol)) {
                finishedSols.add(sol);
            }
        } else if (this.canMaxSolution(sol)) {
            sol.setAllVarsToMax();
            if (this.isValid(sol)) {
                finishedSols.add(sol);
            }
        } else if (this.canBranchOnZeroOneValues(sol)) {
            this.branchOnZeroOneValues(sol, finishedSols);
        } else {
            Equation branchingEq = sol.getBestBranchingEquation();
            this.getNewSolutions(branchingEq, sol, partialSols, finishedSols);
        }
    }

    private void getNewSolutions(Equation eq, Solution sol, SolutionSet partialSols, SolutionSet finishedSols) {
        assert (!sol.isFinished());
        assert (sol.getEqs(eq.getType()).contains(eq));
        sol.getEqs(eq.getType()).remove(eq);
        if (eq.isValidSolution(sol)) {
            if (sol.isFinished()) {
                if (this.isValid(sol)) {
                    finishedSols.add(sol);
                }
            } else {
                partialSols.add(sol);
            }
        } else {
            for (Solution newSol : new EquationBranchList(eq, sol)) {
                if (newSol.isFinished()) {
                    if (!this.isValid(newSol)) continue;
                    finishedSols.add(newSol);
                    continue;
                }
                partialSols.add(newSol);
            }
        }
    }

    private void iterateEquations(Solution sol) {
        boolean solutionModified = true;
        while (solutionModified) {
            solutionModified = false;
            BoundType[] boundTypeArray = BoundType.values();
            int n = boundTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                BoundType type = boundTypeArray[n2];
                Iterator iter = sol.getEqs(type).iterator();
                while (iter.hasNext()) {
                    Equation eq = (Equation)iter.next();
                    boolean removeEq = eq.computeNewValues(sol);
                    if (removeEq) {
                        iter.remove();
                    }
                    boolean bl = solutionModified = solutionModified || removeEq;
                }
                ++n2;
            }
        }
    }

    private boolean isValid(Solution sol) {
        if (sol.invalid) {
            return false;
        }
        boolean result = true;
        MyHashSet allEqs = new MyHashSet();
        allEqs.addAll(this.trivialEqs);
        allEqs.addAll(this.lbEqs);
        allEqs.addAll(this.ubEqs);
        for (Equation eq : allEqs) {
            if (eq.isValidSolution(sol)) continue;
            result = false;
            break;
        }
        return result;
    }

    private static final class EquationBranchList
    extends GenericBranchList {
        EquationBranchList(Equation eq, Solution sol) {
            super(sol, eq.getOpenVars(sol));
            int sum = sol.getSum(eq.getVars(), false);
            assert (sum != Integer.MAX_VALUE);
            int diff = eq.getType() == BoundType.LB ? eq.getConstant() - sum : sum - eq.getConstant();
            boolean done = diff < 0;
            int length = this.iters.length;
            while (!done) {
                int pos = length - 1;
                while (!(pos < 0 || diff != 0 && this.iters[pos].hasNext())) {
                    diff += this.iters[pos].count();
                    this.iters[pos].reset();
                    --pos;
                }
                boolean bl = done = pos < 0;
                if (!done) {
                    this.iters[pos].doNext();
                    --diff;
                }
                if (diff != 0) continue;
                this.addNewSolution();
            }
        }
    }

    private static abstract class GenericBranchList
    extends ArrayList<Solution> {
        final Solution sol;
        final List<Var> vars;
        final ValueIterator[] iters;

        GenericBranchList(Solution sol, List<Var> vars) {
            assert (vars.size() > 0);
            this.sol = sol;
            this.vars = vars;
            this.iters = new ValueIterator[vars.size()];
            int i = 0;
            for (Var var : this.vars) {
                this.iters[i] = new ValueIterator(var.getType(), sol.getValue(var));
                ++i;
            }
        }

        @Override
        public String toString() {
            return Arrays.toString(this.iters);
        }

        void addNewSolution() {
            Solution newSol = this.sol.clone();
            int i = 0;
            while (i < this.iters.length) {
                newSol.cut(this.vars.get(i), this.iters[i].current());
                ++i;
            }
            this.add(newSol);
        }
    }

    private static final class SolutionSet
    extends MyHashSet<Solution> {
        private SolutionSet() {
        }

        @Override
        public boolean add(Solution newSol) {
            boolean storeNew = true;
            MyHashSet toRemove = null;
            for (Solution oldSol : this) {
                if (oldSol.subsumes(newSol)) {
                    storeNew = false;
                    break;
                }
                if (!newSol.subsumes(oldSol)) continue;
                if (toRemove == null) {
                    toRemove = new MyHashSet(this.size());
                }
                toRemove.add(oldSol);
            }
            if (toRemove != null) {
                this.removeAll(toRemove);
            }
            if (storeNew) {
                super.add(newSol);
            }
            return storeNew;
        }
    }

    private static final class ValueIterator {
        private final int maxCount;
        private final int start;
        private int count;

        ValueIterator(BoundType type, Value value) {
            assert (type == BoundType.LB || value.j != Integer.MAX_VALUE);
            this.maxCount = Math.min(value.j, value.bound) - value.i;
            this.start = value.i;
            this.reset();
        }

        public boolean hasNext() {
            return this.count < this.maxCount;
        }

        public void doNext() {
            assert (this.hasNext());
            ++this.count;
        }

        public int count() {
            return this.count;
        }

        public int current() {
            return this.start + this.count;
        }

        public void reset() {
            this.count = 0;
        }
    }

    private static final class ZeroOneBranchList
    extends GenericBranchList {
        ZeroOneBranchList(Solution sol) {
            super(sol, sol.getZeroOneVars());
            boolean done = false;
            int length = this.iters.length;
            while (!done) {
                this.addNewSolution();
                int pos = length - 1;
                while (pos >= 0 && !this.iters[pos].hasNext()) {
                    this.iters[pos].reset();
                    --pos;
                }
                boolean bl = done = pos < 0;
                if (done) continue;
                this.iters[pos].doNext();
            }
        }
    }
}

