/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.explore.util;

import groove.abstraction.pattern.explore.util.PatternRuleEventApplier;
import groove.abstraction.pattern.lts.MatchResult;
import groove.abstraction.pattern.lts.PSTS;
import groove.abstraction.pattern.lts.PatternGraphNextState;
import groove.abstraction.pattern.lts.PatternGraphState;
import groove.abstraction.pattern.lts.PatternGraphTransition;
import groove.abstraction.pattern.lts.PatternState;
import groove.abstraction.pattern.lts.PatternTransition;
import groove.abstraction.pattern.match.PreMatch;
import groove.abstraction.pattern.shape.PatternShape;
import groove.abstraction.pattern.trans.MaterialisingRuleApplication;
import java.util.Collection;

public class PatternShapeMatchApplier
implements PatternRuleEventApplier {
    private static final boolean DEBUG = false;
    private static final boolean USE_GUI = false;
    private final PSTS psts;

    public PatternShapeMatchApplier(PSTS pgts) {
        this.psts = pgts;
    }

    @Override
    public void apply(PatternState source, MatchResult match) {
        assert (match.getMatch() instanceof PreMatch);
        PreMatch preMatch = (PreMatch)match.getMatch();
        MaterialisingRuleApplication app = new MaterialisingRuleApplication((PatternShape)source.getGraph(), preMatch);
        Collection<PatternShape> transShapes = app.transform();
        assert (!transShapes.isEmpty());
        for (PatternShape transShape : transShapes) {
            PatternShape normShape = transShape.normalise();
            PatternGraphNextState newState = new PatternGraphNextState(normShape, (PatternGraphState)source, this.psts.getNextStateNr(), this.psts, match);
            PatternState oldState = this.psts.addState(newState);
            PatternTransition trans = null;
            if (oldState != null) {
                trans = new PatternGraphTransition(source, match, oldState);
                this.println("New transition: " + trans);
            } else {
                trans = newState;
                this.println("New state: " + source + "--" + match.getRule().getName() + "-->" + newState);
            }
            this.psts.addTransition(trans);
        }
    }

    private void println(String s) {
    }
}

