/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.lts;

import groove.abstraction.pattern.explore.util.PatternRuleEventApplier;
import groove.abstraction.pattern.explore.util.PatternShapeMatchApplier;
import groove.abstraction.pattern.explore.util.PatternShapeMatchSetCollector;
import groove.abstraction.pattern.lts.PGTS;
import groove.abstraction.pattern.lts.PatternState;
import groove.abstraction.pattern.shape.PatternGraph;
import groove.abstraction.pattern.shape.PatternShape;
import groove.abstraction.pattern.shape.iso.PatternShapeIsoChecker;
import groove.abstraction.pattern.trans.PatternGraphGrammar;

public final class PSTS
extends PGTS {
    private int subsumedStatesCount = 0;
    private int subsumedTransitionsCount = 0;

    public PSTS(PatternGraphGrammar grammar) {
        super(grammar);
    }

    @Override
    public PatternRuleEventApplier createMatchApplier() {
        return new PatternShapeMatchApplier(this);
    }

    @Override
    public PatternShapeMatchSetCollector createMatchCollector(PatternState state) {
        return new PatternShapeMatchSetCollector(state);
    }

    @Override
    protected PatternGraph createStartGraph(PatternGraph startGraph) {
        PatternShape result = new PatternShape(startGraph).normalise();
        return result;
    }

    @Override
    protected PGTS.StateSet createStateSet() {
        return new ShapeStateSet();
    }

    @Override
    public PatternState addState(PatternState newState) {
        assert (newState.hasPatternShape());
        PatternState result = super.addState(newState);
        if (result == null) {
            this.subsumedStatesCount += newState.markSubsumedStates();
        } else if (newState.isSubsumed()) {
            ++this.subsumedTransitionsCount;
        }
        return result;
    }

    public int getSubsumedStatesCount() {
        return this.subsumedStatesCount;
    }

    public int getSubsumedTransitionsCount() {
        return this.subsumedTransitionsCount;
    }

    private static final class ShapeStateSet
    extends PGTS.StateSet {
        ShapeStateSet() {
            super(PatternShapeIsoChecker.getInstance());
        }

        @Override
        protected boolean areEqual(PatternState myState, PatternState otherState) {
            assert (myState.hasPatternShape() && otherState.hasPatternShape());
            if (myState.getCtrlState() != otherState.getCtrlState()) {
                return false;
            }
            if (otherState.isSubsumed()) {
                return false;
            }
            PatternShapeIsoChecker checker = (PatternShapeIsoChecker)this.checker;
            int comparison = checker.compareShapes(myState.getShape(), otherState.getShape()).one();
            if (checker.isDomStrictlyLargerThanCod(comparison)) {
                myState.addSubsumedState(otherState);
            } else if (checker.isCodSubsumesDom(comparison)) {
                myState.setSubsumptor(otherState);
            }
            return checker.areEqual(comparison);
        }
    }
}

