/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.shape;

import groove.abstraction.Multiplicity;
import groove.abstraction.MyHashMap;
import groove.abstraction.pattern.match.Match;
import groove.abstraction.pattern.shape.PatternEdge;
import groove.abstraction.pattern.shape.PatternEquivRel;
import groove.abstraction.pattern.shape.PatternGraph;
import groove.abstraction.pattern.shape.PatternNode;
import groove.abstraction.pattern.shape.TypeEdge;
import groove.abstraction.pattern.shape.TypeGraph;
import groove.abstraction.pattern.shape.TypeNode;
import groove.util.Duo;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public final class PatternShape
extends PatternGraph {
    private final Map<PatternNode, Multiplicity> nodeMultMap = new MyHashMap<PatternNode, Multiplicity>();
    private final Map<PatternEdge, Multiplicity> edgeMultMap = new MyHashMap<PatternEdge, Multiplicity>();

    public PatternShape(String name, TypeGraph type) {
        super(name, type);
    }

    public PatternShape(PatternGraph pGraph) {
        this(pGraph.getName(), pGraph.getTypeGraph());
        for (PatternNode pNode : pGraph.nodeSet()) {
            this.addNode(pNode);
        }
        for (PatternEdge pEdge : pGraph.edgeSet()) {
            this.addEdge(pEdge);
        }
    }

    private PatternShape(PatternShape pShape) {
        this((PatternGraph)pShape);
        this.nodeMultMap.putAll(pShape.nodeMultMap);
        this.edgeMultMap.putAll(pShape.edgeMultMap);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Pattern shape: " + this.getName() + "\n");
        sb.append("Nodes: [");
        for (PatternNode node : this.nodeSet()) {
            sb.append(String.valueOf(node.toString()) + "(" + this.getMult(node) + "), ");
        }
        if (this.nodeSet().isEmpty()) {
            sb.append("]\n");
        } else {
            sb.replace(sb.length() - 2, sb.length(), "]\n");
        }
        sb.append("Edges: [");
        for (PatternEdge edge : this.edgeSet()) {
            sb.append(String.valueOf(edge.toString()) + "(" + this.getMult(edge) + "), ");
        }
        if (this.edgeSet().isEmpty()) {
            sb.append("]\n");
        } else {
            sb.replace(sb.length() - 2, sb.length(), "]\n");
        }
        return sb.toString();
    }

    @Override
    public boolean addNode(PatternNode node) {
        boolean result = super.addNode(node);
        if (result) {
            this.nodeMultMap.put(node, Multiplicity.ONE_NODE_MULT);
        }
        return result;
    }

    @Override
    public boolean addEdge(PatternEdge edge) {
        boolean result = super.addEdge(edge);
        if (result) {
            this.edgeMultMap.put(edge, Multiplicity.ONE_EDGE_MULT);
        }
        return result;
    }

    @Override
    public boolean removeNode(PatternNode node) {
        boolean result = super.removeNode(node);
        if (result) {
            this.nodeMultMap.remove(node);
        }
        return result;
    }

    @Override
    public boolean removeEdge(PatternEdge edge) {
        boolean result = super.removeEdge(edge);
        if (result) {
            this.edgeMultMap.remove(edge);
        }
        return result;
    }

    @Override
    protected void fireRemoveEdge(PatternEdge edge) {
        super.fireRemoveEdge(edge);
        this.edgeMultMap.remove(edge);
    }

    @Override
    public PatternShape clone() {
        return new PatternShape(this);
    }

    @Override
    public boolean isWellDefined() {
        if (!super.isWellDefined()) {
            return false;
        }
        for (PatternNode pNode : this.nodeSet()) {
            Multiplicity pMult = this.getMult(pNode);
            for (TypeEdge tEdge : this.getIncomingEdgeTypes(pNode)) {
                Multiplicity acc = Multiplicity.getMultiplicity(0, 0, Multiplicity.MultKind.EQSYS_MULT);
                for (PatternEdge dEdge : this.getInEdgesWithType(pNode, tEdge)) {
                    Multiplicity srcMult = this.getMult((PatternNode)dEdge.source());
                    Multiplicity dMult = this.getMult(dEdge);
                    acc = acc.add(srcMult.times(dMult));
                }
                if (pMult.subsumes(acc.toNodeKind())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Duo<PatternEdge> getIncomingEdges(PatternNode node) {
        assert (this.isUniquelyCovered(node));
        return super.getIncomingEdges(node);
    }

    @Override
    public void prepareClosure(Match match) {
        throw new UnsupportedOperationException("Cannot close a pattern shape directly.");
    }

    public Map<PatternNode, Multiplicity> getNodeMultMap() {
        return Collections.unmodifiableMap(this.nodeMultMap);
    }

    public Map<PatternEdge, Multiplicity> getEdgeMultMap() {
        return Collections.unmodifiableMap(this.edgeMultMap);
    }

    public Multiplicity getMult(PatternNode node) {
        Multiplicity result = this.nodeMultMap.get(node);
        return result == null ? Multiplicity.ZERO_NODE_MULT : result;
    }

    public Multiplicity getMult(PatternEdge edge) {
        Multiplicity result = this.edgeMultMap.get(edge);
        return result == null ? Multiplicity.ZERO_EDGE_MULT : result;
    }

    Multiplicity getNodeSetMultSum(Set<PatternNode> nodes) {
        Multiplicity accumulator = Multiplicity.ZERO_NODE_MULT;
        for (PatternNode node : nodes) {
            Multiplicity nodeMult = this.nodeMultMap.get(node);
            accumulator = accumulator.add(nodeMult);
        }
        return accumulator;
    }

    Multiplicity getEdgeSetMultSum(Set<PatternEdge> edges) {
        Multiplicity accumulator = Multiplicity.ZERO_EDGE_MULT;
        for (PatternEdge edge : edges) {
            Multiplicity edgeMult = this.edgeMultMap.get(edge);
            accumulator = accumulator.add(edgeMult);
        }
        return accumulator;
    }

    public void setMult(PatternNode node, Multiplicity mult) {
        assert (!this.isFixed());
        assert (mult.isNodeKind());
        assert (this.containsNode(node)) : "Node " + node + " is not in the shape!";
        if (!mult.isZero()) {
            this.nodeMultMap.put(node, mult);
        } else {
            this.removeNodeContext(node);
        }
    }

    public void setMult(PatternEdge edge, Multiplicity mult) {
        assert (!this.isFixed());
        assert (mult.isEdgeKind());
        assert (this.containsEdge(edge)) : "Edge " + edge + " is not in the shape!";
        if (!mult.isZero()) {
            this.edgeMultMap.put(edge, mult);
        } else {
            this.removeEdge(edge);
        }
    }

    public PatternShape normalise() {
        PatternEquivRel peq = new PatternEquivRel(this);
        PatternShape result = new PatternShape(this.getName(), this.getTypeGraph());
        MyHashMap<PatternEquivRel.NodeEquivClass, PatternNode> ecToNodeMap = new MyHashMap<PatternEquivRel.NodeEquivClass, PatternNode>();
        for (PatternEquivRel.NodeEquivClass nEc : peq.getNodeEquivRel()) {
            TypeNode nType = ((PatternNode)nEc.iterator().next()).getType();
            PatternNode newNode = result.createNode(nType);
            result.addNode(newNode);
            Multiplicity nMult = nEc.getMult();
            if (!nMult.isOne()) {
                result.setMult(newNode, nMult);
            }
            ecToNodeMap.put(nEc, newNode);
        }
        for (PatternEquivRel.EdgeEquivClass eEc : peq.getEdgeEquivRel()) {
            PatternNode source = (PatternNode)ecToNodeMap.get(eEc.sourceEc);
            PatternNode target = (PatternNode)ecToNodeMap.get(eEc.targetEc);
            assert (source != null && target != null);
            PatternEdge newEdge = this.getFactory().createEdge(source, eEc.typeEdge, target);
            result.addEdgeContext(newEdge);
            Multiplicity eMult = eEc.mult;
            if (eMult.isOne()) continue;
            result.setMult(newEdge, eMult);
        }
        assert (result.isWellDefined());
        return result;
    }

    public void propagateMults() {
        int layer = 1;
        while (layer <= this.depth()) {
            for (PatternNode pNode : this.getLayerNodes(layer)) {
                Multiplicity finalMult;
                Multiplicity[] acc = new Multiplicity[2];
                int i = 0;
                for (TypeEdge tEdge : this.getIncomingEdgeTypes(pNode)) {
                    acc[i] = Multiplicity.getMultiplicity(0, 0, Multiplicity.MultKind.EQSYS_MULT);
                    for (PatternEdge dEdge : this.getInEdgesWithType(pNode, tEdge)) {
                        Multiplicity srcMult = this.getMult((PatternNode)dEdge.source());
                        Multiplicity dMult = this.getMult(dEdge);
                        acc[i] = acc[i].add(srcMult.times(dMult));
                    }
                    ++i;
                }
                if (acc[0].subsumes(acc[1])) {
                    finalMult = acc[0].toNodeKind();
                } else {
                    assert (acc[1].subsumes(acc[0]));
                    finalMult = acc[1];
                }
                this.setMult(pNode, finalMult);
            }
            ++layer;
        }
    }
}

