/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.shape;

import groove.abstraction.MyHashMap;
import groove.abstraction.pattern.shape.TypeEdge;
import groove.abstraction.pattern.shape.TypeGraph;
import groove.abstraction.pattern.shape.TypeNode;
import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.aspect.AspectKind;
import groove.grammar.aspect.AspectNode;
import groove.grammar.host.HostNode;
import groove.util.Groove;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public final class TypeGraphFactory {
    private static final char NODE_ID_PREFIX = 't';
    private static final char EDGE_ID_PREFIX = 'm';
    private static final TypeGraphFactory instance = new TypeGraphFactory();
    private TypeGraph tGraph = null;
    private Map<Integer, TypeNode> tNodeMap = new MyHashMap<Integer, TypeNode>();
    private Map<Integer, TypeEdge> tEdgeMap = new MyHashMap<Integer, TypeEdge>();
    private Map<Integer, HostNode> sNodeMap = new MyHashMap<Integer, HostNode>();
    private Map<AspectNode, TypeNode> aNodeMap = new MyHashMap<AspectNode, TypeNode>();

    public static TypeGraphFactory getInstance() {
        return instance;
    }

    private static int parseId(String id) {
        return Integer.parseInt(id.substring(1));
    }

    private static int parseNodeId(String id) throws IOException {
        if (id.charAt(0) != 't') {
            throw new IOException(String.format("Cannot parse node ID: %s, invalid initial character.", id));
        }
        return TypeGraphFactory.parseId(id);
    }

    private static int parseEdgeId(String id) throws IOException {
        if (id.charAt(0) != 'm') {
            throw new IOException(String.format("Cannot parse edge ID: %s, invalid initial character.", id));
        }
        return TypeGraphFactory.parseId(id);
    }

    private TypeGraphFactory() {
    }

    public TypeGraph toTypeGraph(AspectGraph aGraph) throws IOException {
        this.clearMaps();
        this.createTypeGraph(aGraph.getName());
        this.createTypeNodes(aGraph);
        this.createTypeEdges(aGraph);
        this.createPatterns(aGraph);
        this.createMorphisms();
        this.tGraph.setFixed();
        return this.tGraph;
    }

    private void clearMaps() {
        this.tNodeMap.clear();
        this.tEdgeMap.clear();
        this.sNodeMap.clear();
        this.aNodeMap.clear();
    }

    private void createTypeGraph(String name) {
        this.tGraph = new TypeGraph(name);
    }

    private void createTypeNodes(AspectGraph aGraph) throws IOException {
        for (AspectEdge aEdge : aGraph.edgeSet()) {
            AspectNode aSrc = (AspectNode)aEdge.source();
            if (aEdge.getKind() != AspectKind.REMARK || !aSrc.equals(aEdge.target())) continue;
            TypeNode tNode = this.getTypeNode(aEdge.getInnerText());
            this.aNodeMap.put(aSrc, tNode);
            int sNodeNr = aSrc.getNumber();
            HostNode sNode = (HostNode)tNode.getPattern().addNode(sNodeNr);
            this.sNodeMap.put(sNodeNr, sNode);
        }
    }

    private void createTypeEdges(AspectGraph aGraph) throws IOException {
        for (AspectEdge aEdge : aGraph.edgeSet()) {
            AspectNode aSrc = (AspectNode)aEdge.source();
            if (aEdge.getKind() != AspectKind.REMARK || aSrc.equals(aEdge.target())) continue;
            AspectNode aTgt = (AspectNode)aEdge.target();
            TypeEdge tEdge = this.getTypeEdge(aEdge.getInnerText(), aSrc, aTgt);
            HostNode sSrc = this.sNodeMap.get(aSrc.getNumber());
            HostNode sTgt = this.sNodeMap.get(aTgt.getNumber());
            tEdge.getMorphism().putNode(sSrc, sTgt);
        }
    }

    private void createPatterns(AspectGraph aGraph) throws IOException {
        for (AspectEdge aEdge : aGraph.edgeSet()) {
            TypeNode tTgt;
            if (aEdge.getKind() == AspectKind.REMARK) continue;
            AspectNode aSrc = (AspectNode)aEdge.source();
            AspectNode aTgt = (AspectNode)aEdge.target();
            TypeNode tSrc = this.aNodeMap.get(aSrc);
            if (tSrc != (tTgt = this.aNodeMap.get(aTgt))) {
                throw new IOException(String.format("Inconsistent pattern, source (%s) and target (%s) nodes are in distinct type nodes: %s, %s.", aSrc, aTgt, tSrc, tTgt));
            }
            HostNode sSrc = this.sNodeMap.get(aSrc.getNumber());
            HostNode sTgt = this.sNodeMap.get(aTgt.getNumber());
            tSrc.getPattern().addEdge(sSrc, aEdge.getInnerText(), sTgt);
        }
    }

    private void createMorphisms() {
        for (TypeEdge tEdge : this.tGraph.edgeSet()) {
            tEdge.extendMorphism();
        }
    }

    private TypeNode getTypeNode(String IdStr) throws IOException {
        int id = TypeGraphFactory.parseNodeId(IdStr);
        TypeNode result = this.tNodeMap.get(id);
        if (result == null) {
            result = this.tGraph.addNode(id);
            this.tNodeMap.put(id, result);
        }
        return result;
    }

    private TypeEdge getTypeEdge(String IdStr, AspectNode aSrc, AspectNode aTgt) throws IOException {
        int id = TypeGraphFactory.parseEdgeId(IdStr);
        TypeEdge result = this.tEdgeMap.get(id);
        if (result == null) {
            TypeNode tSrc = this.aNodeMap.get(aSrc);
            TypeNode tTgt = this.aNodeMap.get(aTgt);
            result = this.tGraph.addEdge(id, tSrc, tTgt);
            this.tEdgeMap.put(id, result);
        }
        return result;
    }

    public static TypeGraph unmarshalTypeGraph(File file) throws IOException {
        return TypeGraphFactory.getInstance().toTypeGraph(AspectGraph.newInstance(Groove.loadGraph(file)));
    }
}

