/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.trans;

import groove.abstraction.Multiplicity;
import groove.abstraction.MyHashMap;
import groove.abstraction.MyHashSet;
import groove.abstraction.pattern.match.Match;
import groove.abstraction.pattern.shape.PatternEdge;
import groove.abstraction.pattern.shape.PatternGraph;
import groove.abstraction.pattern.shape.PatternNode;
import groove.abstraction.pattern.shape.PatternShape;
import groove.abstraction.pattern.shape.TypeEdge;
import groove.abstraction.pattern.shape.TypeNode;
import groove.abstraction.pattern.trans.PatternRule;
import groove.abstraction.pattern.trans.RuleEdge;
import groove.abstraction.pattern.trans.RuleNode;
import groove.graph.Node;
import groove.util.Duo;
import groove.util.Pair;
import groove.util.collect.NestedIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class QuasiShape
extends PatternGraph {
    private final Map<PatternNode, Set<Constraint>> nodeConstrMap = new MyHashMap<PatternNode, Set<Constraint>>();
    private final Map<PatternNode, Set<Constraint>> edgeConstrMap = new MyHashMap<PatternNode, Set<Constraint>>();
    final Map<PatternNode, MultVar> nodeVarMap = new MyHashMap<PatternNode, MultVar>();
    final Map<PatternEdge, MultVar> edgeVarMap = new MyHashMap<PatternEdge, MultVar>();

    public static QuasiShape devolve(PatternShape pShape) {
        return new QuasiShape(pShape);
    }

    private QuasiShape(PatternGraph pGraph) {
        super(pGraph);
    }

    private QuasiShape(PatternShape pShape) {
        this((PatternGraph)pShape);
        for (PatternNode pNode : pShape.getLayerNodes(0)) {
            Multiplicity pMult = pShape.getMult(pNode);
            this.addNodeConstraint(pNode, pMult);
        }
        for (PatternEdge dEdge : pShape.edgeSet()) {
            Multiplicity dMult = pShape.getMult(dEdge);
            this.addEdgeConstraint(dEdge, dMult);
        }
    }

    private QuasiShape(QuasiShape qShape) {
        this((PatternGraph)qShape);
        for (Constraint constr : qShape.getConstraints()) {
            this.copyConstraint(constr);
        }
    }

    @Override
    public QuasiShape clone() {
        return new QuasiShape(this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("Node constraints: [\n");
        for (Constraint constr : this.getNodeConstraints()) {
            sb.append(String.valueOf(constr.toString()) + "\n");
        }
        sb.replace(sb.length() - 1, sb.length(), "]\n");
        sb.append("Edge constraints: [\n");
        for (Constraint constr : this.getEdgeConstraints()) {
            sb.append(String.valueOf(constr.toString()) + "\n");
        }
        sb.replace(sb.length() - 1, sb.length(), "]\n");
        return sb.toString();
    }

    @Override
    public boolean deletePattern(PatternNode node) {
        boolean modified = super.deletePattern(node);
        if (modified && node.isNodePattern()) {
            this.nodeConstrMap.remove(node);
            this.nodeVarMap.remove(node);
        }
        return modified;
    }

    @Override
    public PatternNode addNodePattern(TypeNode tNode) {
        PatternNode pNode = super.addNodePattern(tNode);
        this.addNodeConstraint(pNode, Multiplicity.ONE_NODE_MULT);
        return pNode;
    }

    @Override
    public Pair<PatternNode, Duo<PatternEdge>> addEdgePattern(TypeEdge m1, TypeEdge m2, PatternNode p1, PatternNode p2) {
        Pair<PatternNode, Duo<PatternEdge>> pair = super.addEdgePattern(m1, m2, p1, p2);
        PatternEdge d1 = (PatternEdge)pair.two().one();
        PatternEdge d2 = (PatternEdge)pair.two().two();
        this.addEdgeConstraint(d1, Multiplicity.ONE_EDGE_MULT);
        this.addEdgeConstraint(d2, Multiplicity.ONE_EDGE_MULT);
        return pair;
    }

    @Override
    public void prepareClosure(Match match) {
        PatternRule pRule = match.getRule();
        RuleNode rNode = pRule.getCreatorNodes()[0];
        Duo inEdges = pRule.rhs().getIncomingEdges(rNode);
        RuleEdge r1 = (RuleEdge)inEdges.one();
        RuleEdge r2 = (RuleEdge)inEdges.two();
        PatternNode p1 = (PatternNode)match.getNode((Node)r1.source());
        PatternNode p2 = (PatternNode)match.getNode((Node)r2.source());
        this.disambiguate(p1);
        this.disambiguate(p2);
    }

    @Override
    public Pair<PatternNode, Duo<PatternEdge>> closePattern(TypeEdge m1, TypeEdge m2, PatternNode p1, PatternNode p2) {
        Pair<PatternNode, Duo<PatternEdge>> pair = super.closePattern(m1, m2, p1, p2);
        PatternEdge d1 = (PatternEdge)pair.two().one();
        PatternEdge d2 = (PatternEdge)pair.two().two();
        this.addEdgeConstraint(d1, Multiplicity.ZERO_PLUS_EDGE_MULT);
        this.addEdgeConstraint(d2, Multiplicity.ZERO_PLUS_EDGE_MULT);
        return pair;
    }

    public void disambiguate(PatternNode p) {
        Duo<TypeEdge> duo = this.getDuoIncomingEdgeTypes(p);
        TypeEdge m1 = (TypeEdge)duo.one();
        TypeEdge m2 = (TypeEdge)duo.two();
        Collection<PatternNode> newNodes = this.disambiguate(p, m1);
        for (PatternNode newNode : newNodes) {
            this.disambiguate(newNode, m2);
        }
    }

    private Collection<PatternNode> disambiguate(PatternNode p, TypeEdge m) {
        if (this.getInEdgesWithType(p, m).size() == 1) {
            return Collections.singleton(p);
        }
        MyHashMap<PatternEdge, Object> origEdgeMap = new MyHashMap<PatternEdge, Object>();
        for (PatternEdge inEdge : this.getInEdgesWithType(p, m)) {
            PatternNode newNode = this.createNode(p.getType());
            this.addNode(newNode);
            origEdgeMap.put(inEdge, newNode);
        }
        ArrayList<PatternEdge> newEdges = new ArrayList<PatternEdge>(origEdgeMap.values().size());
        for (PatternEdge d : this.inEdgeSet(p)) {
            PatternNode src = (PatternNode)d.source();
            TypeEdge type = d.getType();
            Collection<Object> tgts = origEdgeMap.keySet().contains(d) ? Collections.singleton((PatternNode)origEdgeMap.get(d)) : origEdgeMap.values();
            newEdges.clear();
            for (PatternNode tgt : tgts) {
                PatternEdge newEdge = this.createEdge(src, type, tgt);
                this.addEdgeContext(newEdge);
                newEdges.add(newEdge);
            }
            for (Constraint constr : this.edgeConstrMap.get(src)) {
                if (!constr.contains(d)) continue;
                constr.replaceVar(d, newEdges);
            }
        }
        Set<Constraint> origOutConstrs = this.edgeConstrMap.get(p);
        if (origOutConstrs == null) {
            origOutConstrs = Collections.emptySet();
        }
        MyHashMap<PatternEdge, PatternEdge> replacingMap = new MyHashMap<PatternEdge, PatternEdge>();
        for (PatternNode newSrc : origEdgeMap.values()) {
            PatternEdge newEdge;
            replacingMap.clear();
            for (PatternEdge d : this.outEdgeSet(p)) {
                TypeEdge type = d.getType();
                PatternNode tgt = (PatternNode)d.target();
                newEdge = this.createEdge(newSrc, type, tgt);
                this.addEdgeContext(newEdge);
                replacingMap.put(d, newEdge);
            }
            for (Constraint origOutConstr : origOutConstrs) {
                Iterator<MultVar> varsIter = origOutConstr.vars.iterator();
                PatternEdge origEdge = varsIter.next().edge;
                newEdge = (PatternEdge)replacingMap.get(origEdge);
                Constraint newOutConstr = this.addEdgeConstraint(newEdge, origOutConstr.mult);
                while (varsIter.hasNext()) {
                    origEdge = varsIter.next().edge;
                    newEdge = (PatternEdge)replacingMap.get(origEdge);
                    newOutConstr.addVar(newEdge);
                }
            }
        }
        this.removeNodeContext(p);
        this.edgeConstrMap.remove(p);
        return origEdgeMap.values();
    }

    private Iterable<Constraint> getConstraints() {
        ArrayList<Iterator<Constraint>> iters = new ArrayList<Iterator<Constraint>>();
        for (Set<Constraint> set : this.nodeConstrMap.values()) {
            iters.add(set.iterator());
        }
        for (Set<Constraint> set : this.edgeConstrMap.values()) {
            iters.add(set.iterator());
        }
        return new ConstraintIterable(iters);
    }

    private Iterable<Constraint> getNodeConstraints() {
        ArrayList<Iterator<Constraint>> iters = new ArrayList<Iterator<Constraint>>();
        for (Set<Constraint> set : this.nodeConstrMap.values()) {
            iters.add(set.iterator());
        }
        return new ConstraintIterable(iters);
    }

    private Iterable<Constraint> getEdgeConstraints() {
        ArrayList<Iterator<Constraint>> iters = new ArrayList<Iterator<Constraint>>();
        for (Set<Constraint> set : this.edgeConstrMap.values()) {
            iters.add(set.iterator());
        }
        return new ConstraintIterable(iters);
    }

    private void addNodeConstraint(PatternNode pNode, Multiplicity pMult) {
        Constraint constr = new Constraint(pNode, pMult);
        this.addToNodeConstraintMap(pNode, constr);
    }

    private Constraint addEdgeConstraint(PatternEdge dEdge, Multiplicity dMult) {
        Constraint constr = new Constraint(dEdge, dMult);
        this.addToEdgeConstraintMap((PatternNode)dEdge.source(), constr);
        return constr;
    }

    private void copyConstraint(Constraint constr) {
        Constraint newConstr = new Constraint(constr);
        if (newConstr.isNodeConstr()) {
            this.addToNodeConstraintMap(newConstr.getNode(), newConstr);
        } else {
            this.addToEdgeConstraintMap(newConstr.srcNode, constr);
        }
    }

    private void addToNodeConstraintMap(PatternNode pNode, Constraint constr) {
        Set<Constraint> constrs = this.nodeConstrMap.get(pNode);
        if (constrs == null) {
            constrs = new MyHashSet<Constraint>();
            this.nodeConstrMap.put(pNode, constrs);
        }
        constrs.add(constr);
    }

    private void addToEdgeConstraintMap(PatternNode srcNode, Constraint constr) {
        Set<Constraint> constrs = this.edgeConstrMap.get(srcNode);
        if (constrs == null) {
            constrs = new MyHashSet<Constraint>();
            this.edgeConstrMap.put(srcNode, constrs);
        }
        constrs.add(constr);
    }

    public void getMaterialisations(Collection<PatternShape> result) {
        for (Solution sol : this.computeSolutions()) {
            PatternShape mat = sol.createShape();
            result.add(mat);
        }
    }

    private Set<Solution> computeSolutions() {
        MyHashSet<Solution> result = new MyHashSet<Solution>();
        for (Constraint constr : this.getConstraints()) {
            constr.solve(result);
        }
        return result;
    }

    private final class Constraint {
        final PatternNode srcNode;
        final Set<MultVar> vars;
        final Multiplicity mult;

        Constraint(Multiplicity mult, PatternNode srcNode) {
            assert (srcNode == null && mult.isNodeKind() || srcNode != null && mult.isEdgeKind());
            this.srcNode = srcNode;
            this.vars = new MyHashSet<MultVar>();
            this.mult = mult;
        }

        Constraint(Constraint constr) {
            this.srcNode = constr.srcNode;
            this.mult = constr.mult;
            this.vars = new MyHashSet<MultVar>();
            this.vars.addAll(constr.vars);
        }

        Constraint(PatternNode pNode, Multiplicity mult) {
            this(mult, null);
            this.addVar(pNode);
        }

        Constraint(PatternEdge pEdge, Multiplicity mult) {
            this(mult, (PatternNode)pEdge.source());
            this.addVar(pEdge);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (MultVar var : this.vars) {
                sb.append(String.valueOf(var.toString()) + " + ");
            }
            int l = sb.length();
            sb.replace(l - 2, l - 1, "=");
            sb.append(this.mult.toString());
            return sb.toString();
        }

        boolean isNodeConstr() {
            return this.srcNode == null;
        }

        boolean isTrivial() {
            return this.vars.size() == 1;
        }

        PatternNode getNode() {
            return this.vars.iterator().next().node;
        }

        void addVar(PatternNode pNode) {
            assert (this.isNodeConstr());
            MultVar var = new MultVar(pNode);
            QuasiShape.this.nodeVarMap.put(pNode, var);
            this.vars.add(var);
        }

        void addVar(PatternEdge pEdge) {
            assert (((PatternNode)pEdge.source()).equals(this.srcNode));
            MultVar var = new MultVar(pEdge);
            QuasiShape.this.edgeVarMap.put(pEdge, var);
            this.vars.add(var);
        }

        void removeVar(PatternEdge pEdge) {
            assert (((PatternNode)pEdge.source()).equals(this.srcNode));
            assert (this.contains(pEdge));
            MultVar var = QuasiShape.this.edgeVarMap.get(pEdge);
            this.vars.remove(var);
        }

        void replaceVar(PatternEdge origEdge, Collection<PatternEdge> newEdges) {
            for (PatternEdge newEdge : newEdges) {
                this.addVar(newEdge);
            }
            this.removeVar(origEdge);
        }

        boolean contains(PatternEdge pEdge) {
            MultVar var = QuasiShape.this.edgeVarMap.get(pEdge);
            return this.vars.contains(var);
        }

        void solve(Set<Solution> partialSols) {
            Solution currSol = null;
            if (partialSols.isEmpty()) {
                currSol = new Solution();
                partialSols.add(currSol);
            } else if (partialSols.size() == 1) {
                currSol = partialSols.iterator().next();
            } else assert (false) : "Implement proper solving!";
            if (this.isTrivial()) {
                MultVar singleVar = this.vars.iterator().next();
                currSol.setValue(singleVar, this.mult);
            } else assert (false) : "Implement proper solving!";
        }
    }

    private static final class ConstraintIterable
    implements Iterable<Constraint> {
        Collection<Iterator<Constraint>> iters;

        ConstraintIterable(Collection<Iterator<Constraint>> iters) {
            this.iters = iters;
        }

        @Override
        public Iterator<Constraint> iterator() {
            return new NestedIterator<Constraint>(this.iters);
        }
    }

    private static final class MultVar {
        final PatternNode node;
        final PatternEdge edge;

        MultVar(PatternNode node) {
            assert (node.isNodePattern());
            this.node = node;
            this.edge = null;
        }

        MultVar(PatternEdge edge) {
            this.node = null;
            this.edge = edge;
        }

        public String toString() {
            String suffix = this.isNodeVar() ? this.node.getIdStr() : this.edge.getIdStr();
            return "x." + suffix;
        }

        boolean isNodeVar() {
            return this.node != null;
        }
    }

    private final class Solution {
        final Map<MultVar, Multiplicity> varToValues = new MyHashMap<MultVar, Multiplicity>();

        Solution() {
        }

        Solution(Solution sol) {
            this();
            this.varToValues.putAll(sol.varToValues);
        }

        public Solution clone() {
            return new Solution(this);
        }

        public String toString() {
            return this.varToValues.toString();
        }

        void setValue(MultVar var, Multiplicity value) {
            assert (!this.isSet(var)) : "Over-writting variable is solution!";
            this.varToValues.put(var, value);
        }

        boolean isSet(MultVar var) {
            return this.varToValues.get(var) != null;
        }

        MultVar getVar(PatternNode pNode) {
            return QuasiShape.this.nodeVarMap.get(pNode);
        }

        MultVar getVar(PatternEdge pEdge) {
            return QuasiShape.this.edgeVarMap.get(pEdge);
        }

        PatternShape createShape() {
            QuasiShape qShape = QuasiShape.this;
            PatternShape result = new PatternShape(qShape);
            for (PatternNode pNode : qShape.getLayerNodes(0)) {
                MultVar nodeVar = this.getVar(pNode);
                Multiplicity nodeMult = this.varToValues.get(nodeVar);
                assert (nodeMult != null) : String.format("Node %s has no image.", pNode);
                result.setMult(pNode, nodeMult);
            }
            for (PatternEdge pEdge : qShape.edgeSet()) {
                MultVar edgeVar = this.getVar(pEdge);
                Multiplicity edgeMult = this.varToValues.get(edgeVar);
                assert (edgeMult != null) : String.format("Edge %s has no image.", pEdge);
                result.setMult(pEdge, edgeMult);
            }
            result.propagateMults();
            assert (result.isWellDefined());
            return result;
        }
    }
}

