/*
 * Decompiled with CFR 0.152.
 */
package groove.algebra;

import groove.algebra.Algebra;
import groove.algebra.AlgebraFamily;
import groove.algebra.BoolSignature;
import groove.algebra.Constant;
import groove.algebra.IntSignature;
import groove.algebra.Operator;
import groove.algebra.RealSignature;
import groove.algebra.Signature;
import groove.algebra.SignatureKind;
import groove.algebra.StringSignature;
import groove.annotation.Help;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.TypeVariable;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class Algebras {
    private static final Map<SignatureKind, Class<? extends Signature>> signatureMap = new EnumMap<SignatureKind, Class<? extends Signature>>(SignatureKind.class);
    private static final Map<SignatureKind, SortedMap<String, Operator>> operatorsMap;
    private static Map<String, String> docMap;
    private static final Map<String, String> tokenMap;
    private static final String SIGNATURE_SUFFIX = "Signature";
    private static final String IS_VALUE_NAME = "isValue";

    static {
        Algebras.addSignature(BoolSignature.class);
        Algebras.addSignature(IntSignature.class);
        Algebras.addSignature(RealSignature.class);
        Algebras.addSignature(StringSignature.class);
        Algebras.checkSignatureConsistency();
        operatorsMap = Algebras.createOperatorsMap();
        tokenMap = new HashMap<String, String>();
        tokenMap.put("LPAR", "(");
        tokenMap.put("RPAR", ")");
        tokenMap.put("COMMA", ",");
        tokenMap.put("COLON", ":");
        tokenMap.put("TRUE", "true");
        tokenMap.put("FALSE", "false");
    }

    public static Operator getOperator(SignatureKind sigKind, String operName) {
        Operator result = null;
        Map operators = operatorsMap.get((Object)sigKind);
        if (operators != null) {
            result = (Operator)operators.get(operName);
        }
        return result;
    }

    public static Set<String> getOperatorNames(SignatureKind sigKind) {
        return operatorsMap.get((Object)sigKind).keySet();
    }

    public static SignatureKind getSignatureFor(String symbol) {
        for (Map.Entry<SignatureKind, Class<? extends Signature>> sigEntry : signatureMap.entrySet()) {
            if (!Algebras.isConstant(sigEntry.getValue(), symbol)) continue;
            return sigEntry.getKey();
        }
        return null;
    }

    public static Constant getConstant(String symbol) {
        Constant result = null;
        for (Map.Entry<SignatureKind, Class<? extends Signature>> sigEntry : signatureMap.entrySet()) {
            if (!Algebras.isConstant(sigEntry.getValue(), symbol)) continue;
            result = new Constant(sigEntry.getKey(), symbol);
            break;
        }
        return result;
    }

    public static boolean isConstant(SignatureKind sigKind, String symbol) {
        boolean result = false;
        Class<? extends Signature> signature = signatureMap.get((Object)sigKind);
        if (signature != null) {
            result = Algebras.isConstant(signature, symbol);
        }
        return result;
    }

    public static Constant getConstant(SignatureKind sigKind, String symbol) {
        if (Algebras.isConstant(sigKind, symbol)) {
            return new Constant(sigKind, symbol);
        }
        return null;
    }

    private static boolean isConstant(Class<? extends Signature> signature, String value) {
        Method isValueMethod = Algebras.getIsValueMethod(signature);
        SignatureKind sigKind = Algebras.getSigKind(signature);
        try {
            return (Boolean)isValueMethod.invoke(AlgebraFamily.getInstance().getAlgebra(sigKind), value);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException();
        }
    }

    private static void addSignature(Class<? extends Signature> signature) throws IllegalArgumentException {
        SignatureKind sigKind = Algebras.getSigKind(signature);
        int sigModifiers = signature.getModifiers();
        if (Modifier.isInterface(sigModifiers) || !Modifier.isAbstract(sigModifiers)) {
            throw new IllegalArgumentException(String.format("Signature '%s' should be an abstract class", signature));
        }
        Method isValueMethod = Algebras.getIsValueMethod(signature);
        if (isValueMethod == null) {
            throw new IllegalArgumentException(String.format("Signature '%s' should implement '%s'", signature, IS_VALUE_NAME));
        }
        int methodModifiers = isValueMethod.getModifiers();
        if (Modifier.isAbstract(methodModifiers) || !Modifier.isFinal(methodModifiers)) {
            throw new IllegalArgumentException(String.format("Method '%s' in signature '%s' should be final", isValueMethod.getName(), signature));
        }
        if (signatureMap.put(sigKind, signature) != null) {
            throw new IllegalArgumentException(String.format("Signature named %s already registered", new Object[]{sigKind}));
        }
    }

    private static Method getIsValueMethod(Class<? extends Signature> signature) {
        Method[] methodArray = signature.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] parTypes;
            Method method = methodArray[n2];
            if (method.getName().equals(IS_VALUE_NAME) && (parTypes = method.getParameterTypes()).length == 1 && parTypes[0].equals(String.class)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    static String getSigName(Class<? extends Signature> signature) throws IllegalArgumentException {
        String interfaceName = signature.getName();
        if (interfaceName.indexOf(46) >= 0) {
            interfaceName = interfaceName.substring(interfaceName.lastIndexOf(46) + 1);
        }
        if (!interfaceName.endsWith(SIGNATURE_SUFFIX)) {
            throw new IllegalArgumentException(String.format("Signature name '%s' should by convention end on \"%s\"", interfaceName, SIGNATURE_SUFFIX));
        }
        String result = interfaceName.substring(0, interfaceName.length() - SIGNATURE_SUFFIX.length());
        return result.toLowerCase();
    }

    static SignatureKind getSigKind(Class<? extends Signature> signature) throws IllegalArgumentException {
        return SignatureKind.getKind(Algebras.getSigName(signature));
    }

    static Class<Signature> getSignature(Algebra<?> algebra) {
        Class<?> algebraClass = algebra.getClass();
        if (algebraClass.isInterface()) {
            throw new IllegalArgumentException(String.format("Algebra %s should be a concrete class", algebra.getName()));
        }
        Class<Signature> signature = algebraClass.getSuperclass();
        while (Signature.class.isAssignableFrom(signature.getSuperclass())) {
            signature = signature.getSuperclass();
        }
        int algebraModifiers = algebraClass.getModifiers();
        if (Modifier.isInterface(algebraModifiers) || Modifier.isAbstract(algebraModifiers)) {
            throw new IllegalArgumentException(String.format("Signature '%s' is not an abstract class", signature.getClass()));
        }
        return signature;
    }

    private static void checkSignatureConsistency() {
        for (Class<? extends Signature> signature : signatureMap.values()) {
            TypeVariable<Class<? extends Signature>>[] typeVariableArray = signature.getTypeParameters();
            int n = typeVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                TypeVariable<Class<? extends Signature>> type = typeVariableArray[n2];
                String typeName = type.getName().toLowerCase();
                if (SignatureKind.getKind(typeName) == null) {
                    throw new IllegalArgumentException(String.format("Type '%s' not declared by any signature", typeName));
                }
                ++n2;
            }
        }
    }

    private static EnumMap<SignatureKind, SortedMap<String, Operator>> createOperatorsMap() {
        EnumMap<SignatureKind, SortedMap<String, Operator>> result = new EnumMap<SignatureKind, SortedMap<String, Operator>>(SignatureKind.class);
        for (Map.Entry<SignatureKind, Class<? extends Signature>> sigEntry : signatureMap.entrySet()) {
            Method[] methods;
            TreeMap<String, Operator> operators = new TreeMap<String, Operator>();
            Method[] methodArray = methods = sigEntry.getValue().getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Operator oldOperator;
                Method method = methodArray[n2];
                if (Modifier.isAbstract(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) && (oldOperator = operators.put(method.getName(), new Operator(method))) != null) {
                    throw new IllegalArgumentException(String.format("Operator overloading for '%s' (signature '%s') not allowed", new Object[]{method.getName(), sigEntry.getKey()}));
                }
                ++n2;
            }
            result.put(sigEntry.getKey(), operators);
        }
        return result;
    }

    public static Map<String, String> getDocMap() {
        if (docMap == null) {
            docMap = Algebras.computeDocMap();
        }
        return docMap;
    }

    private static Map<String, String> computeDocMap() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<SignatureKind, Class<? extends Signature>> sigEntry : signatureMap.entrySet()) {
            HashMap<String, String> sigMap = new HashMap<String, String>(tokenMap);
            sigMap.put(sigEntry.getValue().getSimpleName(), Help.bf((Object)sigEntry.getKey()));
            Method[] methodArray = sigEntry.getValue().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                sigMap.put("Q" + method.getName(), (Object)((Object)sigEntry.getKey()) + ":" + method.getName());
                Help help = Help.createHelp(method, sigMap);
                if (help != null) {
                    result.put(help.getItem(), help.getTip());
                }
                ++n2;
            }
        }
        return result;
    }
}

