/*
 * Decompiled with CFR 0.152.
 */
package groove.algebra;

import groove.algebra.AlgebraFamily;
import groove.algebra.RealAlgebra;
import java.math.BigDecimal;

public class JavaDoubleAlgebra
extends RealAlgebra<Double, Boolean, String> {
    public static final double TOLERANCE = 1.0E-7;
    public static final String NAME = "jdouble";
    public static final JavaDoubleAlgebra instance = new JavaDoubleAlgebra();

    private JavaDoubleAlgebra() {
    }

    @Override
    public Double abs(Double arg) {
        return Math.abs(arg);
    }

    @Override
    public Double add(Double arg0, Double arg1) {
        return arg0 + arg1;
    }

    @Override
    public Double div(Double arg0, Double arg1) {
        return arg0 / arg1;
    }

    @Override
    public Boolean eq(Double arg0, Double arg1) {
        return JavaDoubleAlgebra.approximatelyEquals(arg0, arg1);
    }

    @Override
    public Boolean neq(Double arg0, Double arg1) {
        return !JavaDoubleAlgebra.approximatelyEquals(arg0, arg1);
    }

    @Override
    public Boolean ge(Double arg0, Double arg1) {
        if (!(arg0 >= arg1) && !JavaDoubleAlgebra.approximatelyEquals(arg0, arg1)) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean gt(Double arg0, Double arg1) {
        if (arg0 > arg1 && !JavaDoubleAlgebra.approximatelyEquals(arg0, arg1)) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean le(Double arg0, Double arg1) {
        if (!(arg0 <= arg1) && !JavaDoubleAlgebra.approximatelyEquals(arg0, arg1)) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean lt(Double arg0, Double arg1) {
        if (arg0 < arg1 && !JavaDoubleAlgebra.approximatelyEquals(arg0, arg1)) {
            return true;
        }
        return false;
    }

    @Override
    public Double max(Double arg0, Double arg1) {
        return Math.max(arg0, arg1);
    }

    @Override
    public Double min(Double arg0, Double arg1) {
        return Math.min(arg0, arg1);
    }

    @Override
    public Double mul(Double arg0, Double arg1) {
        return arg0 * arg1;
    }

    @Override
    public Double neg(Double arg) {
        return -arg.doubleValue();
    }

    @Override
    public Double sub(Double arg0, Double arg1) {
        return arg0 - arg1;
    }

    @Override
    public String toString(Double arg) {
        return arg.toString();
    }

    @Override
    public Double getValueFromSymbol(String symbol) {
        return new BigDecimal(symbol).doubleValue();
    }

    @Override
    protected Double toValue(Double constant) {
        return constant;
    }

    @Override
    public String getSymbol(Object value) {
        return value.toString();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public AlgebraFamily getFamily() {
        return AlgebraFamily.DEFAULT;
    }

    public static boolean approximatelyEquals(double d1, double d2) {
        return Math.abs(d1 - d2) <= (Math.abs(d1) + Math.abs(d2) + 1.0E-7) * 1.0E-7;
    }
}

