/*
 * Decompiled with CFR 0.152.
 */
package groove.algebra;

import groove.algebra.Precedence;
import groove.algebra.Signature;
import groove.algebra.SignatureKind;
import groove.annotation.InfixSymbol;
import groove.annotation.Syntax;
import groove.annotation.ToolTipBody;
import groove.annotation.ToolTipHeader;
import groove.annotation.ToolTipPars;
import groove.grammar.model.FormatException;
import groove.util.ExprParser;

public abstract class StringSignature<String, Bool, Int>
implements Signature {
    @Syntax(value="Q%s.LPAR.s1.COMMA.s2.RPAR")
    @ToolTipHeader(value="String concatenation")
    @ToolTipBody(value={"Returns a string consisting of %s followed by %s"})
    @ToolTipPars(value={"First string parameter", "Second string parameter"})
    @InfixSymbol(symbol="+", precedence=Precedence.ADD)
    public abstract String concat(String var1, String var2);

    @ToolTipHeader(value="String lesser-than test")
    @Syntax(value="Q%s.LPAR.s1.COMMA.s2.RPAR")
    @ToolTipBody(value={"Yields TRUE if string %s is a proper prefix of string %s"})
    @InfixSymbol(symbol="<", precedence=Precedence.COMPARE)
    public abstract Bool lt(String var1, String var2);

    @ToolTipHeader(value="String lesser-or-equal test")
    @Syntax(value="Q%s.LPAR.s1.COMMA.s2.RPAR")
    @ToolTipBody(value={"Yields TRUE if string %s is a prefix of string %s"})
    @InfixSymbol(symbol="<=", precedence=Precedence.COMPARE)
    public abstract Bool le(String var1, String var2);

    @ToolTipHeader(value="String greater-than test")
    @Syntax(value="Q%s.LPAR.s1.COMMA.s2.RPAR")
    @ToolTipBody(value={"Yields TRUE if string %2$s is a prefix of string %1$s"})
    @InfixSymbol(symbol=">", precedence=Precedence.COMPARE)
    public abstract Bool gt(String var1, String var2);

    @ToolTipHeader(value="String greater-or-equals test")
    @Syntax(value="Q%s.LPAR.s1.COMMA.s2.RPAR")
    @ToolTipBody(value={"Yields TRUE if string %2$s is a prefix of string %1$s"})
    @InfixSymbol(symbol=">=", precedence=Precedence.COMPARE)
    public abstract Bool ge(String var1, String var2);

    @ToolTipHeader(value="String equality test")
    @Syntax(value="Q%s.LPAR.s1.COMMA.s2.RPAR")
    @ToolTipBody(value={"Yields TRUE if string %s equals string %s"})
    @InfixSymbol(symbol="==", precedence=Precedence.EQUAL)
    public abstract Bool eq(String var1, String var2);

    @ToolTipHeader(value="String equality test")
    @Syntax(value="Q%s.LPAR.s1.COMMA.s2.RPAR")
    @ToolTipBody(value={"Yields TRUE if string %s does not equal string %s"})
    @InfixSymbol(symbol="!=", precedence=Precedence.EQUAL)
    public abstract Bool neq(String var1, String var2);

    @ToolTipHeader(value="Length function")
    @Syntax(value="Q%s.LPAR.s.RPAR")
    @ToolTipBody(value={"Yields the number of characters in string %s"})
    public abstract Int length(String var1);

    @Override
    public final boolean isValue(String value) {
        if (value.indexOf(34) != 0) {
            return false;
        }
        try {
            ExprParser.toUnquoted(value, '\"');
            return true;
        }
        catch (FormatException formatException) {
            return false;
        }
    }

    public final String getValueFromJava(Object constant) {
        if (!(constant instanceof String)) {
            throw new IllegalArgumentException(String.format("Native int type is %s, not %s", String.class.getSimpleName(), constant.getClass().getSimpleName()));
        }
        return this.toValue((String)constant);
    }

    protected abstract String toValue(String var1);

    @Override
    public SignatureKind getKind() {
        return SignatureKind.STRING;
    }
}

