/*
 * Decompiled with CFR 0.152.
 */
package groove.control;

import groove.control.CtrlCall;
import groove.control.CtrlGuard;
import groove.control.CtrlLabel;
import groove.control.CtrlMorphism;
import groove.control.CtrlState;
import groove.control.CtrlTransition;
import groove.control.CtrlVar;
import groove.control.CtrlVarSet;
import groove.grammar.Recipe;
import groove.grammar.Rule;
import groove.grammar.model.FormatException;
import groove.graph.AGraph;
import groove.graph.GraphInfo;
import groove.graph.GraphRole;
import groove.graph.Node;
import groove.util.collect.NestedIterator;
import groove.util.collect.TransformIterator;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CtrlAut
extends AGraph<CtrlState, CtrlTransition> {
    private final CtrlState startState;
    private final CtrlState finalState;
    private final Set<CtrlState> states = new HashSet<CtrlState>();
    private final TransitionSet transitions = new TransitionSet();
    private final Set<CtrlTransition> omegaTransitions = new LinkedHashSet<CtrlTransition>();
    private int maxStateNr = -1;
    private boolean isDefault;

    public CtrlAut(String name) {
        super(name);
        this.startState = this.addState();
        this.finalState = this.addState();
        this.getInfo();
    }

    @Override
    public GraphRole getRole() {
        return GraphRole.CTRL;
    }

    @Override
    public CtrlAut newGraph(String name) {
        return new CtrlAut(name);
    }

    @Override
    public boolean addNode(CtrlState node) {
        throw new UnsupportedOperationException("Use addState(CtrlState)");
    }

    @Override
    public boolean removeEdge(CtrlTransition edge) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addEdge(CtrlTransition edge) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeNode(CtrlState node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CtrlAut clone() {
        return this.clone(this.getName());
    }

    public CtrlAut clone(String name) {
        return this.clone(name, null);
    }

    public CtrlAut clone(Recipe recipe) {
        return this.clone(recipe == null ? this.getName() : recipe.getFullName(), recipe);
    }

    private CtrlAut clone(String name, Recipe recipe) {
        CtrlAut result = this.newGraph(name);
        CtrlMorphism morphism = new CtrlMorphism();
        morphism.putNode(this.getStart(), result.getStart());
        morphism.putNode(this.getFinal(), result.getFinal());
        for (CtrlState state : this.nodeSet()) {
            CtrlState image;
            if (state.equals(this.getStart())) {
                image = result.getStart();
            } else if (state.equals(this.getFinal())) {
                image = result.getFinal();
            } else if (recipe == null) {
                image = result.addState(state, state.getRecipe());
            } else {
                boolean terminating = state.getTransitions().size() == 1 && state.getTransitions().iterator().next().getCall().isOmega();
                image = result.addState(state, terminating ? null : recipe);
            }
            image.setBoundVars(state.getBoundVars());
            morphism.putNode(state, image);
        }
        for (CtrlTransition trans : this.edgeSet()) {
            CtrlLabel label = (CtrlLabel)trans.label();
            CtrlCall call = trans.getCall();
            CtrlState newSource = (CtrlState)morphism.getNode((Node)trans.source());
            CtrlState newTarget = (CtrlState)morphism.getNode((Node)trans.target());
            CtrlGuard newGuard = label.getGuard().newGuard(morphism.edgeMap());
            Recipe newRecipe = recipe == null || call.isOmega() ? trans.getRecipe() : recipe;
            CtrlCall newCall = call.embed(newRecipe);
            boolean newStart = recipe == null ? trans.isStart() : newSource == result.getStart() || call.isOmega();
            CtrlLabel newLabel = new CtrlLabel(newCall, newGuard, newStart);
            CtrlTransition newTrans = newSource.addTransition(newLabel, newTarget);
            assert (newTrans != null);
            morphism.putEdge(trans, newTrans);
        }
        if (this.isDefault()) {
            result.setDefault();
        }
        result.addErrors(this);
        return result;
    }

    void addOmega(CtrlTransition edge) {
        assert (edge.getCall().isOmega());
        this.omegaTransitions.add(edge);
    }

    void removeOmega(CtrlTransition edge) {
        assert (edge.getCall().isOmega());
        this.omegaTransitions.remove(edge);
    }

    CtrlState addState() {
        CtrlState result = this.createState(null);
        this.addState(result);
        return result;
    }

    CtrlState addState(CtrlState original, Recipe recipe) {
        CtrlState result = recipe == null ? this.createState(original.getRecipe()) : this.createState(recipe);
        this.addState(result);
        return result;
    }

    private void addState(CtrlState state) {
        if (state.getNumber() == this.maxStateNr + 1) {
            ++this.maxStateNr;
        }
        this.states.add(state);
    }

    void addErrors(CtrlAut other) {
        GraphInfo.addErrors(this, GraphInfo.getErrors(this));
    }

    @Override
    public Set<CtrlTransition> edgeSet() {
        return this.transitions;
    }

    @Override
    public Set<CtrlState> nodeSet() {
        return this.states;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        for (CtrlState state : new TreeSet<CtrlState>(this.nodeSet())) {
            result.append(String.format("State %s, variables %s%n", state, state.getBoundVars()));
            result.append(state.getSchedule().toString());
        }
        return result.toString();
    }

    public Set<CtrlTransition> getOmegas() {
        return this.omegaTransitions;
    }

    public CtrlState getOmegaOnlyState() {
        CtrlState result = null;
        for (CtrlTransition omega : this.getOmegas()) {
            if (!((CtrlState)omega.source()).isOmegaOnly()) continue;
            result = (CtrlState)omega.source();
            break;
        }
        return result;
    }

    public CtrlState getStart() {
        return this.startState;
    }

    public CtrlState getFinal() {
        return this.finalState;
    }

    public CtrlGuard getInitGuard() {
        return this.getStart().getInit();
    }

    public Set<Rule> getRules() {
        HashSet<Rule> result = new HashSet<Rule>();
        for (CtrlTransition trans : this.edgeSet()) {
            CtrlCall call = trans.getCall();
            if (call.getKind() != CtrlCall.Kind.RULE) continue;
            result.add(call.getRule());
        }
        return result;
    }

    private CtrlState createState(Recipe recipe) {
        int stateNr = this.maxStateNr + 1;
        boolean fresh = false;
        block0: while (!fresh) {
            fresh = true;
            for (CtrlState state : this.nodeSet()) {
                if (stateNr != state.getNumber()) continue;
                fresh = false;
                ++stateNr;
                continue block0;
            }
        }
        this.maxStateNr = stateNr;
        return new CtrlState(this, recipe, stateNr);
    }

    public CtrlAut normalise() throws FormatException {
        CtrlAut result = this;
        if (!GraphInfo.hasErrors(this)) {
            Set<Set<CtrlState>> equivalence = this.computeEquivalence();
            Map<CtrlState, Set<CtrlState>> partition = this.computePartition(equivalence);
            result = this.computeQuotient(partition);
            result.setBoundVars();
        }
        return result;
    }

    private Set<Set<CtrlState>> computeEquivalence() throws FormatException {
        Set<HashSet<CtrlState>> depSet;
        HashSet<CtrlState> ijPair;
        HashSet<Set<CtrlState>> result = new HashSet<Set<CtrlState>>();
        HashMap depMap = new HashMap();
        for (CtrlState i : this.nodeSet()) {
            for (CtrlState j : this.nodeSet()) {
                if (i.getNumber() >= j.getNumber()) continue;
                ijPair = new HashSet<CtrlState>(Arrays.asList(i, j));
                depSet = new HashSet<HashSet<CtrlState>>();
                depSet.add(ijPair);
                depMap.put(ijPair, depSet);
                result.add(ijPair);
            }
        }
        for (CtrlState i : this.nodeSet()) {
            for (CtrlState j : this.nodeSet()) {
                if (i.getNumber() >= j.getNumber()) continue;
                ijPair = new HashSet<CtrlState>(Arrays.asList(i, j));
                depSet = (Set)depMap.remove(ijPair);
                assert (depSet != null);
                boolean distinct = i.isTransient() ^ j.isTransient();
                if (!distinct && i.isTransient()) {
                    boolean bl = distinct = !i.getRecipe().equals(j.getRecipe());
                }
                if (!distinct) {
                    boolean bl = distinct = !i.getBoundVars().equals(j.getBoundVars());
                }
                if (!distinct) {
                    Map<CtrlTransition, CtrlTransition> equivalence = this.computeEquivalence(i, j);
                    boolean bl = distinct = equivalence == null;
                    if (!distinct) {
                        for (Map.Entry<CtrlTransition, CtrlTransition> entry : equivalence.entrySet()) {
                            CtrlTransition iOut = entry.getKey();
                            CtrlTransition jOut = entry.getValue();
                            if (iOut.target() == jOut.target()) continue;
                            HashSet<CtrlState> ijTargetPair = new HashSet<CtrlState>(Arrays.asList((CtrlState)iOut.target(), (CtrlState)jOut.target()));
                            Set ijTargetDep = (Set)depMap.get(ijTargetPair);
                            if (ijTargetDep == null) {
                                distinct = true;
                                break;
                            }
                            ijTargetDep.addAll(depSet);
                        }
                    }
                }
                if (!distinct) continue;
                result.removeAll(depSet);
            }
        }
        return result;
    }

    private Map<CtrlTransition, CtrlTransition> computeEquivalence(CtrlState i, CtrlState j) throws FormatException {
        boolean distinct;
        HashMap<CtrlTransition, CtrlTransition> result = new HashMap<CtrlTransition, CtrlTransition>();
        Map<CtrlCall, CtrlTransition> iOutMap = this.getOutTransitions(i);
        Map<CtrlCall, CtrlTransition> jOutMap = this.getOutTransitions(j);
        boolean bl = distinct = !iOutMap.keySet().equals(jOutMap.keySet());
        if (!distinct) {
            for (Map.Entry<CtrlCall, CtrlTransition> entry : iOutMap.entrySet()) {
                CtrlTransition iOut = entry.getValue();
                CtrlTransition jOut = jOutMap.get(entry.getKey());
                if (iOut.isStart() != jOut.isStart()) {
                    distinct = true;
                    break;
                }
                result.put(iOut, jOut);
            }
        }
        if (!distinct) {
            block1: for (Map.Entry<CtrlCall, CtrlTransition> entry : result.entrySet()) {
                CtrlGuard iGuard = ((CtrlTransition)((Object)entry.getKey())).getGuard();
                CtrlGuard jGuard = entry.getValue().getGuard();
                if (iGuard.size() != jGuard.size()) {
                    distinct = true;
                    break;
                }
                for (CtrlTransition iGuardElem : iGuard) {
                    if (jGuard.contains(result.get(iGuardElem))) continue;
                    distinct = true;
                    break block1;
                }
            }
        }
        return distinct ? null : result;
    }

    private Map<CtrlCall, CtrlTransition> getOutTransitions(CtrlState s) throws FormatException {
        HashMap<CtrlCall, CtrlTransition> result = new HashMap<CtrlCall, CtrlTransition>();
        for (CtrlTransition outTrans : s.getTransitions()) {
            CtrlCall call = outTrans.getCall();
            CtrlTransition oldTrans = result.put(call, outTrans);
            if (oldTrans == null) continue;
            throw new FormatException("State %s has multiple outgoing calls %s", s, call);
        }
        return result;
    }

    private Map<CtrlState, Set<CtrlState>> computePartition(Set<Set<CtrlState>> equivalence) {
        HashMap<CtrlState, Set<CtrlState>> result = new HashMap<CtrlState, Set<CtrlState>>();
        for (CtrlState ctrlState : this.nodeSet()) {
            HashSet<CtrlState> cell = new HashSet<CtrlState>();
            cell.add(ctrlState);
            result.put(ctrlState, cell);
        }
        for (Set set : equivalence) {
            Set s2Cell;
            assert (set.size() == 2);
            Iterator distIter = set.iterator();
            CtrlState s1 = (CtrlState)distIter.next();
            CtrlState s2 = (CtrlState)distIter.next();
            Set s1Cell = (Set)result.get(s1);
            if (s1Cell == (s2Cell = (Set)result.get(s2))) continue;
            s1Cell.addAll(s2Cell);
            for (CtrlState s2Sib : s2Cell) {
                result.put(s2Sib, s1Cell);
            }
        }
        return result;
    }

    private CtrlAut computeQuotient(Map<CtrlState, Set<CtrlState>> partition) {
        CtrlAut result = this.newGraph(this.getName());
        HashSet<CtrlState> representatives = new HashSet<CtrlState>();
        HashMap<Set<CtrlState>, CtrlState> stateMap = new HashMap<Set<CtrlState>, CtrlState>();
        for (Map.Entry<CtrlState, Set<CtrlState>> cellEntry : partition.entrySet()) {
            CtrlState image;
            Set<CtrlState> cell = cellEntry.getValue();
            if (stateMap.containsKey(cell)) continue;
            representatives.add(cellEntry.getKey());
            if (cell.contains(this.getStart())) {
                image = result.getStart();
                assert (!cell.contains(this.getFinal()));
            } else if (cell.contains(this.getFinal())) {
                image = result.getFinal();
            } else {
                CtrlState representative = cell.iterator().next();
                image = result.addState(representative, null);
            }
            stateMap.put(cell, image);
        }
        HashMap<CtrlState, CtrlState> normalMap = new HashMap<CtrlState, CtrlState>();
        for (Map.Entry cellEntry : stateMap.entrySet()) {
            for (CtrlState state : (Set)cellEntry.getKey()) {
                normalMap.put(state, (CtrlState)cellEntry.getValue());
            }
        }
        for (CtrlState state : representatives) {
            state.copyTransitions(normalMap, null);
        }
        return result;
    }

    private void setBoundVars() {
        HashMap inMap = new HashMap();
        for (CtrlState state : this.nodeSet()) {
            inMap.put(state, new HashSet());
        }
        for (CtrlTransition trans : this.edgeSet()) {
            ((Set)inMap.get(trans.target())).add(trans);
            ((CtrlState)trans.source()).addBoundVars(trans.getInVars());
        }
        LinkedList<CtrlTransition> queue = new LinkedList<CtrlTransition>(this.edgeSet());
        while (!queue.isEmpty()) {
            CtrlTransition next = (CtrlTransition)queue.poll();
            CtrlState source = (CtrlState)next.source();
            CtrlVarSet sourceVars = new CtrlVarSet((Collection<? extends CtrlVar>)source.getBoundVars());
            boolean modified = false;
            for (CtrlVar targetVar : ((CtrlState)next.target()).getBoundVars()) {
                if (next.getOutVars().contains(targetVar)) continue;
                modified |= sourceVars.add(targetVar);
            }
            if (!modified) continue;
            source.setBoundVars(sourceVars);
            queue.addAll((Collection)inMap.get(source));
        }
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault() {
        this.isDefault = true;
    }

    public boolean isEndDeterministic() {
        boolean result = true;
        block0: for (CtrlTransition omegaTrans : this.getOmegas()) {
            CtrlGuard guard = ((CtrlLabel)omegaTrans.label()).getGuard();
            for (CtrlTransition otherTrans : this.outEdgeSet((Node)omegaTrans.source())) {
                if (otherTrans.getCall().isOmega() || guard.contains(otherTrans)) continue;
                result = false;
                break block0;
            }
        }
        return result;
    }

    private class TransitionSet
    extends AbstractSet<CtrlTransition> {
        private TransitionSet() {
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof CtrlTransition) {
                CtrlTransition trans = (CtrlTransition)o;
                return trans.equals(((CtrlState)trans.source()).getTransition(trans.getCall()));
            }
            return false;
        }

        @Override
        public Iterator<CtrlTransition> iterator() {
            return new NestedIterator<CtrlTransition>(new TransformIterator<CtrlState, Iterator<CtrlTransition>>(CtrlAut.this.nodeSet().iterator()){

                @Override
                protected Iterator<CtrlTransition> toOuter(CtrlState from) {
                    return from.getTransitions().iterator();
                }
            });
        }

        @Override
        public int size() {
            int result = 0;
            for (CtrlState state : CtrlAut.this.nodeSet()) {
                result += state.getTransitions().size();
            }
            return result;
        }
    }
}

