/*
 * Decompiled with CFR 0.152.
 */
package groove.control;

import groove.control.CtrlAut;
import groove.control.CtrlCall;
import groove.control.CtrlGuard;
import groove.control.CtrlLabel;
import groove.control.CtrlSchedule;
import groove.control.CtrlTransition;
import groove.control.CtrlTransitionSet;
import groove.control.CtrlVar;
import groove.control.CtrlVarSet;
import groove.grammar.Recipe;
import groove.grammar.model.FormatErrorSet;
import groove.graph.GraphInfo;
import groove.graph.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class CtrlState
implements Node,
Comparator<CtrlTransition> {
    private final CtrlAut aut;
    private final int stateNumber;
    private final List<CtrlTransition> transitions = new ArrayList<CtrlTransition>();
    private final Map<CtrlCall, CtrlTransition> transitionMap = new HashMap<CtrlCall, CtrlTransition>();
    private final List<CtrlVar> boundVars = new ArrayList<CtrlVar>();
    private final Recipe recipe;
    private CtrlGuard exitGuard;
    private CtrlSchedule schedule;
    private Map<CtrlTransition, CtrlTransitionSet> disabledMap;
    private Map<CtrlTransitionSet, Map<CtrlTransitionSet, CtrlSchedule>> scheduleMap;
    private int recipeCount;

    public CtrlState(CtrlAut aut, Recipe recipe, int nr) {
        this.aut = aut;
        this.stateNumber = nr;
        this.recipe = recipe;
    }

    public CtrlAut getAut() {
        return this.aut;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.stateNumber;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CtrlState other = (CtrlState)obj;
        return this.stateNumber == other.stateNumber;
    }

    @Override
    public int getNumber() {
        return this.stateNumber;
    }

    public boolean isStart() {
        return this.getAut().getStart() == this;
    }

    public boolean isTransient() {
        return this.recipe != null;
    }

    public Recipe getRecipe() {
        return this.recipe;
    }

    public String toString() {
        return "q" + this.stateNumber;
    }

    public CtrlTransition addTransition(CtrlLabel label, CtrlState target) {
        CtrlTransition result = null;
        CtrlTransition oldTrans = this.transitionMap.get(label.getCall());
        if (oldTrans != null) {
            if (!label.getGuard().contains(oldTrans)) {
                FormatErrorSet errors = new FormatErrorSet("Nondeterministic '%s'-call", label.getCall());
                GraphInfo.addErrors(this.getAut(), errors);
            }
        } else {
            result = new CtrlTransition(this, label, target);
            this.transitionMap.put(label.getCall(), result);
            this.transitions.add(result);
            if (result.hasRecipe()) {
                ++this.recipeCount;
            }
            if (label.getCall().isOmega()) {
                this.getAut().addOmega(result);
            }
            if (label.isStart() && this.isTransient()) {
                this.setExitGuard(label.getGuard());
            }
        }
        return result;
    }

    public void removeOmega(CtrlTransition trans) {
        boolean result;
        assert (trans.getCall().isOmega());
        this.transitions.remove(trans.getNumber());
        boolean bl = result = this.transitionMap.remove(trans.getCall()) != null;
        if (result) {
            this.getAut().removeOmega(trans);
        }
    }

    public boolean hasRecipes() {
        return this.recipeCount > 0;
    }

    public CtrlTransition getTransition(CtrlCall call) {
        return this.transitionMap.get(call);
    }

    public Collection<CtrlTransition> getTransitions() {
        return this.transitions;
    }

    public boolean isOmegaOnly() {
        boolean result = false;
        if (this.getTransitions().size() == 1) {
            CtrlTransition trans = this.getTransitions().iterator().next();
            result = trans.getCall().isOmega() && trans.getGuard().isEmpty();
        }
        return result;
    }

    public CtrlGuard getInit() {
        CtrlGuard result = new CtrlGuard();
        for (CtrlTransition trans : this.getTransitions()) {
            CtrlCall call = trans.getCall();
            if (call.isOmega()) {
                result = null;
                break;
            }
            result.add(trans);
        }
        return result;
    }

    public List<CtrlVar> getBoundVars() {
        return this.boundVars;
    }

    public void addBoundVars(Collection<CtrlVar> variables) {
        CtrlVarSet newVars = new CtrlVarSet((Collection<? extends CtrlVar>)variables);
        newVars.addAll(this.boundVars);
        this.boundVars.clear();
        this.boundVars.addAll(newVars);
    }

    public void setBoundVars(Collection<CtrlVar> variables) {
        this.boundVars.clear();
        this.boundVars.addAll(new CtrlVarSet((Collection<? extends CtrlVar>)variables));
    }

    public CtrlSchedule getSchedule() {
        if (this.schedule == null) {
            assert (this.disabledMap == null);
            this.disabledMap = this.computeDisabledMap();
            this.schedule = this.getSchedule(new CtrlTransitionSet((Collection<? extends CtrlTransition>)this.getTransitions()), new CtrlTransitionSet(), new CtrlTransitionSet());
            this.scheduleMap = null;
        }
        return this.schedule;
    }

    public CtrlGuard getExitGuard() {
        return this.exitGuard;
    }

    public boolean hasExitGuard() {
        return this.getExitGuard() != null;
    }

    public void setExitGuard(CtrlGuard exitGuard) {
        assert (this.isTransient() && (this.exitGuard == null || exitGuard.containsAll(this.exitGuard)));
        if (this.exitGuard == null) {
            this.exitGuard = exitGuard;
        }
    }

    public void copyTransitions(Map<CtrlState, CtrlState> stateMap, CtrlGuard guard) {
        CtrlState sourceImage = stateMap.get(this);
        HashMap<CtrlTransition, CtrlTransition> transMap = new HashMap<CtrlTransition, CtrlTransition>();
        for (CtrlTransition key : new ArrayList<CtrlTransition>(this.transitions)) {
            CtrlState targetImage = stateMap.get(key.target());
            CtrlLabel newLabel = ((CtrlLabel)key.label()).newLabel(transMap, guard);
            CtrlTransition image = sourceImage.addTransition(newLabel, targetImage);
            if (image == null) continue;
            transMap.put(key, image);
        }
    }

    private Map<CtrlTransition, CtrlTransitionSet> computeDisabledMap() {
        HashMap<CtrlTransition, CtrlTransitionSet> result = new HashMap<CtrlTransition, CtrlTransitionSet>();
        for (CtrlTransition trans : this.getTransitions()) {
            for (CtrlTransition call : ((CtrlLabel)trans.label()).getGuard()) {
                CtrlTransitionSet disablings = (CtrlTransitionSet)result.get(call);
                if (disablings == null) {
                    disablings = new CtrlTransitionSet();
                    result.put(call, disablings);
                }
                disablings.add(trans);
            }
        }
        return result;
    }

    private CtrlSchedule getSchedule(CtrlTransitionSet transSet, CtrlTransitionSet triedCalls, CtrlTransitionSet failedCalls) {
        CtrlSchedule result;
        Map<CtrlTransitionSet, CtrlSchedule> auxMap;
        if (this.scheduleMap == null) {
            this.scheduleMap = new HashMap<CtrlTransitionSet, Map<CtrlTransitionSet, CtrlSchedule>>();
        }
        if ((auxMap = this.scheduleMap.get(transSet)) == null) {
            auxMap = new HashMap<CtrlTransitionSet, CtrlSchedule>();
            this.scheduleMap.put(transSet, auxMap);
        }
        if ((result = auxMap.get(triedCalls)) == null) {
            result = this.computeSchedule(transSet, triedCalls, failedCalls);
            auxMap.put(triedCalls, result);
        }
        return result;
    }

    private CtrlSchedule computeSchedule(CtrlTransitionSet transSet, CtrlTransitionSet tried, CtrlTransitionSet failed) {
        TreeSet<CtrlTransition> chosenTrans = null;
        TreeSet chosenDisablings = null;
        boolean success = false;
        for (CtrlTransition tryTrans : transSet) {
            boolean fresh;
            boolean choose;
            TreeSet tryDisablings;
            TreeSet<CtrlTransition> guard = new TreeSet<CtrlTransition>(tryTrans.getGuard());
            guard.removeAll(tried);
            if (!guard.isEmpty()) continue;
            if (tryTrans.getCall().isOmega()) {
                success = true;
                continue;
            }
            if (this.disabledMap.containsKey(tryTrans)) {
                tryDisablings = new TreeSet(this.disabledMap.get(tryTrans));
                tryDisablings.retainAll(transSet);
            } else {
                tryDisablings = new TreeSet();
            }
            if (chosenTrans == null) {
                choose = true;
                fresh = true;
            } else if (((Object)tryDisablings).equals(chosenDisablings)) {
                choose = true;
                fresh = false;
            } else if (tryDisablings.size() < chosenDisablings.size()) {
                choose = true;
                fresh = true;
            } else if (tryDisablings.size() > chosenDisablings.size()) {
                choose = false;
                fresh = false;
            } else {
                choose = this.compare(tryTrans, (CtrlTransition)chosenTrans.first()) < 0;
                fresh = true;
            }
            if (!choose) continue;
            if (fresh) {
                chosenTrans = new TreeSet<CtrlTransition>(this);
                chosenDisablings = tryDisablings;
            }
            chosenTrans.add(tryTrans);
        }
        boolean isTransient = this.isTransient();
        if (this.hasExitGuard()) {
            HashSet<CtrlTransition> guard = new HashSet<CtrlTransition>(this.getExitGuard());
            guard.removeAll(failed);
            isTransient = !guard.isEmpty();
        }
        CtrlSchedule result = new CtrlSchedule(this, chosenTrans == null ? null : new ArrayList<CtrlTransition>(chosenTrans), tried, success, isTransient);
        if (chosenTrans != null) {
            CtrlSchedule succNext;
            CtrlTransitionSet newTried = new CtrlTransitionSet(tried);
            newTried.addAll(chosenTrans);
            CtrlTransitionSet newFailed = new CtrlTransitionSet(failed);
            newFailed.addAll(chosenTrans);
            CtrlTransitionSet remainder = new CtrlTransitionSet(transSet);
            remainder.removeAll(chosenTrans);
            CtrlSchedule failNext = this.getSchedule(remainder, newTried, newFailed);
            if (chosenDisablings.isEmpty()) {
                succNext = failNext;
            } else {
                remainder = new CtrlTransitionSet(remainder);
                remainder.removeAll(chosenDisablings);
                succNext = this.getSchedule(remainder, newTried, failed);
            }
            result.setNext(succNext, failNext);
        }
        return result;
    }

    @Override
    public int compare(CtrlTransition one, CtrlTransition two) {
        int hisRecipe;
        int myRecipe;
        int result = one.getCall().toString().compareTo(two.getCall().toString());
        if (result == 0) {
            result = one.getGuard().compareTo(two.getGuard());
        }
        if (result == 0 && (result = (myRecipe = one.hasRecipe() ? 1 : 0) - (hisRecipe = two.hasRecipe() ? 1 : 0)) == 0 && one.hasRecipe()) {
            result = one.getRecipe().compareTo(two.getRecipe());
        }
        if (result == 0) {
            int myStart = one.isStart() ? 1 : 0;
            int hisStart = two.isStart() ? 1 : 0;
            result = myStart - hisStart;
        }
        if (result == 0) {
            result = one.getNumber() - two.getNumber();
        }
        return result;
    }
}

