/*
 * Decompiled with CFR 0.152.
 */
package groove.control;

import groove.algebra.SignatureKind;

public enum CtrlType {
    NODE,
    BOOL(SignatureKind.BOOL),
    INT(SignatureKind.INT),
    REAL(SignatureKind.REAL),
    STRING(SignatureKind.STRING);

    private final String name;
    private final SignatureKind signature;
    public static final String NODE_TYPE_NAME = "node";

    private CtrlType() {
        this.signature = null;
        this.name = NODE_TYPE_NAME;
    }

    private CtrlType(SignatureKind signature) {
        this.signature = signature;
        this.name = signature.getName();
    }

    public String toString() {
        return this.name;
    }

    public SignatureKind getSignature() {
        return this.signature;
    }

    public static CtrlType getDataType(SignatureKind signature) {
        return CtrlType.valueOf(signature.name());
    }
}

