/*
 * Decompiled with CFR 0.152.
 */
package groove.control.parse;

import groove.control.CtrlType;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;

public class SymbolTable {
    private ArrayDeque<Scope> scopes = new ArrayDeque();

    public void openScope() {
        this.scopes.push(new Scope());
    }

    public void closeScope() {
        this.scopes.pop();
    }

    public boolean declareSymbol(String symbolName, CtrlType symbolType) {
        if (!this.scopes.peek().isDeclared(symbolName)) {
            this.scopes.peek().declare(symbolName, symbolType);
            return true;
        }
        return false;
    }

    public boolean isDeclared(String symbolName) {
        for (Scope s : this.scopes) {
            if (!s.isDeclared(symbolName)) continue;
            return true;
        }
        return false;
    }

    public CtrlType getType(String symbolName) {
        CtrlType type = null;
        for (Scope s : this.scopes) {
            if (!s.isDeclared(symbolName)) continue;
            type = s.getType(symbolName);
        }
        return type;
    }

    private class Scope {
        private Map<String, CtrlType> declared = new HashMap<String, CtrlType>();

        public void declare(String var, CtrlType type) {
            this.declared.put(var, type);
        }

        public boolean isDeclared(String var) {
            return this.declared.containsKey(var);
        }

        public CtrlType getType(String var) {
            return this.declared.get(var);
        }
    }
}

