/*
 * Decompiled with CFR 0.152.
 */
package groove.explore;

import groove.explore.StrategyValue;
import groove.explore.encode.Serialized;
import groove.explore.encode.Template;
import groove.explore.encode.TemplateList;
import groove.explore.strategy.Strategy;
import groove.grammar.Grammar;
import groove.grammar.model.FormatException;
import java.util.EnumSet;

public class StrategyEnumerator
extends TemplateList<Strategy> {
    private static final StrategyEnumerator INSTANCE = StrategyEnumerator.newInstance();
    private static final String STRATEGY_TOOLTIP = "<HTML>The exploration strategy determines at each state:<BR><B>1.</B> Which of the applicable transitions will be taken; and<BR><B>2.</B> In which order the reached states will be explored.</HTML>";

    private StrategyEnumerator(EnumSet<StrategyValue> enumSet) {
        super("exploration strategy", STRATEGY_TOOLTIP);
        for (StrategyValue value : enumSet) {
            Template<Strategy> template = value.getTemplate();
            this.addTemplate(template);
        }
    }

    public static StrategyEnumerator newInstance() {
        return new StrategyEnumerator(EnumSet.allOf(StrategyValue.class));
    }

    public static StrategyEnumerator newInstance(EnumSet<StrategyValue> enumSet) {
        return new StrategyEnumerator(enumSet);
    }

    public static Strategy parseStrategy(Grammar rules, Serialized source) throws FormatException {
        return (Strategy)INSTANCE.parse(rules, source);
    }
}

