/*
 * Decompiled with CFR 0.152.
 */
package groove.explore;

import groove.abstraction.neigh.explore.strategy.ShapeBFSStrategy;
import groove.abstraction.neigh.explore.strategy.ShapeDFSStrategy;
import groove.explore.Exploration;
import groove.explore.ParsableValue;
import groove.explore.encode.EncodedBoundary;
import groove.explore.encode.EncodedEdgeMap;
import groove.explore.encode.EncodedEnabledRule;
import groove.explore.encode.EncodedHostName;
import groove.explore.encode.EncodedInt;
import groove.explore.encode.EncodedLtlProperty;
import groove.explore.encode.EncodedRuleMode;
import groove.explore.encode.EncodedType;
import groove.explore.encode.Serialized;
import groove.explore.encode.Template;
import groove.explore.prettyparse.PAll;
import groove.explore.prettyparse.PChoice;
import groove.explore.prettyparse.PIdentifier;
import groove.explore.prettyparse.PLiteral;
import groove.explore.prettyparse.PNumber;
import groove.explore.prettyparse.POptional;
import groove.explore.prettyparse.PSeparated;
import groove.explore.prettyparse.PSequence;
import groove.explore.prettyparse.SerializedParser;
import groove.explore.result.EdgeBoundCondition;
import groove.explore.result.IsRuleApplicableCondition;
import groove.explore.result.NodeBoundCondition;
import groove.explore.strategy.BFSStrategy;
import groove.explore.strategy.Boundary;
import groove.explore.strategy.BoundedLTLStrategy;
import groove.explore.strategy.BoundedPocketLTLStrategy;
import groove.explore.strategy.ConditionalBFSStrategy;
import groove.explore.strategy.DFSStrategy;
import groove.explore.strategy.ExploreStateStrategy;
import groove.explore.strategy.LTLStrategy;
import groove.explore.strategy.LinearStrategy;
import groove.explore.strategy.RandomLinearStrategy;
import groove.explore.strategy.RemoteStrategy;
import groove.explore.strategy.ReteLinearStrategy;
import groove.explore.strategy.ReteRandomLinearStrategy;
import groove.explore.strategy.ReteStrategy;
import groove.explore.strategy.Strategy;
import groove.grammar.Rule;
import groove.grammar.model.GrammarModel;
import groove.grammar.type.TypeLabel;
import java.util.EnumSet;
import java.util.Map;

public enum StrategyValue implements ParsableValue
{
    BFS("bfs", "Breadth-First Exploration", "This strategy first generates all possible transitions from each open state, and then continues in a breadth-first fashion."),
    DFS("dfs", "Depth-First Exploration", "This strategy first generates all possible transitions from each open state, and then continues in a depth-first fashion."),
    LINEAR("linear", "Linear Exploration", "This strategy chooses one transition from each open state. The transition of choice will be the same within one incarnation of Groove."),
    RANDOM("random", "Random Linear Exploration", "This strategy chooses one transition from each open state. The transition is chosen randomly."),
    STATE("state", "Single-State Exploration", "This strategy fully explores the current state."),
    RETE("rete", "Rete Strategy (DFS based)", "This strategy finds all possible transitions from the Rete network, and continues in a depth-first fashion using virtual events when possible. Rete updates are applied accumulatively"),
    RETE_LINEAR("retelinear", "Rete Linear Exploration", "This strategy chooses one transition from each open state. The transition of choice will be the same within one incarnation of Groove."),
    RETE_RANDOM("reterandom", "Rete Random Linear Exploration", "This strategy chooses one transition from each open state. The transition is chosen randomly."),
    CONDITIONAL("crule", "Conditional Exploration (Rule Condition)", "This strategy performs a conditional breadth-first exploration. If a given rule is applicable in a newly reached state, it  is not explored further. All other states are explored normally."),
    CONDITIONAL_NODE_BOUND("cnbound", "Conditional Exploration (Node Bound)", "This strategy performs a conditional breadth-first exploration. If the number of nodes in a newly reached state exceeds a given bound, it is not explored further. All other states are explored normally."),
    CONDITIONAL_EDGE_BOUND("cebound", "Conditional Exploration (Edge Bound)", "This strategy performs a conditional breadth-first exploration. If the number of edges in a newly reached state exceeds a given bound, it is not explored further. All other states are explored normally."),
    LTL("ltl", "LTL Model Checking", "Nested Depth-First Search for a given LTL formula."),
    LTL_BOUNDED("ltlbounded", "Bounded LTL Model Checking", "Nested Depth-First Search for a given LTL formula,using incremental bounds based on graph size or rule applications"),
    LTL_POCKET("ltlpocket", "Pocket LTL Model Checking", "Nested Depth-First Search for a given LTL formula,using incremental bounds based on graph size or rule applicationsand optimised to avoid reexploring connected components ('pockets')"),
    SHAPE_DFS("shapedfs", "Shape Depth-First Exploration", "This strategy is used for abstract state space exploration."),
    SHAPE_BFS("shapebfs", "Shape Breadth-First Exploration", "This strategy is used for abstract state space exploration."),
    REMOTE("remote", "Remote Exploration", "This strategy sends the result as an STS to a remote server.");

    private final String keyword;
    private final String name;
    private final String description;
    public static final EnumSet<StrategyValue> LTL_STRATEGIES;
    public static final EnumSet<StrategyValue> DIALOG_STRATEGIES;
    public static final EnumSet<StrategyValue> DEVELOPMENT_ONLY_STRATEGIES;
    public static final EnumSet<StrategyValue> ABSTRACT_STRATEGIES;
    public static final EnumSet<StrategyValue> CONCRETE_STRATEGIES;

    static {
        LTL_STRATEGIES = EnumSet.of(LTL, LTL_BOUNDED, LTL_POCKET);
        DEVELOPMENT_ONLY_STRATEGIES = EnumSet.of(RETE, RETE_LINEAR, RETE_RANDOM, SHAPE_DFS, SHAPE_BFS);
        ABSTRACT_STRATEGIES = EnumSet.of(SHAPE_DFS, SHAPE_BFS);
        CONCRETE_STRATEGIES = EnumSet.complementOf(ABSTRACT_STRATEGIES);
        DIALOG_STRATEGIES = EnumSet.complementOf(LTL_STRATEGIES);
        DIALOG_STRATEGIES.remove(STATE);
    }

    private StrategyValue(String keyword, String name, String description) {
        this.keyword = keyword;
        this.name = name;
        this.description = description;
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Serialized toSerialized() {
        return new Serialized(this.getKeyword());
    }

    @Override
    public boolean isDevelopment() {
        return DEVELOPMENT_ONLY_STRATEGIES.contains(this);
    }

    @Override
    public boolean isDefault(GrammarModel grammar) {
        Exploration exploration = grammar.getDefaultExploration();
        return exploration == null ? this == BFS : exploration.getStrategy().getKeyword().equals(this.getKeyword());
    }

    public Template<Strategy> getTemplate() {
        switch (this) {
            case RETE: {
                return new MyTemplate0(){

                    @Override
                    public Strategy create() {
                        return new ReteStrategy();
                    }
                };
            }
            case RETE_LINEAR: {
                return new MyTemplate0(){

                    @Override
                    public Strategy create() {
                        return new ReteLinearStrategy();
                    }
                };
            }
            case RETE_RANDOM: {
                return new MyTemplate0(){

                    @Override
                    public Strategy create() {
                        return new ReteRandomLinearStrategy();
                    }
                };
            }
            case BFS: {
                return new MyTemplate0(){

                    @Override
                    public Strategy create() {
                        return new BFSStrategy();
                    }
                };
            }
            case DFS: {
                return new MyTemplate0(){

                    @Override
                    public Strategy create() {
                        return new DFSStrategy();
                    }
                };
            }
            case LINEAR: {
                return new MyTemplate0(){

                    @Override
                    public Strategy create() {
                        return new LinearStrategy();
                    }
                };
            }
            case RANDOM: {
                return new MyTemplate0(){

                    @Override
                    public Strategy create() {
                        return new RandomLinearStrategy();
                    }
                };
            }
            case STATE: {
                return new MyTemplate0(){

                    @Override
                    public Strategy create() {
                        return new ExploreStateStrategy();
                    }
                };
            }
            case CONDITIONAL: {
                return new MyTemplate2<Rule, Boolean>((SerializedParser)new PSequence(new POptional("!", "mode", "Negative", "Positive"), new PIdentifier("rule")), "rule", (EncodedType)new EncodedEnabledRule(), "mode", (EncodedType)new EncodedRuleMode()){

                    @Override
                    public Strategy create(Rule rule, Boolean mode) {
                        IsRuleApplicableCondition condition = new IsRuleApplicableCondition(rule, mode);
                        ConditionalBFSStrategy strategy = new ConditionalBFSStrategy();
                        strategy.setExploreCondition(condition);
                        return strategy;
                    }
                };
            }
            case CONDITIONAL_NODE_BOUND: {
                return new MyTemplate1<Integer>((SerializedParser)new PNumber("node-bound"), "node-bound", (EncodedType)new EncodedInt(0, -1)){

                    @Override
                    public Strategy create(Integer bound) {
                        NodeBoundCondition condition = new NodeBoundCondition();
                        condition.setCondition(bound);
                        ConditionalBFSStrategy strategy = new ConditionalBFSStrategy();
                        strategy.setExploreCondition(condition);
                        return strategy;
                    }
                };
            }
            case CONDITIONAL_EDGE_BOUND: {
                return new MyTemplate1<Map<TypeLabel, Integer>>((SerializedParser)new PSeparated(new PSequence(new PIdentifier("edge-bound"), new PLiteral(">", "edge-bound"), new PNumber("edge-bound")), new PLiteral(",", "edge-bound")), "edge-bound", (EncodedType)new EncodedEdgeMap()){

                    @Override
                    public Strategy create(Map<TypeLabel, Integer> bounds) {
                        EdgeBoundCondition condition = new EdgeBoundCondition();
                        condition.setCondition(bounds);
                        ConditionalBFSStrategy strategy = new ConditionalBFSStrategy();
                        strategy.setExploreCondition(condition);
                        return strategy;
                    }
                };
            }
            case LTL: {
                return new MyTemplate1<String>((SerializedParser)new PAll("prop"), "prop", (EncodedType)new EncodedLtlProperty()){

                    @Override
                    public Strategy create(String property) {
                        LTLStrategy result = new LTLStrategy();
                        result.setProperty(property);
                        return result;
                    }
                };
            }
            case LTL_BOUNDED: {
                PSeparated boundParser = new PSeparated(new PChoice(new PIdentifier("rule"), new PNumber("value")), new PLiteral(",", "comma"));
                PSequence parser = new PSequence(boundParser, new PLiteral(";", "semi"), new PAll("prop"));
                return new MyTemplate2<String, Boundary>((SerializedParser)parser, "prop", (EncodedType)new EncodedLtlProperty(), "bound", (EncodedType)new EncodedBoundary()){

                    @Override
                    public Strategy create(String property, Boundary bound) {
                        BoundedLTLStrategy result = new BoundedLTLStrategy();
                        result.setProperty(property);
                        result.setBoundary(bound);
                        return result;
                    }
                };
            }
            case LTL_POCKET: {
                PSeparated boundParser = new PSeparated(new PChoice(new PIdentifier("rule"), new PNumber("value")), new PLiteral(",", "comma"));
                PSequence parser = new PSequence(boundParser, new PLiteral(";", "semi"), new PAll("prop"));
                return new MyTemplate2<String, Boundary>((SerializedParser)parser, "prop", (EncodedType)new EncodedLtlProperty(), "bound", (EncodedType)new EncodedBoundary()){

                    @Override
                    public Strategy create(String property, Boundary bound) {
                        BoundedPocketLTLStrategy result = new BoundedPocketLTLStrategy();
                        result.setProperty(property);
                        result.setBoundary(bound);
                        return result;
                    }
                };
            }
            case SHAPE_BFS: {
                return new MyTemplate0(){

                    @Override
                    public Strategy create() {
                        return new ShapeBFSStrategy();
                    }
                };
            }
            case SHAPE_DFS: {
                return new MyTemplate0(){

                    @Override
                    public Strategy create() {
                        return new ShapeDFSStrategy();
                    }
                };
            }
            case REMOTE: {
                return new MyTemplate1<String>((SerializedParser)new PAll("host"), "host", (EncodedType)new EncodedHostName()){

                    @Override
                    public Strategy create(String host) {
                        RemoteStrategy strategy = new RemoteStrategy();
                        strategy.setHost(host);
                        return strategy;
                    }
                };
            }
        }
        throw new IllegalStateException();
    }

    private abstract class MyTemplate0
    extends Template.Template0<Strategy> {
        public MyTemplate0() {
            super(StrategyValue.this);
        }
    }

    private abstract class MyTemplate1<T1>
    extends Template.Template1<Strategy, T1> {
        public MyTemplate1(SerializedParser parser, String name, EncodedType<T1, String> type) {
            super((ParsableValue)StrategyValue.this, parser, name, type);
        }
    }

    private abstract class MyTemplate2<T1, T2>
    extends Template.Template2<Strategy, T1, T2> {
        public MyTemplate2(SerializedParser parser, String name1, EncodedType<T1, String> type1, String name2, EncodedType<T2, String> type2) {
            super((ParsableValue)StrategyValue.this, parser, name1, type1, name2, type2);
        }
    }
}

