/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.encode;

import groove.explore.encode.EncodedType;
import groove.explore.encode.EncodedTypeEditor;
import groove.explore.strategy.Boundary;
import groove.explore.strategy.GraphNodeSizeBoundary;
import groove.explore.strategy.RuleSetBoundary;
import groove.grammar.Grammar;
import groove.grammar.Rule;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import java.util.HashSet;

public class EncodedBoundary
implements EncodedType<Boundary, String> {
    @Override
    public EncodedTypeEditor<Boundary, String> createEditor(GrammarModel grammar) {
        return null;
    }

    @Override
    public Boundary parse(Grammar rules, String source) throws FormatException {
        String[] units = source.split(",");
        assert (units.length > 0);
        if (Character.isLetter(units[0].charAt(0))) {
            HashSet<Rule> ruleSet = new HashSet<Rule>();
            int i = 0;
            while (i < units.length) {
                Rule rule = rules.getRule(units[i]);
                if (rule == null) {
                    throw new FormatException("Error in rule set boundary specification '%s': no rule '%s' in grammar", source, units[i]);
                }
                ruleSet.add(rule);
                ++i;
            }
            return new RuleSetBoundary(ruleSet);
        }
        if (units.length != 2) {
            throw new FormatException("Wrong graph size boundary specification '%s': wrong number of arguments", source);
        }
        try {
            int start = Integer.parseInt(units[0]);
            if (start < 0) {
                throw new FormatException("Wrong graph size boundary specification '%s': negative start size %d", source, start);
            }
            int step = Integer.parseInt(units[1]);
            if (step <= 0) {
                throw new FormatException("Wrong graph size boundary specification '%s': non-positive step size %d", source, step);
            }
            return new GraphNodeSizeBoundary(start, step);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FormatException("Wrong graph size boundary specification '%s': arguments are not numbers", source);
        }
    }
}

