/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.encode;

import groove.explore.encode.EncodedType;
import groove.explore.encode.EncodedTypeEditor;
import groove.explore.encode.StringEditor;
import groove.explore.result.Predicate;
import groove.grammar.Grammar;
import groove.grammar.Rule;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.lts.GraphState;

public class EncodedRuleFormula
implements EncodedType<Predicate<GraphState>, String> {
    private String text;
    private int i;
    private int last_i;
    private Grammar ruleSystem;

    @Override
    public EncodedTypeEditor<Predicate<GraphState>, String> createEditor(GrammarModel grammar) {
        return new StringEditor<Predicate<GraphState>>(grammar, "ruleName; !P; P||Q; P&&Q; P->Q", "", 30);
    }

    @Override
    public Predicate<GraphState> parse(Grammar rules, String text) throws FormatException {
        this.text = text;
        this.i = 0;
        this.last_i = this.text.length() - 1;
        this.ruleSystem = rules;
        Predicate<GraphState> predicate = this.parseFormula();
        this.ruleSystem = null;
        if (this.i <= this.last_i) {
            throw new FormatException("Unable to consume the entire input.", new Object[0]);
        }
        return predicate;
    }

    private void skipSpaces() {
        while (this.i <= this.last_i && this.text.charAt(this.i) == ' ') {
            ++this.i;
        }
    }

    private boolean parseLiteral(String literal) {
        int upto_i = this.i + literal.length() - 1;
        if (upto_i > this.last_i) {
            return false;
        }
        if (this.text.substring(this.i, upto_i + 1).equals(literal)) {
            this.i = upto_i + 1;
            return true;
        }
        return false;
    }

    private Predicate<GraphState> parseRule() throws FormatException {
        int start_i = this.i;
        while (this.i <= this.last_i && this.text.charAt(this.i) != '(' && this.text.charAt(this.i) != ')' && this.text.charAt(this.i) != '>' && this.text.charAt(this.i) != '|' && this.text.charAt(this.i) != '&' && this.text.charAt(this.i) != ' ' && this.text.charAt(this.i) != '!') {
            ++this.i;
        }
        if (this.i == start_i) {
            throw new FormatException("Expected a rule name at character index " + this.i + " .", new Object[0]);
        }
        String ruleName = this.text.substring(start_i, this.i);
        Rule rule = this.ruleSystem.getRule(ruleName);
        if (rule == null) {
            throw new FormatException("'" + ruleName + "' is not an enabled rule in the loaded grammar.", new Object[0]);
        }
        return new Predicate.RuleApplicable(rule);
    }

    private Predicate<GraphState> parseFormula() throws FormatException {
        this.skipSpaces();
        if (this.parseLiteral("(")) {
            this.skipSpaces();
            int bracket_open_index = this.i - 1;
            Predicate<GraphState> predicate = this.parseFormula();
            this.skipSpaces();
            if (!this.parseLiteral(")")) {
                throw new FormatException("Unable to find the closing bracket for the open bracket at index " + bracket_open_index + ".", new Object[0]);
            }
            return predicate;
        }
        if (this.parseLiteral("!")) {
            this.skipSpaces();
            Predicate<GraphState> predicate = this.parseFormula();
            return new Predicate.Not<GraphState>(predicate);
        }
        Predicate<GraphState> P = this.parseRule();
        this.skipSpaces();
        if (this.parseLiteral("&&")) {
            Predicate<GraphState> Q = this.parseFormula();
            return new Predicate.And<GraphState>(P, Q);
        }
        if (this.parseLiteral("||")) {
            Predicate<GraphState> Q = this.parseFormula();
            return new Predicate.Or<GraphState>(P, Q);
        }
        if (this.parseLiteral("->")) {
            Predicate<GraphState> Q = this.parseFormula();
            return new Predicate.Implies<GraphState>(P, Q);
        }
        return P;
    }
}

