/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.encode;

import groove.explore.ParsableValue;
import groove.explore.encode.EncodedType;
import groove.explore.encode.EncodedTypeEditor;
import groove.explore.encode.Serialized;
import groove.explore.encode.Template;
import groove.explore.encode.TemplateListener;
import groove.grammar.Grammar;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.gui.layout.SpringUtilities;
import groove.io.HTMLConverter;
import groove.util.Version;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class TemplateList<A>
implements EncodedType<A, Serialized> {
    private final ArrayList<Template<A>> templates = new ArrayList(15);
    private final String typeIdentifier;
    private final String typeToolTip;
    private Set<? extends ParsableValue> mask;

    public TemplateList(String typeIdentifier, String typeToolTip) {
        this.typeIdentifier = typeIdentifier;
        this.typeToolTip = typeToolTip;
    }

    public String getTypeIdentifier() {
        return this.typeIdentifier;
    }

    public void setMask(Set<? extends ParsableValue> mask) {
        this.mask = mask;
        Iterator<Template<A>> iter = this.templates.iterator();
        while (iter.hasNext()) {
            if (mask.contains(iter.next().getValue())) continue;
            iter.remove();
        }
    }

    protected void addTemplate(Template<A> template) {
        if (this.mask == null || this.mask.contains(template.getValue())) {
            boolean fresh = this.templates.add(template);
            assert (fresh);
        }
    }

    @Override
    public EncodedTypeEditor<A, Serialized> createEditor(GrammarModel grammar) {
        return new TemplateListEditor(grammar);
    }

    @Override
    public A parse(Grammar rules, Serialized source) throws FormatException {
        for (Template<A> template : this.templates) {
            if (!template.getKeyword().equals(source.getKeyword())) continue;
            return template.parse(rules, source);
        }
        StringBuffer error = new StringBuffer();
        error.append("Unknown keyword '" + source.getKeyword() + "' for the " + this.typeIdentifier + ".\n");
        error.append("Expected one of the following keywords:");
        for (Template<A> template : this.templates) {
            error.append(" '");
            error.append(template.getKeyword());
            error.append("'");
        }
        error.append(".");
        throw new FormatException(error.toString(), new Object[0]);
    }

    public Serialized parseCommandline(String text) {
        for (Template<A> template : this.templates) {
            Serialized result = template.parseCommandline(text);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String[] describeCommandlineGrammar() {
        String[] desc = new String[this.templates.size()];
        int index = 0;
        for (Template<A> template : this.templates) {
            desc[index] = template.describeCommandlineGrammar();
            ++index;
        }
        return desc;
    }

    private class TemplateListEditor<X>
    extends EncodedTypeEditor<X, Serialized>
    implements ListSelectionListener {
        private final Map<String, EncodedTypeEditor<A, Serialized>> editors;
        private ArrayList<String> templateKeywords;
        private JList nameSelector;
        private JPanel infoPanel;

        public TemplateListEditor(GrammarModel grammar) {
            super(grammar, new SpringLayout());
            this.editors = new TreeMap();
            this.extractFromTemplates();
            this.addHeaderText();
            this.addListPanel();
            this.addInfoPanel();
            SpringUtilities.makeCompactGrid(this, 3, 1, 0, 0, 0, 3);
            this.refresh();
        }

        @Override
        public void refresh() {
            for (EncodedTypeEditor editor : this.editors.values()) {
                editor.refresh();
            }
            int nrTemplates = TemplateList.this.templates.size();
            ArrayList<String> templateNames = new ArrayList<String>(nrTemplates);
            for (Template template : TemplateList.this.templates) {
                if (!Version.isDevelopmentVersion() && template.getValue().isDevelopment()) continue;
                String templateName = template.getName();
                if (template.getValue().isDefault(this.getGrammar())) {
                    templateName = HTMLConverter.HTML_TAG.on(HTMLConverter.STRONG_TAG.on(String.valueOf(templateName) + " (default)"));
                }
                templateNames.add(templateName);
            }
            int selected = this.nameSelector.getSelectedIndex();
            this.nameSelector.removeListSelectionListener(this);
            this.nameSelector.setListData(templateNames.toArray());
            if (selected >= 0) {
                this.nameSelector.setSelectedIndex(selected);
            }
            this.nameSelector.addListSelectionListener(this);
        }

        private void extractFromTemplates() {
            int nrTemplates = TemplateList.this.templates.size();
            this.templateKeywords = new ArrayList(nrTemplates);
            for (Template template : TemplateList.this.templates) {
                if (!Version.isDevelopmentVersion() && template.getValue().isDevelopment()) continue;
                this.templateKeywords.add(template.getKeyword());
                this.editors.put(template.getKeyword(), template.createEditor(this.getGrammar()));
            }
        }

        private void addHeaderText() {
            JLabel headerText = new JLabel("<HTML><B><FONT color=green>Select " + TemplateList.this.typeIdentifier + ":");
            headerText.setToolTipText(TemplateList.this.typeToolTip);
            this.add(headerText);
        }

        private void addListPanel() {
            this.nameSelector = new JList();
            this.nameSelector.setSelectionMode(0);
            this.nameSelector.setSelectedIndex(0);
            JScrollPane listScroller = new JScrollPane(this.nameSelector);
            listScroller.setPreferredSize(new Dimension(350, 200));
            this.add(listScroller);
        }

        private void addInfoPanel() {
            this.infoPanel = new JPanel(new CardLayout());
            this.infoPanel.setPreferredSize(new Dimension(350, 200));
            this.infoPanel.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 255)));
            for (String keyword : this.templateKeywords) {
                this.infoPanel.add((Component)this.editors.get(keyword), keyword);
            }
            this.add(this.infoPanel);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedIndex = this.nameSelector.getSelectedIndex();
            String selectedKeyword = this.templateKeywords.get(selectedIndex);
            CardLayout cards = (CardLayout)this.infoPanel.getLayout();
            cards.show(this.infoPanel, selectedKeyword);
            this.notifyTemplateListeners();
        }

        @Override
        public void addTemplateListener(TemplateListener listener) {
            super.addTemplateListener(listener);
            for (EncodedTypeEditor editor : this.editors.values()) {
                editor.addTemplateListener(listener);
            }
        }

        @Override
        public void removeTemplateListener(TemplateListener listener) {
            for (EncodedTypeEditor editor : this.editors.values()) {
                editor.removeTemplateListener(listener);
            }
            super.removeTemplateListener(listener);
        }

        @Override
        public Serialized getCurrentValue() {
            Serialized result = null;
            int selectedIndex = this.nameSelector.getSelectedIndex();
            if (selectedIndex >= 0) {
                String selectedKeyword = this.templateKeywords.get(selectedIndex);
                result = this.editors.get(selectedKeyword).getCurrentValue();
            }
            return result;
        }

        @Override
        public void setCurrentValue(Serialized value) {
            if (this.templateKeywords.contains(value.getKeyword())) {
                this.editors.get(value.getKeyword()).setCurrentValue(value);
                this.nameSelector.setSelectedIndex(this.templateKeywords.indexOf(value.getKeyword()));
                CardLayout cards = (CardLayout)this.infoPanel.getLayout();
                cards.show(this.infoPanel, value.getKeyword());
            }
        }
    }
}

