/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.strategy;

import groove.explore.strategy.SymbolicStrategy;
import groove.lts.GraphState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class RemoteStrategy
extends SymbolicStrategy {
    private String host;
    private HttpURLConnection conn;
    private Writer out;
    private BufferedReader in;

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    protected GraphState computeNextState() {
        GraphState state = null;
        state = this.strategy.computeNextState();
        if (state != null) {
            this.sts.toLocation(this.sts.hostGraphToLocation(state.getGraph()));
        } else {
            this.send(this.getSTS().toJSON());
        }
        return state;
    }

    private void connect() {
        System.out.println("Connecting...");
        try {
            URL url = new URL(this.host);
            this.conn = (HttpURLConnection)url.openConnection();
            this.conn.setDoOutput(true);
            this.conn.setRequestMethod("POST");
            this.conn.setReadTimeout(50000);
            this.conn.setRequestProperty("Content-Type", "application/json");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void send(String message) {
        System.out.println("Sending JSON message...");
        System.out.println(message);
        try {
            String line;
            if (this.conn == null || this.out == null) {
                this.connect();
                this.out = new OutputStreamWriter(this.conn.getOutputStream());
            }
            this.out.write(message);
            this.out.flush();
            if (this.conn.getResponseCode() != 200) {
                this.in = new BufferedReader(new InputStreamReader(this.conn.getErrorStream()));
                System.out.println("Error in connection to: " + this.conn.getURL());
            } else if (this.in == null) {
                this.in = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
            }
            StringBuffer buf = new StringBuffer();
            while ((line = this.in.readLine()) != null) {
                buf.append(line);
            }
            System.out.println(buf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

