/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.strategy;

import groove.explore.result.Acceptor;
import groove.explore.strategy.ExploreIterator;
import groove.lts.GTS;
import groove.lts.GraphState;

public abstract class Strategy {
    private final ExploreIterator iterator;
    private boolean interrupted;
    private GTS gts;
    private GraphState startState;
    private Acceptor acceptor;
    private GraphState lastState;

    protected Strategy() {
        this.iterator = (ExploreIterator)((Object)this);
    }

    protected Strategy(ExploreIterator iterator) {
        this.iterator = iterator;
    }

    public final void setGTS(GTS gts) {
        this.gts = gts;
        this.startState = null;
    }

    public final void setState(GraphState state) {
        this.startState = state;
    }

    public final void setAcceptor(Acceptor listener) {
        this.acceptor = listener;
    }

    public final void play() {
        this.play(null);
    }

    public final void play(Halter halter) {
        this.iterator.prepare(this.gts, this.startState, this.acceptor);
        this.collectKnownStates();
        this.interrupted = false;
        while (!(halter != null && halter.halt() || !this.iterator.hasNext() || this.testInterrupted())) {
            this.lastState = this.iterator.doNext();
        }
        this.iterator.finish();
    }

    private void collectKnownStates() {
        for (GraphState graphState : this.gts.nodeSet()) {
            graphState.setFlag(GraphState.Flag.KNOWN, true);
        }
    }

    public final boolean isInterrupted() {
        return this.interrupted;
    }

    private boolean testInterrupted() {
        boolean result = this.interrupted;
        if (!result) {
            result = this.interrupted = Thread.currentThread().isInterrupted();
        }
        return result;
    }

    public final GraphState getLastState() {
        return this.lastState;
    }

    public final String getMessage() {
        StringBuilder result = new StringBuilder();
        if (this.isInterrupted()) {
            result.append("Exploration interrupted. ");
        }
        result.append(this.acceptor.getMessage());
        return result.toString();
    }

    public static interface Halter {
        public boolean halt();
    }
}

