/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.util;

import groove.explore.Exploration;
import groove.grammar.Rule;
import groove.grammar.host.HostFactory;
import groove.graph.AGraph;
import groove.graph.iso.IsoChecker;
import groove.graph.iso.PartitionRefiner;
import groove.lts.AbstractGraphState;
import groove.lts.GTS;
import groove.lts.GTSAdapter;
import groove.lts.GraphNextState;
import groove.lts.GraphState;
import groove.lts.GraphTransition;
import groove.lts.MatchApplier;
import groove.lts.MatchCollector;
import groove.transform.Record;
import groove.util.Groove;
import groove.util.Reporter;
import groove.util.cache.AbstractCacheHolder;
import groove.util.cache.CacheReference;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Formatter;

public class ExplorationStatistics {
    private static final int BYTES_PER_KB = 1024;
    private long startTime;
    private long endTime;
    private long startUsedMemory;
    private final GTS gts;
    private StringBuilder sb;
    private Formatter fm;
    private int verbosity = 1;
    private StatisticsListener statisticsListener = new StatisticsListener();

    public ExplorationStatistics(GTS gts) {
        assert (gts != null);
        this.gts = gts;
        this.sb = new StringBuilder();
        this.fm = new Formatter(this.sb);
    }

    public final GTS getGts() {
        return this.gts;
    }

    public void configureForSimulator() {
        this.setVerbosity(2);
    }

    public void configureForGenerator(int verbosity) {
        this.setVerbosity(verbosity);
    }

    public void start() {
        Runtime runTime = Runtime.getRuntime();
        runTime.runFinalization();
        runTime.gc();
        this.startUsedMemory = runTime.totalMemory() - runTime.freeMemory();
        if (this.getVerbosity() > 0) {
            this.gts.addLTSListener(this.statisticsListener);
        }
        this.startTime = System.currentTimeMillis();
    }

    public void stop() {
        this.endTime = System.currentTimeMillis();
        if (this.getVerbosity() == 2) {
            this.gts.removeLTSListener(this.statisticsListener);
        }
    }

    public long getRunningTime() {
        return this.endTime - this.startTime;
    }

    public void setVerbosity(int verbosity) {
        this.verbosity = verbosity;
    }

    public int getVerbosity() {
        return this.verbosity;
    }

    private String percentage(double fraction) {
        int percentage = (int)(fraction * 1000.0 + 0.5);
        String result = percentage / 10 + "." + percentage % 10 + "%";
        if (result.length() == 4) {
            return " " + result;
        }
        return result;
    }

    private void println() {
        this.sb.append("\n");
    }

    private void println(String text) {
        this.sb.append(String.valueOf(text) + "\n");
    }

    protected void printf(String text, Object ... args) {
        this.fm.format(text, args);
    }

    private String getCacheReconstructionDistribution() {
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        boolean finished = false;
        int incarnation = 1;
        while (!finished) {
            int size = CacheReference.getFrequency(incarnation);
            boolean bl = finished = size == 0;
            if (!finished) {
                sizes.add(size);
            }
            ++incarnation;
        }
        return Groove.toString(sizes.toArray());
    }

    private void reportLTS() {
        int openTransientStateCount = this.statisticsListener.getOpenTransientStateCount();
        int closedTransientStateCount = this.statisticsListener.getClosedTransientStateCount();
        int realStateCount = this.gts.nodeCount() - openTransientStateCount - closedTransientStateCount;
        this.println("\n\tStates:\t\t\t" + realStateCount);
        int openRealStateCount = this.gts.openStateCount() - openTransientStateCount;
        if (openRealStateCount > 0) {
            this.println("\tExplored:\t\t" + (realStateCount - openRealStateCount));
        }
        int partialTransitionCount = this.statisticsListener.getPartialTransitionCount();
        int realTransitionCount = this.gts.edgeCount() - partialTransitionCount;
        this.println("\tTransitions:\t" + realTransitionCount);
    }

    private void reportGraphStatistics() {
        this.printf("\n\tGraphs:\n\t\tModifiable:\t\t%d%n", AGraph.getModifiableGraphCount());
        this.printf("\t\tFrozen:\t\t\t%d%n", AbstractGraphState.getFrozenGraphCount());
        this.printf("\t\tBytes/state:\t%.1f%n", this.gts.getBytesPerState());
    }

    private void reportTransitionStatistics() {
        this.printf("\n\tTransitions:\n\t\tReused:\t\t%d%n", MatchCollector.getEventReuse());
        this.printf("\t\tConfluent:\t%d%n", MatchApplier.getConfluentDiamondCount());
        this.printf("\t\tEvents:\t\t%d%n", Record.getEventCount());
        this.printf("\tCoanchor reuse:\t%d/%d%n", HostFactory.getNormaliseGain(), HostFactory.getNormaliseCount());
    }

    private void reportIsomorphism() {
        int predicted = IsoChecker.getTotalCheckCount();
        int falsePos2 = IsoChecker.getDistinctSimCount();
        int falsePos1 = falsePos2 + IsoChecker.getDistinctSizeCount() + IsoChecker.getDistinctCertsCount();
        int equalGraphCount = IsoChecker.getEqualGraphsCount();
        int equalCertsCount = IsoChecker.getEqualCertsCount();
        int equalSimCount = IsoChecker.getEqualSimCount();
        int intCertOverlap = IsoChecker.getIntCertOverlap();
        this.printf("\n\tIsomorphism:\n\t\tPredicted:\t\t\t%d (-%d)%n", predicted, intCertOverlap);
        this.printf("\t\tFalse pos 1:\t\t%d (%s)%n", falsePos1, this.percentage((double)falsePos1 / (double)(predicted - intCertOverlap)));
        this.printf("\t\tFalse pos 2:\t\t%d (%s)%n", falsePos2, this.percentage((double)falsePos2 / (double)(predicted - intCertOverlap)));
        this.println("\t\tEqual graphs:\t\t" + equalGraphCount);
        this.println("\t\tEqual certificates:\t" + equalCertsCount);
        this.println("\t\tEqual simulation:\t" + equalSimCount);
        this.println("\t\tIterations:\t\t\t" + PartitionRefiner.getIterateCount());
        this.println("\t\tSymmetry breaking:\t" + PartitionRefiner.getSymmetryBreakCount());
    }

    private void reportGraphElementStatistics() {
        HostFactory factory = this.gts.getHostFactory();
        this.printf("\n\tFactory node count:\t%d%n", factory.getNodeCount());
        this.printf("\tFactory edge count:\t%d%n", factory.getEdgeCount());
        double nodeAvg = (double)this.statisticsListener.getNodeCount() / (double)this.gts.nodeCount();
        this.printf("\tAverage:\n\t\tNodes per state:\t%3.1f%n", nodeAvg);
        double edgeAvg = (double)this.statisticsListener.getEdgeCount() / (double)this.gts.edgeCount();
        this.printf("\t\tEdges per state:\t%3.1f%n", edgeAvg);
    }

    private void reportCacheStatistics() {
        this.println("\n\tCaches:\n\t\tCreated:\t\t" + CacheReference.getCreateCount());
        this.println("\t\tCleared:\t\t" + CacheReference.getClearCount());
        this.println("\t\tCollected:\t\t" + CacheReference.getCollectCount());
        this.println("\t\tReconstructed:\t" + CacheReference.getIncarnationCount());
        this.println("\t\tDistribution:\t" + this.getCacheReconstructionDistribution());
    }

    private void reportTime() {
        long total = this.endTime - this.startTime;
        long matching = Rule.getMatchingTime();
        long running = Exploration.getRunningTime();
        long overhead = total - running;
        long isoChecking = IsoChecker.getTotalTime();
        long generateTime = MatchApplier.getGenerateTime();
        long building = generateTime - isoChecking;
        long measuring = Reporter.getReportTime();
        long transforming = running - matching - isoChecking - building - measuring;
        this.println("\nTime (ms):\t" + total);
        this.println("\tMatching:\t\t\t" + matching + "\t" + this.percentage((double)matching / (double)total));
        this.println("\tTransforming:\t\t" + transforming + "\t" + this.percentage((double)transforming / (double)total));
        this.println("\tIso checking:\t\t" + isoChecking + "\t" + this.percentage((double)isoChecking / (double)total));
        if (this.getVerbosity() == 2) {
            long certifying = IsoChecker.getCertifyingTime();
            long equalCheck = IsoChecker.getEqualCheckTime();
            long certCheck = IsoChecker.getCertCheckTime();
            long simCheck = IsoChecker.getSimCheckTime();
            this.println("\t\tCertifying:\t\t" + certifying + "\t" + this.percentage((double)certifying / (double)isoChecking));
            this.println("\t\tEquals check:\t" + equalCheck + "\t" + this.percentage((double)equalCheck / (double)isoChecking));
            this.println("\t\tCert check:\t\t" + certCheck + "\t" + this.percentage((double)certCheck / (double)isoChecking));
            this.println("\t\tSim check:\t\t" + simCheck + "\t" + this.percentage((double)simCheck / (double)isoChecking));
        }
        this.println("\tBuilding GTS:\t\t" + building + "\t" + this.percentage((double)building / (double)total));
        this.println("\tMeasuring:\t\t\t" + measuring + "\t" + this.percentage((double)measuring / (double)total));
        this.println("\tInitialization:\t\t" + overhead + "\t" + this.percentage((double)overhead / (double)total));
    }

    private void reportSpace(long usedMemory) {
        this.println("\nSpace (kB):\t" + usedMemory / 1024L);
    }

    private void report() {
        this.sb.delete(0, this.sb.length());
        if (this.getVerbosity() == 2) {
            StringWriter sw = new StringWriter();
            Reporter.report(new PrintWriter(sw));
            this.sb.append(sw.toString());
            this.println();
            this.println("===============================================================================");
            this.println();
        }
        if (this.getVerbosity() > 0) {
            Runtime runTime = Runtime.getRuntime();
            for (GraphState graphState : this.gts.nodeSet()) {
                if (graphState instanceof AbstractCacheHolder) {
                    ((AbstractCacheHolder)((Object)graphState)).clearCache();
                }
                if (!(graphState instanceof GraphNextState)) continue;
                ((AbstractCacheHolder)((Object)((GraphNextState)graphState).getEvent())).clearCache();
            }
            System.runFinalization();
            System.gc();
            long l = runTime.totalMemory() - runTime.freeMemory();
            this.println("Statistics:");
            this.reportLTS();
            if (this.getVerbosity() == 2) {
                this.reportGraphStatistics();
                this.reportTransitionStatistics();
                this.reportIsomorphism();
                this.reportGraphElementStatistics();
                this.reportCacheStatistics();
            }
            this.reportTime();
            this.reportSpace(l - this.startUsedMemory);
        }
    }

    public String getReport() {
        this.report();
        return this.sb.toString();
    }

    private static class StatisticsListener
    extends GTSAdapter {
        private int nodeCount;
        private int edgeCount;
        private int closedTransientStateCount;
        private int openTransientStateCount;
        private int partialTransitionCount;

        StatisticsListener() {
        }

        @Override
        public void addUpdate(GTS gts, GraphState state) {
            this.nodeCount += state.getGraph().nodeCount();
            this.edgeCount += state.getGraph().edgeCount();
            if (state.isTransient()) {
                if (state.isClosed()) {
                    ++this.closedTransientStateCount;
                } else {
                    ++this.openTransientStateCount;
                }
            }
        }

        @Override
        public void addUpdate(GTS gts, GraphTransition transition) {
            if (transition.isPartial()) {
                ++this.partialTransitionCount;
            }
        }

        @Override
        public void statusUpdate(GTS graph, GraphState explored, GraphState.Flag flag) {
            if (flag == GraphState.Flag.CLOSED) {
                if (explored.getCtrlState().isTransient()) {
                    --this.openTransientStateCount;
                }
                if (explored.isTransient()) {
                    ++this.closedTransientStateCount;
                }
            }
        }

        public int getNodeCount() {
            return this.nodeCount;
        }

        public int getEdgeCount() {
            return this.edgeCount;
        }

        public int getClosedTransientStateCount() {
            return this.closedTransientStateCount;
        }

        public int getOpenTransientStateCount() {
            return this.openTransientStateCount;
        }

        public int getPartialTransitionCount() {
            return this.partialTransitionCount;
        }
    }
}

