/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar;

import groove.control.CtrlPar;
import groove.grammar.AnchorFactory;
import groove.grammar.Rule;
import groove.grammar.rule.Anchor;
import groove.grammar.rule.AnchorKey;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleGraph;
import groove.grammar.rule.RuleNode;
import groove.util.collect.CollectionOfCollections;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class DefaultAnchorFactory
implements AnchorFactory {
    private static DefaultAnchorFactory prototype = new DefaultAnchorFactory();

    private DefaultAnchorFactory() {
    }

    @Override
    public Anchor newAnchor(Rule rule) {
        RuleGraph lhs = rule.lhs();
        LinkedHashSet<AnchorKey> result = new LinkedHashSet<AnchorKey>();
        HashSet<RuleNode> colorNodes = new HashSet<RuleNode>(rule.getColorMap().keySet());
        colorNodes.retainAll(lhs.nodeSet());
        result.addAll(colorNodes);
        result.addAll(Arrays.asList(rule.getEraserNodes()));
        result.addAll(rule.getModifierEnds());
        for (Rule subrule : rule.getSubRules()) {
            if (!subrule.isModifying()) continue;
            Anchor subruleAnchor = new Anchor(subrule.getAnchor());
            subruleAnchor.retainAll(this.getAnchorKeys(lhs));
            result.addAll(subruleAnchor);
        }
        result.addAll(Arrays.asList(rule.getCreatorVars()));
        RuleEdge[] ruleEdgeArray = rule.getEraserEdges();
        int subruleAnchor = ruleEdgeArray.length;
        int n = 0;
        while (n < subruleAnchor) {
            RuleEdge eraserEdge = ruleEdgeArray[n];
            result.add(eraserEdge);
            result.addAll(eraserEdge.getVars());
            ++n;
        }
        result.addAll(Arrays.asList(rule.getEraserEdges()));
        if (rule.isTop()) {
            Set<RuleNode> hiddenPars = rule.getHiddenPars();
            if (hiddenPars != null) {
                result.addAll(hiddenPars);
            }
            List<CtrlPar.Var> ruleSig = rule.getSignature();
            for (CtrlPar.Var rulePar : ruleSig) {
                if (rulePar.isCreator()) continue;
                result.add(rulePar.getRuleNode());
            }
        }
        return new Anchor((Collection<? extends AnchorKey>)result);
    }

    private Collection<Object> getAnchorKeys(RuleGraph graph) {
        return new CollectionOfCollections<Object>(graph.nodeSet(), graph.edgeSet(), graph.varSet());
    }

    public static DefaultAnchorFactory getInstance() {
        return prototype;
    }
}

