/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar;

import groove.automaton.RegAut;
import groove.grammar.Action;
import groove.grammar.Condition;
import groove.grammar.Grammar;
import groove.grammar.GrammarProperties;
import groove.grammar.Rule;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.model.ResourceModel;
import groove.grammar.model.RuleModel;
import groove.grammar.rule.DefaultRuleNode;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleElement;
import groove.grammar.rule.RuleGraph;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeElement;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeNode;
import groove.graph.Node;
import groove.util.Groove;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RuleDependencies {
    private final Collection<Rule> rules;
    private final GrammarProperties properties;
    private final TypeGraph typeGraph;
    private final Map<Rule, Set<Rule>> enablerMap = new HashMap<Rule, Set<Rule>>();
    private final Map<Rule, Set<Rule>> disablerMap = new HashMap<Rule, Set<Rule>>();
    private final Map<Rule, Set<Rule>> enabledMap = new HashMap<Rule, Set<Rule>>();
    private final Map<Rule, Set<Rule>> disabledMap = new HashMap<Rule, Set<Rule>>();
    private final Map<Rule, Set<TypeElement>> positiveMap = new HashMap<Rule, Set<TypeElement>>();
    private final Map<Rule, Set<TypeElement>> negativeMap = new HashMap<Rule, Set<TypeElement>>();
    private final Map<Rule, Set<TypeElement>> consumedMap = new HashMap<Rule, Set<TypeElement>>();
    private final Map<Rule, Set<TypeElement>> producedMap = new HashMap<Rule, Set<TypeElement>>();

    public static void main(String[] args) {
        try {
            GrammarModel grammar = Groove.loadGrammar(args[0]);
            RuleDependencies data = new RuleDependencies(grammar);
            data.collectCharacteristics();
            List<Rule> rules = RuleDependencies.getRules(grammar);
            for (Rule rule : rules) {
                System.out.println("Rule " + rule.getFullName() + ":");
                System.out.println("Positive labels: " + data.positiveMap.get(rule));
                System.out.println("Negative labels: " + data.negativeMap.get(rule));
                System.out.println("Consumed labels: " + data.consumedMap.get(rule));
                System.out.println("Produced labels: " + data.producedMap.get(rule));
                ArrayList<String> enablerNames = new ArrayList<String>();
                for (Action action : data.getEnablers(rule)) {
                    enablerNames.add(action.getFullName());
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Action action : data.getDisablers(rule)) {
                    arrayList.add(action.getFullName());
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (Action action : data.getEnableds(rule)) {
                    arrayList2.add(action.getFullName());
                }
                ArrayList<String> arrayList3 = new ArrayList<String>();
                for (Action action : data.getDisableds(rule)) {
                    arrayList3.add(action.getFullName());
                }
                ArrayList<String> arrayList4 = new ArrayList<String>();
                for (Action action : rules) {
                    arrayList4.add(action.getFullName());
                }
                arrayList4.removeAll(enablerNames);
                arrayList4.removeAll(arrayList);
                System.out.println("Enabled rules:  " + arrayList2);
                System.out.println("Disabled rules: " + arrayList3);
                System.out.println("Enablers:       " + enablerNames);
                System.out.println("Disablers:      " + arrayList);
                System.out.println("No dependency:  " + arrayList4);
                System.out.println();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List<Rule> getRules(GrammarModel grammar) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (ResourceModel<?> ruleModel : grammar.getResourceSet(ResourceKind.RULE)) {
            try {
                if (!ruleModel.isEnabled()) continue;
                result.add((Rule)((RuleModel)ruleModel).toResource());
            }
            catch (FormatException formatException) {}
        }
        return result;
    }

    public RuleDependencies(GrammarModel grammar) {
        this.rules = RuleDependencies.getRules(grammar);
        this.properties = grammar.getProperties();
        this.typeGraph = grammar.getTypeGraph();
    }

    public RuleDependencies(Grammar ruleSystem) {
        this.rules = ruleSystem.getAllRules();
        this.properties = ruleSystem.getProperties();
        this.typeGraph = ruleSystem.getTypeGraph();
    }

    Map<Rule, Set<Rule>> getEnablerMap() {
        if (!this.rules.isEmpty() && this.enablerMap.isEmpty()) {
            this.collectCharacteristics();
        }
        return Collections.unmodifiableMap(this.enablerMap);
    }

    Map<Rule, Set<Rule>> getDisablerMap() {
        if (!this.rules.isEmpty() && this.disablerMap.isEmpty()) {
            this.collectCharacteristics();
        }
        return Collections.unmodifiableMap(this.disablerMap);
    }

    public Set<Rule> getEnableds(Rule rule) {
        if (!this.rules.isEmpty() && this.enabledMap.isEmpty()) {
            this.collectCharacteristics();
        }
        return this.enabledMap.get(rule);
    }

    public Set<Rule> getEnablers(Rule rule) {
        if (!this.rules.isEmpty() && this.enablerMap.isEmpty()) {
            this.collectCharacteristics();
        }
        return this.enablerMap.get(rule);
    }

    public Set<Rule> getDisableds(Rule rule) {
        if (!this.rules.isEmpty() && this.disabledMap.isEmpty()) {
            this.collectCharacteristics();
        }
        return this.disabledMap.get(rule);
    }

    public Set<Rule> getDisablers(Rule rule) {
        if (!this.rules.isEmpty() && this.disablerMap.isEmpty()) {
            this.collectCharacteristics();
        }
        return this.disablerMap.get(rule);
    }

    Map<Rule, Set<TypeElement>> getConsumedMap() {
        if (!this.rules.isEmpty() && this.consumedMap.isEmpty()) {
            this.collectCharacteristics();
        }
        return Collections.unmodifiableMap(this.consumedMap);
    }

    Map<Rule, Set<TypeElement>> getNegativeMap() {
        if (!this.rules.isEmpty() && this.negativeMap.isEmpty()) {
            this.collectCharacteristics();
        }
        return Collections.unmodifiableMap(this.negativeMap);
    }

    Map<Rule, Set<TypeElement>> getPositiveMap() {
        if (!this.rules.isEmpty() && this.positiveMap.isEmpty()) {
            this.collectCharacteristics();
        }
        return Collections.unmodifiableMap(this.positiveMap);
    }

    Map<Rule, Set<TypeElement>> getProducedElementMap() {
        if (!this.rules.isEmpty() && this.producedMap.isEmpty()) {
            this.collectCharacteristics();
        }
        return Collections.unmodifiableMap(this.producedMap);
    }

    void collectCharacteristics() {
        for (Rule rule : this.rules) {
            HashSet<TypeElement> consumedSet = new HashSet<TypeElement>();
            this.consumedMap.put(rule, Collections.unmodifiableSet(consumedSet));
            HashSet<TypeElement> producedSet = new HashSet<TypeElement>();
            this.producedMap.put(rule, Collections.unmodifiableSet(producedSet));
            this.collectRuleCharacteristics(rule, consumedSet, producedSet);
            HashSet<TypeElement> positiveSet = new HashSet<TypeElement>();
            this.positiveMap.put(rule, Collections.unmodifiableSet(positiveSet));
            HashSet<TypeElement> negativeSet = new HashSet<TypeElement>();
            this.negativeMap.put(rule, Collections.unmodifiableSet(negativeSet));
            this.collectConditionCharacteristics(rule.getCondition(), positiveSet, negativeSet);
        }
        this.init(this.enablerMap);
        this.init(this.disablerMap);
        this.init(this.enabledMap);
        this.init(this.disabledMap);
        for (Rule rule : this.rules) {
            Set<TypeElement> positives = this.positiveMap.get(rule);
            Set<TypeElement> negatives = this.negativeMap.get(rule);
            for (Rule depRule : this.rules) {
                int depRulePriority;
                int rulePriority;
                HashSet depConsumes;
                HashSet depProduces = new HashSet(this.producedMap.get(depRule));
                if (depProduces.removeAll(positives)) {
                    this.addEnabling(depRule, rule);
                }
                if ((depConsumes = new HashSet(this.consumedMap.get(depRule))).removeAll(negatives)) {
                    this.addEnabling(depRule, rule);
                }
                if ((rulePriority = rule.getPriority()) < (depRulePriority = depRule.getPriority())) {
                    this.addEnabling(depRule, rule);
                }
                if ((depProduces = new HashSet(this.producedMap.get(depRule))).removeAll(negatives)) {
                    this.addDisabling(depRule, rule);
                }
                if (!(depConsumes = new HashSet(this.consumedMap.get(depRule))).removeAll(positives)) continue;
                this.addDisabling(depRule, rule);
            }
        }
    }

    void collectRuleCharacteristics(Rule rule, Set<TypeElement> consumed, Set<TypeElement> produced) {
        RuleGraph lhs = rule.lhs();
        RuleElement[] ruleElementArray = rule.getEraserNodes();
        int n = ruleElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            DefaultRuleNode eraserNode = ruleElementArray[n2];
            this.addEraserNode(consumed, eraserNode, lhs);
            ++n2;
        }
        ruleElementArray = rule.getEraserEdges();
        n = ruleElementArray.length;
        n2 = 0;
        while (n2 < n) {
            RuleElement eraserEdge = ruleElementArray[n2];
            consumed.addAll(this.getMatchingTypes((RuleEdge)eraserEdge));
            ++n2;
        }
        ruleElementArray = rule.getCreatorNodes();
        n = ruleElementArray.length;
        n2 = 0;
        while (n2 < n) {
            RuleElement creatorNode = ruleElementArray[n2];
            produced.add(creatorNode.getType());
            ++n2;
        }
        ruleElementArray = rule.getCreatorEdges();
        n = ruleElementArray.length;
        n2 = 0;
        while (n2 < n) {
            RuleElement creatorEdge = ruleElementArray[n2];
            produced.addAll(this.getMatchingTypes((RuleEdge)creatorEdge));
            ++n2;
        }
        for (RuleEdge merger : rule.getLhsMergers()) {
            this.addMerger(produced, consumed, lhs, merger);
        }
        for (RuleEdge merger : rule.getRhsMergers()) {
            this.addMerger(produced, consumed, lhs, merger);
        }
        for (Rule subRule : rule.getSubRules()) {
            this.collectRuleCharacteristics(subRule, consumed, produced);
        }
    }

    private void addEraserNode(Set<TypeElement> consumed, RuleNode eraserNode, RuleGraph lhs) {
        TypeNode eraserType = eraserNode.getType();
        HashSet<TypeNode> sharpEraserTypes = new HashSet<TypeNode>();
        if (eraserNode.isSharp()) {
            sharpEraserTypes.add(eraserType);
        } else {
            sharpEraserTypes.addAll(this.typeGraph.getSubtypes(eraserType));
        }
        this.addSharpEraserTypes(consumed, sharpEraserTypes);
        if (this.properties.isCheckDangling()) {
            for (RuleEdge edge : lhs.edgeSet(eraserNode)) {
                consumed.addAll(this.getMatchingTypes(edge));
            }
        }
    }

    private void addSharpEraserTypes(Set<TypeElement> consumed, Set<TypeNode> nodeTypes) {
        consumed.addAll(nodeTypes);
        if (!this.properties.isCheckDangling()) {
            HashSet<TypeNode> superTypes = new HashSet<TypeNode>();
            for (TypeNode type : nodeTypes) {
                superTypes.addAll(type.getSupertypes());
            }
            HashSet incidentEdgeTypes = new HashSet();
            for (TypeNode superType : superTypes) {
                incidentEdgeTypes.addAll(this.typeGraph.inEdgeSet(superType));
                incidentEdgeTypes.addAll(this.typeGraph.outEdgeSet(superType));
            }
            consumed.addAll(incidentEdgeTypes);
        }
    }

    private void addMerger(Set<TypeElement> produced, Set<TypeElement> consumed, RuleGraph lhs, RuleEdge merger) {
        this.addEraserNode(consumed, (RuleNode)merger.source(), lhs);
        for (RuleEdge sourceEdge : lhs.edgeSet((Node)merger.source())) {
            Set<TypeElement> types = this.getMatchingTypes(sourceEdge);
            consumed.addAll(types);
            produced.addAll(types);
        }
    }

    void collectConditionCharacteristics(Condition cond, Set<TypeElement> positive, Set<TypeElement> negative) {
        if (cond.hasPattern()) {
            this.collectPatternCharacteristics(cond, positive, negative);
        }
        for (Condition subCond : cond.getSubConditions()) {
            HashSet<TypeElement> subPositives = new HashSet<TypeElement>();
            HashSet<TypeElement> subNegatives = new HashSet<TypeElement>();
            this.collectConditionCharacteristics(subCond, subPositives, subNegatives);
            Condition.Op subOp = subCond.getOp();
            if (subOp != Condition.Op.NOT) {
                positive.addAll(subPositives);
                negative.addAll(subNegatives);
            }
            if (subOp != Condition.Op.FORALL && subOp != Condition.Op.NOT) continue;
            negative.addAll(subPositives);
            positive.addAll(subNegatives);
        }
    }

    void collectPatternCharacteristics(Condition cond, Set<TypeElement> positive, Set<TypeElement> negative) {
        RuleGraph pattern = cond.getPattern();
        HashSet<RuleNode> isolatedNodes = new HashSet<RuleNode>(pattern.nodeSet());
        isolatedNodes.removeAll(cond.getRoot().nodeSet());
        HashSet<RuleEdge> freshTargetEdges = new HashSet<RuleEdge>(pattern.edgeSet());
        freshTargetEdges.removeAll(cond.getRoot().edgeSet());
        for (RuleEdge edge : freshTargetEdges) {
            Set<TypeElement> affectedSet;
            RuleLabel label = (RuleLabel)edge.label();
            boolean presence = true;
            if (label.isNeg()) {
                affectedSet = negative;
                presence = false;
            } else {
                affectedSet = positive;
                presence = !label.getMatchExpr().isAcceptsEmptyWord();
            }
            affectedSet.addAll(this.getMatchingTypes(edge));
            if (!presence) continue;
            isolatedNodes.remove(edge.source());
            isolatedNodes.remove(edge.target());
        }
        if (this.properties.isCheckDangling() && cond.hasRule()) {
            RuleGraph rhs = cond.getRule().rhs();
            for (RuleNode lhsNode : pattern.nodeSet()) {
                if (rhs.containsNode(lhsNode)) continue;
                HashSet danglingEdges = new HashSet();
                danglingEdges.addAll(this.typeGraph.inEdgeSet(lhsNode.getType()));
                danglingEdges.addAll(this.typeGraph.outEdgeSet(lhsNode.getType()));
                for (RuleEdge rhsEdge : pattern.edgeSet(lhsNode)) {
                    TypeEdge edgeType = rhsEdge.getType();
                    if (edgeType == null) continue;
                    danglingEdges.remove(edgeType);
                }
                negative.addAll(danglingEdges);
            }
        }
        for (RuleNode isolatedNode : isolatedNodes) {
            positive.addAll(isolatedNode.getType().getSubtypes());
        }
    }

    void addEnabling(Rule enabler, Rule enabled) {
        this.add(this.enablerMap, enabled, enabler);
        this.add(this.enabledMap, enabler, enabled);
    }

    void addDisabling(Rule disabler, Rule disabled) {
        this.add(this.disablerMap, disabled, disabler);
        this.add(this.disabledMap, disabler, disabled);
    }

    void init(Map<Rule, Set<Rule>> map) {
        for (Rule rule : this.rules) {
            map.put(rule, this.createRuleSet());
        }
    }

    <S, T> void add(Map<S, Set<T>> map, S key, T value) {
        Set<T> valueSet = map.get(key);
        valueSet.add(value);
    }

    private Set<TypeElement> getMatchingTypes(RuleEdge edge) {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        TypeEdge edgeType = edge.getType();
        if (edgeType == null) {
            RuleLabel label = (RuleLabel)edge.label();
            if (label.isNeg()) {
                label = label.getNegOperand().toLabel();
            }
            RegAut labelAut = label.getAutomaton(this.typeGraph);
            result.addAll(labelAut.getAlphabet());
            if (labelAut.isAcceptsEmptyWord()) {
                result.addAll(this.typeGraph.nodeSet());
            }
        } else {
            result.addAll(this.typeGraph.getSubtypes(edgeType));
        }
        return result;
    }

    protected Set<Rule> createRuleSet() {
        return new HashSet<Rule>();
    }
}

