/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.aspect;

import groove.algebra.Operator;
import groove.algebra.SignatureKind;
import groove.grammar.aspect.Aspect;
import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectElement;
import groove.grammar.aspect.AspectKind;
import groove.grammar.aspect.AspectLabel;
import groove.grammar.model.FormatError;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.FormatException;
import groove.grammar.type.LabelPattern;
import groove.grammar.type.TypeLabel;
import groove.graph.ANode;
import groove.graph.EdgeRole;
import groove.graph.GraphRole;
import groove.graph.plain.PlainLabel;
import groove.util.Fixable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class AspectNode
extends ANode
implements AspectElement,
Fixable {
    private final GraphRole graphRole;
    private final List<AspectLabel> nodeLabels = new ArrayList<AspectLabel>();
    private boolean allFixed;
    private Aspect aspect;
    private Aspect attr;
    private Aspect param;
    private Aspect id;
    private Aspect color;
    private Aspect edge;
    private Aspect imported;
    private AspectEdge nestingLevelEdge;
    private AspectEdge nestingParentEdge;
    private AspectNode matchCount;
    private List<AspectNode> argNodes;
    private AspectEdge operatorEdge;
    private final FormatErrorSet errors = new FormatErrorSet();

    public AspectNode(int nr, GraphRole graphRole) {
        super(nr);
        assert (graphRole.inGrammar());
        this.graphRole = graphRole;
    }

    public GraphRole getGraphRole() {
        return this.graphRole;
    }

    @Override
    protected int computeHashCode() {
        return this.getNumber() ^ this.getClass().hashCode();
    }

    @Override
    protected String getToStringPrefix() {
        return "n";
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj != null && obj.getClass().equals(this.getClass()) && ((AspectNode)obj).getNumber() == this.getNumber();
    }

    @Override
    public boolean setFixed() {
        boolean result;
        boolean bl = result = !this.isFixed();
        if (result) {
            this.allFixed = true;
            try {
                this.checkAspects();
                if (this.getAttrKind() == AspectKind.PRODUCT) {
                    this.testSignature();
                }
            }
            catch (FormatException exc) {
                this.addErrors(exc.getErrors());
            }
        }
        return result;
    }

    private void testSignature() throws FormatException {
        Operator operator;
        if (this.argNodes == null) {
            throw new FormatException("Product node has no arguments", this);
        }
        if (this.operatorEdge == null) {
            throw new FormatException("Product node has no operators", this);
        }
        int arity = this.argNodes.size();
        if (arity != (operator = this.operatorEdge.getOperator()).getArity()) {
            throw new FormatException("Product node arity %d is incorrect for operator %s", arity, operator, this);
        }
        int i = 0;
        while (i < arity) {
            AspectNode argNode = this.argNodes.get(i);
            if (argNode == null) {
                throw new FormatException("Missing product argument %d", i, this);
            }
            ++i;
        }
    }

    @Override
    public boolean isFixed() {
        return this.allFixed;
    }

    @Override
    public void testFixed(boolean fixed) {
        if (this.allFixed != fixed) {
            throw new IllegalStateException(String.format("Aspect node %d should%s be fixed", this.getNumber(), fixed ? "" : " not"));
        }
    }

    @Override
    public AspectNode clone() {
        return this.clone(this.getNumber());
    }

    public AspectNode clone(int newNr) {
        AspectNode result = new AspectNode(newNr, this.getGraphRole());
        for (AspectLabel label : this.nodeLabels) {
            result.setAspects(label);
        }
        return result;
    }

    public AspectNode relabel(TypeLabel oldLabel, TypeLabel newLabel) {
        AspectNode result = new AspectNode(this.getNumber(), this.getGraphRole());
        boolean isNew = false;
        for (AspectLabel oldNodeLabel : this.nodeLabels) {
            AspectLabel newNodeLabel = oldNodeLabel.relabel(oldLabel, newLabel);
            newNodeLabel.setFixed();
            isNew |= newNodeLabel != oldNodeLabel;
            result.setAspects(newNodeLabel);
        }
        if (!isNew) {
            result = this;
        }
        return result;
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public FormatErrorSet getErrors() {
        return this.errors;
    }

    private void addErrors(Collection<FormatError> errors) {
        for (FormatError error : errors) {
            this.errors.add(error.extend(this));
        }
    }

    public void setAspects(AspectLabel label) {
        assert (label.isFixed());
        assert (this.graphRole == label.getGraphRole());
        this.testFixed(false);
        this.nodeLabels.add(label);
        if (label.hasErrors()) {
            this.addErrors(label.getErrors());
        } else {
            try {
                for (Aspect aspect : label.getAspects()) {
                    this.addAspect(aspect);
                }
            }
            catch (FormatException exc) {
                this.errors.addAll(exc.getErrors());
            }
        }
    }

    private void checkAspects() throws FormatException {
        if (this.graphRole == GraphRole.RULE) {
            if (!this.hasAspect()) {
                this.setAspect(AspectKind.READER.getAspect());
            }
            if (this.hasAttrAspect() && this.getKind() != AspectKind.READER && this.getKind() != AspectKind.EMBARGO) {
                throw new FormatException("Conflicting aspects %s and %s", this.getAttrAspect(), this.getAspect());
            }
        } else {
            if (this.getKind().isRole()) {
                throw new FormatException("Node aspect %s only allowed in rules", this.getAspect(), this);
            }
            if (!this.hasAspect()) {
                this.setAspect(AspectKind.DEFAULT.getAspect());
            }
        }
        if (this.hasImport()) {
            if (this.getAttrKind().hasSignature()) {
                throw new FormatException("Can't import data type", new Object[]{this.getAttrKind(), this});
            }
            if (this.getKind() == AspectKind.ABSTRACT) {
                throw new FormatException("Can't abstract an imported type", new Object[]{this.getAttrKind(), this});
            }
        }
        if (!this.hasAttrAspect()) {
            this.setAttrAspect(AspectKind.DEFAULT.getAspect());
        }
    }

    private void addAspect(Aspect value) throws FormatException {
        assert (value.isForNode(this.getGraphRole())) : String.format("Inappropriate node aspect %s", value, this);
        AspectKind kind = value.getKind();
        if (kind.isAttrKind()) {
            if (this.hasAttrAspect() && !this.isAttrConsistent(this.getAttrAspect(), value)) {
                throw new FormatException("Conflicting node aspects %s and %s", new Object[]{this.getAttrKind(), value, this});
            }
            this.setAttrAspect(value);
        } else if (kind.isParam()) {
            if (this.hasParam()) {
                throw new FormatException("Conflicting parameter aspects %s and %s", this.param, value, this);
            }
            this.setParam(value);
        } else if (kind == AspectKind.ID) {
            this.setId(value);
        } else if (kind == AspectKind.EDGE) {
            this.setEdge(value);
        } else if (kind == AspectKind.COLOR) {
            this.setColor(value);
        } else if (kind == AspectKind.IMPORT) {
            this.setImport(value);
        } else {
            if (this.hasAspect()) {
                throw new FormatException("Conflicting node aspects %s and %s", this.getAspect(), value, this);
            }
            if (kind.isRole() && value.getContent() != null) {
                throw new FormatException("Node aspect %s should not have quantifier name", value, this);
            }
            this.setAspect(value);
            if (kind.isQuantifier() && value.getContent() != null) {
                this.setId(value.getContentString());
            }
        }
    }

    private boolean isAttrConsistent(Aspect one, Aspect two) {
        assert (one.getKind().isAttrKind() && two.getKind().isAttrKind());
        if (one.equals(two)) {
            return true;
        }
        if (!one.getKind().hasSignature() || !two.getKind().hasSignature()) {
            return false;
        }
        if (!one.getKind().equals((Object)two.getKind())) {
            return false;
        }
        return one.getContent() == null || two.getContent() == null;
    }

    public void inferInAspect(AspectEdge edge) throws FormatException {
        assert (edge.target() == this);
        this.testFixed(false);
        if (edge.getAttrKind() == AspectKind.ARGUMENT) {
            if (!this.hasAttrAspect()) {
                throw new FormatException("Target node of %s-edge should be attribute", edge.label(), this);
            }
        } else if (edge.getKind() == AspectKind.CONNECT) {
            if (this.getKind() != AspectKind.EMBARGO) {
                throw new FormatException("Target node of %s-edge should be embargo", edge.label(), this);
            }
        } else {
            if ((edge.isNestedAt() || edge.isNestedIn()) && !this.getKind().isQuantifier()) {
                throw new FormatException("Target node of %s-edge should be quantifier", edge.label(), this);
            }
            if (edge.isNestedCount()) {
                if (this.getAttrKind() != AspectKind.INT) {
                    throw new FormatException("Target node of %s-edge should be int-node", edge.label(), this);
                }
            } else if (edge.isOperator()) {
                Operator operator = edge.getOperator();
                Aspect operType = Aspect.getAspect(operator.getResultType().getName());
                AspectKind operKind = operType.getKind();
                if (!this.hasAttrAspect()) {
                    throw new FormatException("Target node of %s-edge should be %s-attribute", new Object[]{edge.label(), operKind, this});
                }
                if (this.getAttrKind() != operKind) {
                    throw new FormatException("Inferred type %s of %s-target conflicts with declared type %s", new Object[]{operKind, edge.label(), this.getAttrKind(), this});
                }
            }
        }
    }

    private void setDataType(SignatureKind type) throws FormatException {
        assert (!this.isFixed());
        Aspect newType = Aspect.getAspect(type.getName());
        assert (newType.getKind().hasSignature());
        this.setAttrAspect(newType);
    }

    public void inferOutAspect(AspectEdge edge) throws FormatException {
        assert (edge.source() == this);
        this.testFixed(false);
        AspectLabel edgeLabel = (AspectLabel)edge.label();
        if (edge.getKind() == AspectKind.CONNECT) {
            if (this.getKind() != AspectKind.EMBARGO) {
                throw new FormatException("Source node of %s-edge should be embargo", edge.label(), this);
            }
        } else if (edge.isNestedAt()) {
            if (this.getKind().isMeta()) {
                throw new FormatException("Source node of %s-edge should be rule element", edgeLabel, this);
            }
            this.nestingLevelEdge = edge;
        } else if (edge.isNestedIn()) {
            if (!this.getKind().isQuantifier()) {
                throw new FormatException("Source node of %s-edge should be quantifier", edgeLabel, this);
            }
            HashSet<AspectNode> grandparents = new HashSet<AspectNode>();
            AspectNode parent = (AspectNode)edge.target();
            while (parent != null) {
                grandparents.add(parent);
                parent = parent.getNestingParent();
            }
            if (grandparents.contains(this)) {
                throw new FormatException("Circularity in the nesting hierarchy", this);
            }
            this.nestingParentEdge = edge;
        } else if (edge.isNestedCount()) {
            if (this.getKind() != AspectKind.FORALL && this.getKind() != AspectKind.FORALL_POS) {
                throw new FormatException("Source node of %s-edge should be universal quantifier", edgeLabel, this);
            }
            this.matchCount = (AspectNode)edge.target();
        } else if (edge.isArgument()) {
            List<SignatureKind> paramTypes;
            if (!this.hasAttrAspect()) {
                this.setAttrAspect(AspectKind.PRODUCT.getAspect());
            } else if (this.getAttrKind() != AspectKind.PRODUCT) {
                throw new FormatException("Source node of %s-edge should be product node", edgeLabel, this);
            }
            if (this.argNodes == null) {
                this.argNodes = new ArrayList<AspectNode>();
            }
            int index = edge.getArgument();
            while (this.argNodes.size() <= index) {
                this.argNodes.add(null);
            }
            if (this.argNodes.get(index) != null) {
                throw new FormatException("Duplicate %s-edge", edge.label(), this);
            }
            this.argNodes.set(index, (AspectNode)edge.target());
            if (this.operatorEdge != null && index < (paramTypes = this.operatorEdge.getOperator().getParamTypes()).size()) {
                ((AspectNode)edge.target()).setDataType(paramTypes.get(index));
            }
        } else if (edge.isOperator()) {
            if (!this.hasAttrAspect()) {
                this.setAttrAspect(AspectKind.PRODUCT.getAspect());
            } else if (this.getAttrKind() != AspectKind.PRODUCT) {
                throw new FormatException("Source node of %s-edge should be product node", edgeLabel, this);
            }
            if (this.operatorEdge == null) {
                this.operatorEdge = edge;
            } else {
                if (!this.operatorEdge.getOperator().getParamTypes().equals(edge.getOperator().getParamTypes())) {
                    throw new FormatException("Conflicting operator signatures for %s and %s", this.operatorEdge.label(), edgeLabel, this);
                }
                if (!this.hasErrors() && this.argNodes != null) {
                    int i = 0;
                    while (i < this.argNodes.size()) {
                        AspectNode argNode = this.argNodes.get(i);
                        if (argNode != null) {
                            SignatureKind paramType = this.operatorEdge.getOperator().getParamTypes().get(i);
                            argNode.setDataType(paramType);
                        }
                        ++i;
                    }
                }
            }
        } else if (edge.getKind() == AspectKind.ABSTRACT && edge.getTypeLabel().getRole() == EdgeRole.NODE_TYPE) {
            this.setAspect(AspectKind.ABSTRACT.getAspect());
        }
    }

    public List<AspectLabel> getNodeLabels() {
        return this.nodeLabels;
    }

    public List<PlainLabel> getPlainLabels() {
        ArrayList<PlainLabel> result = new ArrayList<PlainLabel>();
        for (AspectLabel label : this.nodeLabels) {
            result.add(PlainLabel.createLabel(label.toString()));
        }
        return result;
    }

    private void setAttrAspect(Aspect newAttr) throws FormatException {
        AspectKind attrKind = newAttr.getKind();
        assert (attrKind == AspectKind.DEFAULT || attrKind.isAttrKind()) : String.format("Aspect %s is not attribute-related", newAttr);
        if (!this.hasAttrAspect()) {
            this.attr = newAttr;
        } else {
            if (this.getAttrKind() != attrKind) {
                throw new FormatException("Conflicting (inferred) types %s and %s", new Object[]{this.getAttrKind(), attrKind, this});
            }
            if (!this.getAttrAspect().hasContent() && newAttr.hasContent()) {
                this.attr = newAttr;
            } else if (this.getAttrAspect().hasContent() && newAttr.hasContent()) {
                throw new FormatException("Conflicting (inferred) types %s and %s", new Object[]{this.getAttrKind(), attrKind, this});
            }
        }
    }

    @Override
    public Aspect getAttrAspect() {
        return this.attr;
    }

    @Override
    public boolean hasAttrAspect() {
        return this.attr != null && this.attr.getKind() != AspectKind.DEFAULT;
    }

    @Override
    public AspectKind getAttrKind() {
        return this.hasAttrAspect() ? this.getAttrAspect().getKind() : AspectKind.DEFAULT;
    }

    public List<AspectNode> getArgNodes() {
        this.testFixed(true);
        return this.argNodes;
    }

    private void setParam(Aspect type) {
        assert (type.getKind() == AspectKind.DEFAULT || type.getKind().isParam()) : String.format("Aspect %s is not a parameter", type);
        this.param = type;
    }

    public Aspect getParam() {
        return this.param;
    }

    public boolean hasParam() {
        return this.param != null;
    }

    private void setId(String id) throws FormatException {
        Aspect idAspect = AspectKind.ID.getAspect().newInstance(id, GraphRole.RULE);
        this.setId(idAspect);
    }

    private void setId(Aspect id) throws FormatException {
        assert (id.getKind() == AspectKind.ID) : String.format("Aspect %s is not an identifier", id);
        if (this.id != null) {
            throw new FormatException("Duplicate node identifiers %s and %s", this.id.getClass(), id.getContent());
        }
        this.id = id;
    }

    public Aspect getId() {
        return this.id;
    }

    public boolean hasId() {
        return this.id != null;
    }

    private void setColor(Aspect color) throws FormatException {
        assert (color.getKind() == AspectKind.COLOR) : String.format("Aspect %s is not a color", color);
        if (this.color != null) {
            throw new FormatException("Duplicate colour specification", new Object[0]);
        }
        this.color = color;
    }

    public Aspect getColor() {
        return this.color;
    }

    public boolean hasColor() {
        return this.color != null;
    }

    private void setImport(Aspect imported) throws FormatException {
        assert (imported.getKind() == AspectKind.IMPORT) : String.format("Aspect %s is not an import", imported);
        if (this.imported != null) {
            throw new FormatException("Duplicate import specification", new Object[0]);
        }
        this.imported = imported;
    }

    public Aspect getImport() {
        return this.imported;
    }

    public boolean hasImport() {
        return this.imported != null;
    }

    public boolean isEdge() {
        return this.getEdge() != null;
    }

    private void setEdge(Aspect edge) throws FormatException {
        assert (edge.getKind() == AspectKind.EDGE) : String.format("Aspect %s is not an edge declaration", edge);
        if (this.edge != null) {
            throw new FormatException("Duplicate edge pattern specification", new Object[0]);
        }
        this.edge = edge;
    }

    public Aspect getEdge() {
        return this.edge;
    }

    public LabelPattern getEdgePattern() {
        return this.isEdge() ? (LabelPattern)this.getEdge().getContent() : null;
    }

    public AspectKind getParamKind() {
        assert (this.hasParam());
        return this.hasParam() ? this.getParam().getKind() : AspectKind.DEFAULT;
    }

    public int getParamNr() {
        return this.hasParam() && this.getParam().hasContent() ? (Integer)this.getParam().getContent() : -1;
    }

    void setAspect(Aspect type) throws FormatException {
        assert (!type.getKind().isAttrKind() && !type.getKind().isParam()) : String.format("Aspect %s is not a valid node type", type);
        if (this.aspect == null) {
            this.aspect = type;
        } else if (!this.aspect.equals(type)) {
            throw new FormatException("Conflicting aspects %s and %s", this.aspect, type, this);
        }
    }

    @Override
    public Aspect getAspect() {
        return this.aspect;
    }

    boolean hasAspect() {
        return this.getAspect() != null;
    }

    @Override
    public AspectKind getKind() {
        return this.hasAspect() ? this.getAspect().getKind() : AspectKind.DEFAULT;
    }

    public AspectNode getNestingLevel() {
        AspectEdge edge = this.getNestingLevelEdge();
        return edge == null ? null : (AspectNode)edge.target();
    }

    public AspectEdge getNestingLevelEdge() {
        return this.nestingLevelEdge;
    }

    public AspectNode getNestingParent() {
        AspectEdge edge = this.getNestingParentEdge();
        return edge == null ? null : (AspectNode)edge.target();
    }

    public AspectEdge getNestingParentEdge() {
        return this.nestingParentEdge;
    }

    public AspectNode getMatchCount() {
        return this.matchCount;
    }

    public String getLevelName() {
        if (this.getKind().isQuantifier()) {
            return (String)this.getAspect().getContent();
        }
        return null;
    }
}

