/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.aspect;

import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.aspect.AspectKind;
import groove.grammar.aspect.AspectNode;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.host.ValueNode;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.AElementMap;
import groove.graph.EdgeRole;
import groove.graph.Graph;
import groove.graph.GraphInfo;
import groove.graph.GraphRole;
import groove.graph.Node;

public class GraphConverter {
    public static AspectGraph toAspect(Graph graph) {
        AspectGraph result = graph instanceof AspectGraph ? (AspectGraph)graph : (graph instanceof HostGraph ? GraphConverter.toAspectMap((HostGraph)graph).getAspectGraph() : (graph instanceof TypeGraph ? GraphConverter.toAspectMap((TypeGraph)graph).getAspectGraph() : AspectGraph.newInstance(graph)));
        return result;
    }

    public static TypeToAspectMap toAspectMap(TypeGraph type) {
        AspectNode nodeImage;
        AspectGraph target = new AspectGraph(type.getName(), GraphRole.TYPE);
        TypeToAspectMap result = new TypeToAspectMap(target);
        for (TypeNode node : type.nodeSet()) {
            nodeImage = (AspectNode)target.addNode(node.getNumber());
            result.putNode(node, nodeImage);
            target.addEdge(nodeImage, node.label().toPrefixedString(), nodeImage);
            if (!node.isAbstract()) continue;
            target.addEdge(nodeImage, AspectKind.ABSTRACT.getPrefix(), nodeImage);
        }
        for (TypeNode node : type.nodeSet()) {
            nodeImage = (AspectNode)result.getNode(node);
            for (TypeNode nodeSuper : node.getSupertypes()) {
                target.addEdge(nodeImage, AspectKind.SUBTYPE.getPrefix(), (AspectNode)result.getNode(nodeSuper));
            }
        }
        for (TypeEdge edge : type.edgeSet()) {
            StringBuilder text = new StringBuilder();
            if (edge.isAbstract()) {
                text.append(AspectKind.ABSTRACT.getPrefix());
            }
            if (edge.isComposite()) {
                text.append(AspectKind.COMPOSITE.getPrefix());
            }
            if (edge.getInMult() != null) {
                text.append(AspectKind.ContentKind.MULTIPLICITY.toString(AspectKind.MULT_IN, edge.getInMult()));
            }
            if (edge.getOutMult() != null) {
                text.append(AspectKind.ContentKind.MULTIPLICITY.toString(AspectKind.MULT_OUT, edge.getOutMult()));
            }
            text.append(edge.text());
            AspectEdge edgeImage = (AspectEdge)target.addEdge((AspectNode)result.getNode((Node)edge.source()), text.toString(), (AspectNode)result.getNode((Node)edge.target()));
            result.putEdge(edge, edgeImage);
        }
        GraphInfo.transfer(type, target, result);
        target.setFixed();
        return result;
    }

    public static HostToAspectMap toAspectMap(HostGraph host) {
        AspectGraph targetGraph = new AspectGraph(host.getName(), GraphRole.HOST);
        HostToAspectMap result = new HostToAspectMap(targetGraph);
        for (HostNode node : host.nodeSet()) {
            if (node instanceof ValueNode) continue;
            AspectNode nodeImage = (AspectNode)targetGraph.addNode(node.getNumber());
            result.putNode(node, nodeImage);
            TypeLabel typeLabel = node.getType().label();
            if (typeLabel == TypeLabel.NODE) continue;
            targetGraph.addEdge(nodeImage, result.mapLabel(typeLabel), nodeImage);
        }
        for (HostEdge edge : host.edgeSet()) {
            String text;
            AspectNode imageTarget;
            String edgeText = edge.label().text();
            AspectNode imageSource = (AspectNode)result.getNode(edge.source());
            if (edge.target() instanceof ValueNode) {
                imageTarget = imageSource;
                String constant = ((ValueNode)edge.target()).getSymbol();
                text = String.valueOf(AspectKind.LET.getPrefix()) + edgeText + "=" + constant;
            } else if (edge.getRole() == EdgeRole.BINARY) {
                imageTarget = (AspectNode)result.getNode(edge.target());
                text = String.valueOf(AspectKind.LITERAL.getPrefix()) + edgeText;
            } else {
                imageTarget = imageSource;
                text = edge.label().toString();
            }
            AspectEdge edgeImage = (AspectEdge)targetGraph.addEdge(imageSource, text, imageTarget);
            result.putEdge(edge, edgeImage);
        }
        GraphInfo.transfer(host, targetGraph, result);
        targetGraph.setFixed();
        return result;
    }

    public static class HostToAspectMap
    extends AElementMap<HostNode, HostEdge, AspectNode, AspectEdge> {
        private final AspectGraph aspectGraph;

        public HostToAspectMap(AspectGraph aspectGraph) {
            super(new AspectGraph.AspectFactory(GraphRole.HOST));
            this.aspectGraph = aspectGraph;
        }

        public AspectGraph getAspectGraph() {
            return this.aspectGraph;
        }
    }

    public static class TypeToAspectMap
    extends AElementMap<TypeNode, TypeEdge, AspectNode, AspectEdge> {
        private final AspectGraph aspectGraph;

        public TypeToAspectMap(AspectGraph aspectGraph) {
            super(new AspectGraph.AspectFactory(GraphRole.TYPE));
            this.aspectGraph = aspectGraph;
        }

        public AspectGraph getAspectGraph() {
            return this.aspectGraph;
        }
    }
}

