/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.groovy;

import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.aspect.AspectLabel;
import groove.grammar.aspect.AspectNode;
import groove.grammar.aspect.AspectParser;
import groove.grammar.model.ResourceKind;
import groove.graph.GraphInfo;
import groove.graph.GraphRole;
import groove.graph.Node;
import groove.gui.SimulatorModel;
import groove.gui.layout.JVertexLayout;
import groove.gui.layout.LayoutMap;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.HashMap;

public class GraphManager {
    private final SimulatorModel simulatorModel;
    private final HashMap<AspectGraph, LayoutMap> layouts;

    public GraphManager(SimulatorModel simulatorModel) {
        this.simulatorModel = simulatorModel;
        this.layouts = new HashMap();
    }

    public AspectGraph createGraph(String name, GraphRole role) {
        switch (role) {
            case HOST: 
            case RULE: 
            case TYPE: {
                break;
            }
            default: {
                return null;
            }
        }
        AspectGraph newGraph = new AspectGraph(name, role);
        this.layouts.put(newGraph, new LayoutMap());
        return newGraph;
    }

    public AspectGraph loadGraph(String name, GraphRole role) {
        AspectGraph result = null;
        switch (role) {
            case HOST: 
            case RULE: 
            case TYPE: {
                result = this.simulatorModel.getStore().getGraphs(ResourceKind.toResource(role)).get(name);
            }
        }
        return result == null ? null : result.clone();
    }

    public boolean doneGraph(AspectGraph graph) {
        if (graph == null) {
            return false;
        }
        LayoutMap layoutMap = this.layouts.remove(graph);
        if (layoutMap != null) {
            GraphInfo.setLayoutMap(graph, layoutMap);
        }
        graph.setFixed();
        try {
            switch (graph.getRole()) {
                case HOST: 
                case RULE: 
                case TYPE: {
                    this.simulatorModel.doAddGraph(ResourceKind.toResource(graph.getRole()), graph, false);
                    return true;
                }
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public AspectNode createNode(AspectGraph graph, String label) {
        if (graph == null) {
            return null;
        }
        String[] labels = label.split("\n");
        AspectNode newNode = new AspectNode(graph.nodeCount(), graph.getRole());
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String sublabel = stringArray[n2];
            AspectLabel alabel = AspectParser.getInstance().parse(sublabel, graph.getRole());
            if (alabel.isEdgeOnly()) {
                AspectEdge newEdge = new AspectEdge(newNode, alabel, newNode);
                graph.addEdgeContext(newEdge);
            } else {
                newNode.setAspects(alabel);
            }
            ++n2;
        }
        graph.addNode(newNode);
        return newNode;
    }

    public AspectNode createNode(AspectGraph graph, String label, Point2D location) {
        if (graph == null) {
            return null;
        }
        AspectNode newNode = this.createNode(graph, label);
        JVertexLayout layout = new JVertexLayout(new Rectangle((int)location.getX(), (int)location.getY(), 60, 20));
        LayoutMap layoutMap = this.layouts.get(graph);
        if (layoutMap == null) {
            layoutMap = GraphInfo.getLayoutMap(graph);
        }
        if (layoutMap != null) {
            layoutMap.putNode((Node)newNode, layout);
        }
        return newNode;
    }

    public AspectEdge createEdge(AspectGraph graph, AspectNode nodeSource, AspectNode nodeTarget, String label) {
        String[] labels;
        if (graph == null) {
            return null;
        }
        AspectEdge resultEdge = null;
        String[] stringArray = labels = label.split("\n");
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String sublabel = stringArray[n2];
            AspectLabel alabel = AspectParser.getInstance().parse(sublabel, graph.getRole());
            if (alabel.isEdgeOnly()) {
                AspectEdge newEdge = new AspectEdge(nodeSource, alabel, nodeTarget);
                graph.addEdgeContext(newEdge);
                if (resultEdge == null) {
                    resultEdge = newEdge;
                }
            }
            ++n2;
        }
        return resultEdge;
    }

    public AspectNode getNode(AspectGraph graph, int id) {
        if (graph == null) {
            return null;
        }
        for (AspectNode node : graph.nodeSet()) {
            if (node.getNumber() != id) continue;
            return node;
        }
        return null;
    }
}

