/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.host;

import groove.algebra.AlgebraFamily;
import groove.grammar.host.DefaultHostGraph;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostEdgeSet;
import groove.grammar.host.HostEdgeStore;
import groove.grammar.host.HostElement;
import groove.grammar.host.HostFactory;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.host.HostNodeSet;
import groove.grammar.model.FormatException;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeLabel;
import groove.graph.AGraph;
import groove.graph.Edge;
import groove.graph.GraphRole;
import groove.graph.Label;
import groove.graph.Node;
import groove.graph.iso.CertificateStrategy;
import groove.transform.DeltaApplier;
import groove.transform.DeltaStore;
import groove.transform.DeltaTarget;
import groove.transform.FrozenDeltaApplier;
import groove.transform.StoredDeltaApplier;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public final class DeltaHostGraph
extends AGraph<HostNode, HostEdge>
implements HostGraph,
Cloneable {
    private HostFactory factory;
    DeltaHostGraph basis;
    StoredDeltaApplier delta;
    HostEdgeSet edgeSet;
    HostEdgeStore<HostNode> nodeEdgeStore;
    HostEdgeStore<HostNode> nodeInEdgeStore;
    HostEdgeStore<HostNode> nodeOutEdgeStore;
    HostEdgeStore<TypeLabel> labelEdgeStore;
    private Reference<CertificateStrategy> certifier;
    private boolean copyData = true;
    private static final int MAX_CHAIN_LENGTH = 25;
    private static final boolean ALIAS_SETS = true;
    private static final DeltaHostGraph copyInstance = new DeltaHostGraph("copy prototype", null, null, true);
    private static final DeltaHostGraph swingInstance = new DeltaHostGraph("swing prototype", null, null, false);

    private DeltaHostGraph(String name, HostElement[] delta, HostFactory factory, boolean copyData) {
        super(name);
        this.factory = factory;
        this.basis = null;
        this.copyData = copyData;
        this.delta = new FrozenDeltaApplier(delta);
        this.setFixed();
    }

    private DeltaHostGraph(String name, DeltaHostGraph basis, DeltaApplier delta, boolean copyData) {
        super(name);
        this.basis = basis;
        this.factory = basis.getFactory();
        this.copyData = copyData;
        this.delta = delta == null || delta instanceof StoredDeltaApplier ? (StoredDeltaApplier)delta : new DeltaStore(delta);
        this.setFixed();
    }

    @Override
    public GraphRole getRole() {
        return GraphRole.HOST;
    }

    @Override
    public DefaultHostGraph clone() {
        return new DefaultHostGraph(this, null);
    }

    @Override
    public HostGraph clone(AlgebraFamily family) {
        return new DefaultHostGraph(this, family);
    }

    @Override
    public HostGraph newGraph(String name) {
        return new DefaultHostGraph(name, this.getFactory());
    }

    public DeltaHostGraph newGraph(String name, DeltaHostGraph graph, DeltaApplier applier) {
        return new DeltaHostGraph(name, graph, applier, this.copyData);
    }

    public DeltaHostGraph newGraph(String name, HostElement[] elements, HostFactory factory) {
        return new DeltaHostGraph(name, elements, factory, this.copyData);
    }

    @Override
    public HostNode addNode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public HostNode addNode(int nr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HostEdge addEdge(HostNode source, Label label, HostNode target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addNode(HostNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeEdge(HostEdge edge) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addEdge(HostEdge edge) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeNode(HostNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<HostNode> nodeSet() {
        if (this.nodeEdgeStore == null) {
            this.initData();
        }
        Set<HostNode> result = this.nodeEdgeStore.keySet();
        return result;
    }

    public HostEdgeSet edgeSet() {
        if (this.edgeSet == null) {
            this.initData();
        }
        HostEdgeSet result = this.edgeSet;
        return result;
    }

    public HostEdgeSet inEdgeSet(Node node) {
        HostEdgeSet result = (HostEdgeSet)this.getInEdgeStore().get(node);
        return result != null ? result : this.createEdgeSet(result);
    }

    private HostEdgeStore<HostNode> getInEdgeStore() {
        if (this.nodeInEdgeStore == null) {
            this.initData();
            if (this.nodeInEdgeStore == null) {
                this.nodeInEdgeStore = this.computeInEdgeStore();
            }
        }
        return this.nodeInEdgeStore;
    }

    private HostEdgeStore<HostNode> computeInEdgeStore() {
        HostEdgeStore<HostNode> result = new HostEdgeStore<HostNode>();
        for (Map.Entry nodeEdgeEntry : this.nodeEdgeStore.entrySet()) {
            HostNode key = (HostNode)nodeEdgeEntry.getKey();
            HostEdgeSet inEdges = this.createEdgeSet(null);
            for (HostEdge edge : (HostEdgeSet)nodeEdgeEntry.getValue()) {
                if (!edge.target().equals(key)) continue;
                inEdges.add(edge);
            }
            result.put(key, inEdges);
        }
        return result;
    }

    public HostEdgeSet outEdgeSet(Node node) {
        HostEdgeSet result = (HostEdgeSet)this.getOutEdgeStore().get(node);
        return result != null ? result : this.createEdgeSet(result);
    }

    private HostEdgeStore<HostNode> getOutEdgeStore() {
        if (this.nodeOutEdgeStore == null) {
            this.initData();
            if (this.nodeOutEdgeStore == null) {
                this.nodeOutEdgeStore = this.computeOutEdgeStore();
            }
        }
        return this.nodeOutEdgeStore;
    }

    private HostEdgeStore<HostNode> computeOutEdgeStore() {
        HostEdgeStore<HostNode> result = new HostEdgeStore<HostNode>();
        for (Map.Entry nodeEdgeEntry : this.nodeEdgeStore.entrySet()) {
            HostNode key = (HostNode)nodeEdgeEntry.getKey();
            HostEdgeSet inEdges = this.createEdgeSet(null);
            for (HostEdge edge : (HostEdgeSet)nodeEdgeEntry.getValue()) {
                if (!edge.source().equals(key)) continue;
                inEdges.add(edge);
            }
            result.put(key, inEdges);
        }
        return result;
    }

    public HostEdgeSet edgeSet(Label label) {
        HostEdgeSet result = (HostEdgeSet)this.getLabelEdgeStore().get(label);
        return result != null ? result : this.createEdgeSet(result);
    }

    private HostEdgeStore<TypeLabel> getLabelEdgeStore() {
        if (this.labelEdgeStore == null) {
            this.initData();
            if (this.labelEdgeStore == null) {
                this.labelEdgeStore = this.computeLabelEdgeStore();
            }
        }
        return this.labelEdgeStore;
    }

    private HostEdgeStore<TypeLabel> computeLabelEdgeStore() {
        HostEdgeStore<TypeLabel> result = new HostEdgeStore<TypeLabel>();
        for (HostEdge edge : this.edgeSet()) {
            HostEdgeSet edges = (HostEdgeSet)result.get(edge.label());
            if (edges == null) {
                edges = this.createEdgeSet(null);
                result.put(edge.label(), edges);
            }
            edges.add(edge);
        }
        return result;
    }

    public HostEdgeSet edgeSet(Node node) {
        HostEdgeSet result = (HostEdgeSet)this.getNodeEdgeStore().get(node);
        return result != null ? result : this.createEdgeSet(result);
    }

    private HostEdgeStore<HostNode> getNodeEdgeStore() {
        if (this.nodeEdgeStore == null) {
            this.initData();
        }
        return this.nodeEdgeStore;
    }

    private void initData() {
        if (!this.isDataInitialised()) {
            assert (this.nodeEdgeStore == null);
            assert (this.labelEdgeStore == null);
            if (this.basis == null) {
                this.edgeSet = this.createEdgeSet(null);
                this.nodeEdgeStore = new HostEdgeStore();
                this.delta.applyDelta(new SwingTarget());
            } else {
                Stack<DeltaHostGraph> basisChain = new Stack<DeltaHostGraph>();
                basisChain.push(this);
                DeltaHostGraph backward = this.basis;
                while (backward.basis != null && !backward.isDataInitialised()) {
                    basisChain.push(backward);
                    backward = backward.basis;
                }
                backward.initData();
                int deltaSize = 0;
                int totalDelta = 0;
                int chainLength = 0;
                while (!basisChain.isEmpty()) {
                    DeltaHostGraph forward = (DeltaHostGraph)basisChain.pop();
                    DataTarget target = forward.basis.getDataTarget(chainLength, totalDelta);
                    if (target instanceof CopyTarget) {
                        deltaSize = 0;
                        totalDelta = 0;
                        chainLength = 0;
                    }
                    totalDelta += (deltaSize += forward.delta.size());
                    ++chainLength;
                    forward.delta.applyDelta(target);
                    target.install(forward);
                }
            }
        }
    }

    private boolean isDataInitialised() {
        return this.edgeSet != null;
    }

    private DataTarget getDataTarget(int chainLength, int totalDelta) {
        assert (this.isDataInitialised());
        DataTarget result = this.exceedsCopyBound(chainLength, totalDelta) ? new CopyTarget(!this.copyData) : (this.copyData ? new CopyTarget(false) : new SwingTarget());
        return result;
    }

    private boolean exceedsCopyBound(int chainLength, int totalDelta) {
        return totalDelta > 2 * this.size() || chainLength > 25;
    }

    HostEdgeSet createEdgeSet(Set<HostEdge> edgeSet) {
        return HostEdgeSet.newInstance(edgeSet);
    }

    HostNodeSet createNodeSet(Set<HostNode> nodeSet) {
        return HostNodeSet.newInstance(nodeSet);
    }

    @Override
    public boolean hasCertifier(boolean strong) {
        return this.certifier != null && this.certifier.get() != null;
    }

    @Override
    public CertificateStrategy getCertifier(boolean strong) {
        CertificateStrategy result;
        CertificateStrategy certificateStrategy = result = this.certifier == null ? null : this.certifier.get();
        if (result == null || result.getStrength() != strong) {
            result = AGraph.getCertificateFactory().newInstance(this, strong);
            this.certifier = new WeakReference<CertificateStrategy>(result);
        }
        return result;
    }

    @Override
    protected boolean isTypeCorrect(Node node) {
        return node instanceof HostNode && !this.getFactory().addNode(node);
    }

    @Override
    protected boolean isTypeCorrect(Edge edge) {
        return edge instanceof HostEdge && !this.getFactory().addEdge((HostEdge)edge);
    }

    @Override
    public HostFactory getFactory() {
        return this.factory;
    }

    @Override
    public TypeGraph getTypeGraph() {
        return this.getFactory().getTypeFactory().getGraph();
    }

    @Override
    public HostGraph retype(TypeGraph typeGraph) throws FormatException {
        return typeGraph.analyzeHost(this).createImage(this.getName());
    }

    public static DeltaHostGraph getInstance(boolean copyData) {
        return copyData ? copyInstance : swingInstance;
    }

    private class CopyTarget
    extends DataTarget {
        private final HostNodeSet freshSourceKeys;
        private final HostNodeSet freshTargetKeys;
        private final Set<TypeLabel> freshLabelKeys;

        public CopyTarget(boolean deepCopy) {
            DeltaHostGraph graph = DeltaHostGraph.this;
            this.edgeSet = DeltaHostGraph.this.createEdgeSet(graph.edgeSet);
            this.nodeEdgeStore = this.copy(graph.nodeEdgeStore, deepCopy);
            this.freshSourceKeys = DeltaHostGraph.this.createNodeSet(deepCopy ? this.nodeEdgeStore.keySet() : null);
            this.freshTargetKeys = DeltaHostGraph.this.createNodeSet(deepCopy ? this.nodeEdgeStore.keySet() : null);
            if (graph.labelEdgeStore != null) {
                this.labelEdgeStore = this.copy(graph.labelEdgeStore, deepCopy);
                this.freshLabelKeys = new HashSet<TypeLabel>();
                if (deepCopy) {
                    this.freshLabelKeys.addAll(this.labelEdgeStore.keySet());
                }
            } else {
                this.freshLabelKeys = null;
            }
            if (graph.nodeInEdgeStore != null) {
                this.nodeInEdgeStore = this.copy(graph.nodeInEdgeStore, deepCopy);
            }
            if (graph.nodeOutEdgeStore != null) {
                this.nodeOutEdgeStore = this.copy(graph.nodeOutEdgeStore, deepCopy);
            }
        }

        private <K> HostEdgeStore<K> copy(HostEdgeStore<K> source, boolean deepCopy) {
            return new HostEdgeStore<K>(source, deepCopy);
        }

        @Override
        public boolean addEdge(HostEdge edge) {
            HostNode source = edge.source();
            HostNode target = edge.target();
            boolean refreshSource = this.freshSourceKeys.add(source);
            boolean refreshTarget = this.freshTargetKeys.add(target);
            boolean refreshLabel = this.freshLabelKeys != null && this.freshLabelKeys.add(edge.label());
            return super.addEdge(edge, refreshSource, refreshTarget, refreshLabel);
        }

        @Override
        public boolean removeEdge(HostEdge edge) {
            HostNode source = edge.source();
            HostNode target = edge.target();
            boolean refreshSource = this.freshSourceKeys.add(source);
            boolean refreshTarget = this.freshTargetKeys.add(target);
            boolean refreshLabel = this.freshLabelKeys != null && this.freshLabelKeys.add(edge.label());
            return super.removeEdge(edge, refreshSource, refreshTarget, refreshLabel);
        }
    }

    private abstract class DataTarget
    implements DeltaTarget {
        HostEdgeSet edgeSet;
        HostEdgeStore<HostNode> nodeEdgeStore;
        HostEdgeStore<HostNode> nodeInEdgeStore;
        HostEdgeStore<HostNode> nodeOutEdgeStore;
        HostEdgeStore<TypeLabel> labelEdgeStore;

        DataTarget() {
        }

        void install(DeltaHostGraph child) {
            child.edgeSet = this.edgeSet;
            child.nodeEdgeStore = this.nodeEdgeStore;
            child.nodeInEdgeStore = this.nodeInEdgeStore;
            child.nodeOutEdgeStore = this.nodeOutEdgeStore;
            child.labelEdgeStore = this.labelEdgeStore;
            child.delta = null;
            child.basis = null;
        }

        @Override
        public boolean addNode(HostNode node) {
            boolean fresh = this.addKeyToStore(this.nodeEdgeStore, node);
            assert (fresh) : String.format("Node %s already occured in graph", node);
            this.addKeyToStore(this.nodeInEdgeStore, node);
            this.addKeyToStore(this.nodeOutEdgeStore, node);
            return true;
        }

        @Override
        public boolean removeNode(HostNode node) {
            HostEdgeSet edges = this.removeKeyFromStore(this.nodeEdgeStore, node);
            assert (edges != null) : String.format("Node %s did not occur in graph", node);
            assert (edges.isEmpty()) : String.format("Node %s still had incident edges %s", node, edges);
            this.removeKeyFromStore(this.nodeOutEdgeStore, node);
            this.removeKeyFromStore(this.nodeInEdgeStore, node);
            return true;
        }

        final boolean addEdge(HostEdge edge, boolean refreshSource, boolean refreshTarget, boolean refreshLabel) {
            boolean result = this.edgeSet.add(edge);
            assert (result) : String.format("Edge %s already occured in graph", edge);
            HostNode source = edge.source();
            HostNode target = edge.target();
            this.addToEdgeToStore(this.nodeEdgeStore, source, edge, refreshSource);
            if (source != target) {
                this.addToEdgeToStore(this.nodeEdgeStore, target, edge, refreshTarget);
            }
            this.addToEdgeToStore(this.nodeOutEdgeStore, source, edge, refreshSource);
            this.addToEdgeToStore(this.nodeInEdgeStore, target, edge, refreshTarget);
            this.addToEdgeToStore(this.labelEdgeStore, edge.label(), edge, refreshLabel);
            return result;
        }

        final boolean removeEdge(HostEdge edge, boolean refreshSource, boolean refreshTarget, boolean refreshLabel) {
            boolean result = this.edgeSet.remove(edge);
            assert (result) : String.format("Edge %s did not occur in graph", edge);
            HostNode source = edge.source();
            HostNode target = edge.target();
            this.removeEdgeFromStore(this.nodeEdgeStore, source, edge, refreshSource);
            if (source != target) {
                this.removeEdgeFromStore(this.nodeEdgeStore, target, edge, refreshTarget);
            }
            this.removeEdgeFromStore(this.nodeOutEdgeStore, source, edge, refreshSource);
            this.removeEdgeFromStore(this.nodeInEdgeStore, target, edge, refreshTarget);
            this.removeEdgeFromStore(this.labelEdgeStore, edge.label(), edge, refreshLabel);
            return result;
        }

        private <T> boolean addKeyToStore(HostEdgeStore<T> map, T key) {
            boolean result = true;
            if (map != null) {
                result = map.addKey(key);
            }
            return result;
        }

        private <T> HostEdgeSet removeKeyFromStore(HostEdgeStore<T> map, T key) {
            HostEdgeSet result = null;
            if (map != null) {
                result = (HostEdgeSet)map.remove(key);
            }
            return result;
        }

        private <T> HostEdgeSet addToEdgeToStore(HostEdgeStore<T> map, T key, HostEdge edge, boolean refresh) {
            HostEdgeSet result = null;
            if (map != null) {
                result = map.addEdge(key, edge, refresh);
            }
            return result;
        }

        private <T> HostEdgeSet removeEdgeFromStore(HostEdgeStore<T> store, T key, HostEdge edge, boolean refresh) {
            HostEdgeSet result = null;
            if (store != null) {
                result = store.removeEdge(key, edge, refresh);
            }
            return result;
        }
    }

    private class SwingTarget
    extends DataTarget {
        public SwingTarget() {
            DeltaHostGraph graph = DeltaHostGraph.this;
            this.edgeSet = graph.edgeSet;
            this.nodeEdgeStore = graph.nodeEdgeStore;
            this.nodeInEdgeStore = graph.nodeInEdgeStore;
            this.nodeOutEdgeStore = graph.nodeOutEdgeStore;
            this.labelEdgeStore = graph.labelEdgeStore;
        }

        @Override
        public boolean addEdge(HostEdge elem) {
            return super.addEdge(elem, false, false, false);
        }

        @Override
        public boolean removeEdge(HostEdge elem) {
            return super.removeEdge(elem, false, false, false);
        }

        @Override
        void install(DeltaHostGraph child) {
            DeltaHostGraph graph = DeltaHostGraph.this;
            graph.edgeSet = null;
            graph.nodeEdgeStore = null;
            graph.nodeInEdgeStore = null;
            graph.nodeOutEdgeStore = null;
            graph.labelEdgeStore = null;
            if (graph.delta == null) {
                graph.basis = child;
                graph.delta = ((DeltaStore)child.delta).invert(true);
            }
            super.install(child);
        }
    }
}

