/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.model;

import groove.control.CtrlAut;
import groove.control.CtrlLoader;
import groove.grammar.Action;
import groove.grammar.Recipe;
import groove.grammar.Rule;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.model.ResourceModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CompositeControlModel
extends ResourceModel<CtrlAut> {
    private final CtrlLoader loader = new CtrlLoader();
    private Map<String, Set<String>> ruleRecipeMap;

    CompositeControlModel(GrammarModel grammar) {
        super(grammar, ResourceKind.CONTROL, "control");
    }

    @Override
    public Object getSource() {
        return null;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    CtrlAut compute() throws FormatException {
        block13: {
            errors = this.createErrors();
            this.loader.init(this.getGrammar().getProperties().getAlgebraFamily(), this.getRules());
            controlNames = this.getGrammar().getActiveNames(ResourceKind.CONTROL);
            block6: for (String controlName : controlNames) {
                controlModel = this.getGrammar().getControlModel(controlName);
                if (controlModel == null) {
                    errors.add("Control program '%s' cannot be found", new Object[]{controlName});
                    continue;
                }
                try {
                    this.loader.parse(controlName, controlModel.getProgram());
                    continue;
                }
                catch (FormatException exc) {
                    ** for (error : exc.getErrors())
                }
lbl-1000:
                // 1 sources

                {
                    errors.add("Error in control program '%s': %s", new Object[]{controlName, error, controlModel});
                    continue;
lbl18:
                    // 1 sources

                }
            }
            errors.throwException();
            result = null;
            programNames = new ArrayList<String>();
            block8: for (String controlName : controlNames) {
                try {
                    aut = this.loader.buildAutomaton(controlName);
                    if (aut == null) continue;
                    result = aut;
                    programNames.add(controlName);
                    continue;
                }
                catch (FormatException exc) {
                    controlModel = this.getGrammar().getControlModel(controlName);
                    ** for (error : exc.getErrors())
                }
lbl-1000:
                // 1 sources

                {
                    errors.add("Error in control program '%s': %s", new Object[]{controlName, error, controlModel});
                    continue;
lbl36:
                    // 1 sources

                }
            }
            if (programNames.size() > 1) {
                errors.add("Duplicate control programs %s", new Object[]{programNames});
            }
            try {
                result = result == null ? this.loader.buildDefaultAutomaton() : result.normalise();
                break block13;
            }
            catch (FormatException e) {
                ** for (error : e.getErrors())
            }
lbl-1000:
            // 1 sources

            {
                errors.add("Error in composite control program: %s", new Object[]{error});
                continue;
            }
        }
        errors.throwException();
        result.setFixed();
        return result;
    }

    public Collection<Action> getActions() {
        this.synchronise();
        return this.loader.getActions();
    }

    public Collection<Recipe> getRecipes() {
        this.synchronise();
        return this.loader.getRecipes();
    }

    public CtrlLoader getLoader() {
        return this.loader;
    }

    public Set<String> getRecipes(String rule) {
        Set<String> result = this.getRuleRecipeMap().get(rule);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    private Map<String, Set<String>> getRuleRecipeMap() {
        Map<String, Set<String>> result = this.ruleRecipeMap;
        if (result == null) {
            result = this.ruleRecipeMap = new HashMap<String, Set<String>>();
            for (Recipe recipe : this.getRecipes()) {
                Set<Rule> subrules = recipe.getRules();
                if (subrules == null) continue;
                for (Rule subrule : subrules) {
                    String subruleName = subrule.getFullName();
                    Set<String> recipes = this.ruleRecipeMap.get(subruleName);
                    if (recipes == null) {
                        recipes = new HashSet<String>();
                        this.ruleRecipeMap.put(subruleName, recipes);
                    }
                    recipes.add(recipe.getFullName());
                }
            }
        }
        return result;
    }

    @Override
    void notifyWillRebuild() {
        this.ruleRecipeMap = null;
        super.notifyWillRebuild();
    }
}

