/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.rule;

import groove.grammar.AnchorKind;
import groove.grammar.rule.AnchorKey;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleNode;
import groove.grammar.type.TypeGuard;
import groove.grammar.type.TypeNode;
import groove.graph.ANode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultRuleNode
extends ANode
implements RuleNode,
AnchorKey {
    private final boolean sharp;
    private final TypeNode type;
    private final List<TypeGuard> typeGuards;
    private Set<LabelVar> vars;
    private final Set<TypeNode> matchingTypes;

    protected DefaultRuleNode(int nr, TypeNode type, boolean sharp, List<TypeGuard> typeGuards) {
        super(nr);
        assert (type != null) : "Can't instantiate untyped rule node";
        this.type = type;
        this.sharp = sharp;
        if (typeGuards == null) {
            this.typeGuards = Collections.emptyList();
            this.matchingTypes = type.getSubtypes();
        } else {
            this.typeGuards = new ArrayList<TypeGuard>();
            this.matchingTypes = new HashSet<TypeNode>();
            if (sharp) {
                this.matchingTypes.add(type);
            } else {
                this.matchingTypes.addAll(type.getSubtypes());
            }
            for (TypeGuard guard : typeGuards) {
                guard.filter(this.matchingTypes);
                if (!guard.isNamed()) continue;
                this.typeGuards.add(guard);
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        DefaultRuleNode other = (DefaultRuleNode)obj;
        if (this.getType() == null) {
            return other.getType() == null;
        }
        return this.getType().equals(other.getType());
    }

    @Override
    protected int computeHashCode() {
        int result = super.computeHashCode();
        int prime = 31;
        if (this.getType() != null) {
            result = prime * result + this.getType().hashCode();
        }
        return result;
    }

    @Override
    public String getToStringPrefix() {
        return "n";
    }

    @Override
    public TypeNode getType() {
        return this.type;
    }

    @Override
    public List<TypeGuard> getTypeGuards() {
        return this.typeGuards;
    }

    @Override
    public Set<LabelVar> getVars() {
        Set<LabelVar> result = this.vars;
        if (result == null) {
            result = this.vars = new HashSet<LabelVar>();
            for (TypeGuard guard : this.getTypeGuards()) {
                assert (guard.isNamed());
                result.add(guard.getVar());
            }
        }
        return result;
    }

    @Override
    public Set<TypeNode> getMatchingTypes() {
        return this.matchingTypes;
    }

    @Override
    public boolean isSharp() {
        return this.sharp;
    }

    @Override
    public AnchorKind getAnchorKind() {
        return AnchorKind.NODE;
    }
}

