/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.rule;

import groove.algebra.Operator;
import groove.grammar.AnchorKind;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.VariableNode;
import groove.grammar.type.TypeGuard;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.ANode;
import groove.graph.EdgeRole;
import java.util.List;
import java.util.Set;

public class OperatorNode
extends ANode
implements RuleNode {
    private final List<VariableNode> arguments;
    private final Operator operator;
    private final VariableNode target;
    private static final char TIMES_CHAR = '\u2a09';
    private static final TypeLabel PROD_LABEL = TypeLabel.createLabel(EdgeRole.NODE_TYPE, "\u2a09");

    public OperatorNode(int nr, Operator operator, List<VariableNode> arguments, VariableNode target) {
        super(nr);
        this.operator = operator;
        this.arguments = arguments;
        this.target = target;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OperatorNode)) {
            return false;
        }
        OperatorNode other = (OperatorNode)obj;
        if (this.getNumber() != other.getNumber()) {
            return false;
        }
        if (!this.getOperator().equals(other.getOperator())) {
            return false;
        }
        return this.getTarget().equals(other.getTarget());
    }

    @Override
    protected int computeHashCode() {
        int result = super.computeHashCode();
        result = result * 31 + this.getOperator().hashCode();
        result = result * 31 + this.getTarget().hashCode();
        return result;
    }

    public List<VariableNode> getArguments() {
        return this.arguments;
    }

    public int arity() {
        return this.arguments.size();
    }

    public VariableNode getTarget() {
        return this.target;
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public String getToStringPrefix() {
        return "p";
    }

    @Override
    public TypeNode getType() {
        return this.getTarget().getType();
    }

    @Override
    public List<TypeGuard> getTypeGuards() {
        return EMPTY_GUARD_LIST;
    }

    @Override
    public Set<LabelVar> getVars() {
        return EMPTY_VAR_SET;
    }

    @Override
    public boolean isSharp() {
        return true;
    }

    @Override
    public Set<TypeNode> getMatchingTypes() {
        return EMPTY_MATCH_SET;
    }

    @Override
    public AnchorKind getAnchorKind() {
        return AnchorKind.NODE;
    }
}

