/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.type;

import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.model.FormatException;
import groove.grammar.model.PostApplicationError;
import groove.grammar.type.Multiplicity;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EdgeMultiplicityVerifier {
    private final Map<TypeNode, Map<TypeEdge, MultiplicityVerifier>> inVerifyMap = new HashMap<TypeNode, Map<TypeEdge, MultiplicityVerifier>>();
    private final Map<TypeNode, Map<TypeEdge, MultiplicityVerifier>> outVerifyMap = new HashMap<TypeNode, Map<TypeEdge, MultiplicityVerifier>>();
    private final Set<MultiplicityVerifier> verifiers = new HashSet<MultiplicityVerifier>();
    private final Set<PostApplicationError> errors = new HashSet<PostApplicationError>();

    public EdgeMultiplicityVerifier(TypeGraph type) {
        for (TypeEdge edge : type.edgeSet()) {
            MultiplicityVerifier verifier;
            if (edge.getInMult() != null) {
                verifier = new MultiplicityVerifier(edge, InOrOut.MULT_IN);
                this.verifiers.add(verifier);
                for (TypeNode node : type.getSubtypes((TypeNode)edge.target())) {
                    this.mapVerifier(node, edge, verifier, this.inVerifyMap);
                }
            }
            if (edge.getOutMult() == null) continue;
            verifier = new MultiplicityVerifier(edge, InOrOut.MULT_OUT);
            this.verifiers.add(verifier);
            for (TypeNode node : type.getSubtypes((TypeNode)edge.source())) {
                this.mapVerifier(node, edge, verifier, this.outVerifyMap);
            }
        }
    }

    private void mapVerifier(TypeNode node, TypeEdge edge, MultiplicityVerifier verifier, Map<TypeNode, Map<TypeEdge, MultiplicityVerifier>> map) {
        Map<TypeEdge, MultiplicityVerifier> innerMap = map.get(node);
        if (innerMap == null) {
            innerMap = new HashMap<TypeEdge, MultiplicityVerifier>();
            map.put(node, innerMap);
        }
        innerMap.put(edge, verifier);
    }

    public void reset() {
        for (MultiplicityVerifier verifier : this.verifiers) {
            verifier.reset();
        }
        this.errors.clear();
    }

    private void count(HostGraph graph, HostNode node) {
        Map<TypeEdge, MultiplicityVerifier> outMap;
        Map<TypeEdge, MultiplicityVerifier> inMap = this.inVerifyMap.get(node.getType());
        if (inMap != null) {
            this.count(node, graph.inEdgeSet(node), inMap);
        }
        if ((outMap = this.outVerifyMap.get(node.getType())) != null) {
            this.count(node, graph.outEdgeSet(node), outMap);
        }
    }

    private void count(HostNode node, Set<? extends HostEdge> edges, Map<TypeEdge, MultiplicityVerifier> map) {
        for (MultiplicityVerifier multiplicityVerifier : map.values()) {
            multiplicityVerifier.addNodeCounter(node);
        }
        for (HostEdge hostEdge : edges) {
            MultiplicityVerifier verifier = map.get(hostEdge.getType());
            if (verifier == null) continue;
            verifier.incNodeCounter(node);
        }
    }

    public void count(HostGraph graph) {
        if (!this.verifiers.isEmpty()) {
            for (HostNode node : graph.nodeSet()) {
                this.count(graph, node);
            }
        }
    }

    public boolean check(Object source) {
        for (MultiplicityVerifier verifier : this.verifiers) {
            verifier.checkCounters(source);
        }
        return !this.hasError();
    }

    public Set<PostApplicationError> getErrors() {
        return new HashSet<PostApplicationError>(this.errors);
    }

    public boolean hasError() {
        return !this.errors.isEmpty();
    }

    private PostApplicationError multError(HostNode node, TypeLabel type, int count, Multiplicity mult, InOrOut direction, Object source) {
        String directionText;
        switch (direction) {
            case MULT_IN: {
                directionText = "'in'";
                break;
            }
            default: {
                directionText = "'out'";
            }
        }
        String msg = String.valueOf(directionText) + " multiplicity of edge '" + type + "' in node '%s' is out of range (got: " + count + "; required: " + mult.one() + ".." + (mult.isUnbounded() ? "*" : (Serializable)mult.two()) + ")";
        return new PostApplicationError(msg, node, source);
    }

    public static void verifyMultiplicities(HostGraph graph, TypeGraph typeGraph) throws FormatException {
        EdgeMultiplicityVerifier verifier = new EdgeMultiplicityVerifier(typeGraph);
        verifier.count(graph);
        if (!verifier.check(graph)) {
            throw new FormatException(verifier.getErrors());
        }
    }

    private static class Counter {
        public int value;

        public Counter(int initialValue) {
            this.value = initialValue;
        }

        public void inc() {
            ++this.value;
        }
    }

    private static enum InOrOut {
        MULT_IN,
        MULT_OUT;

    }

    private class MultiplicityVerifier {
        private final TypeEdge typeEdge;
        private final InOrOut direction;
        private final Map<HostNode, Counter> counters;

        public MultiplicityVerifier(TypeEdge typeEdge, InOrOut direction) {
            this.typeEdge = typeEdge;
            this.direction = direction;
            this.counters = new HashMap<HostNode, Counter>();
        }

        public void reset() {
            this.counters.clear();
        }

        public void addNodeCounter(HostNode node) {
            this.counters.put(node, new Counter(0));
        }

        public void incNodeCounter(HostNode node) {
            this.counters.get(node).inc();
        }

        public void checkCounters(Object source) {
            for (Map.Entry<HostNode, Counter> entry : this.counters.entrySet()) {
                Multiplicity mult;
                HostNode node = entry.getKey();
                int count = entry.getValue().value;
                switch (this.direction) {
                    case MULT_IN: {
                        mult = this.typeEdge.getInMult();
                        break;
                    }
                    default: {
                        mult = this.typeEdge.getOutMult();
                    }
                }
                if (mult.inRange(count)) continue;
                EdgeMultiplicityVerifier.this.errors.add(EdgeMultiplicityVerifier.this.multError(node, (TypeLabel)this.typeEdge.label(), count, mult, this.direction, source));
            }
        }
    }
}

